#include <rtthread.h>
#include <rtdevice.h>
#include <board.h>

#include <string.h>
#include <stdio.h>
#include "ssd1306.h"
#include "screen.h"



void rtt_scrinit(void)
{
    ssd1306_Init();
    ssd1306_SetCursor(50,0);
    ssd1306_WriteString("WOC",Font_6x8,White);
    ssd1306_SetCursor(0,8);
    ssd1306_WriteString("Rol_X:",Font_11x18,White);
    ssd1306_SetCursor(0,8+18);
    ssd1306_WriteString("Pit_Y:",Font_11x18,White);
    ssd1306_SetCursor(0,8+18+18);
    ssd1306_WriteString("Yaw_Z:",Font_11x18,White);
    ssd1306_UpdateScreen();
}

void s1_screen(void)
{
    char  screensh[26]={0};
    uint16_t num_u8=666;
    sprintf(screensh,"WOC nb %d",num_u8);
    ssd1306_SetCursor(20,0);
    ssd1306_WriteString(screensh,Font_6x8,White);
    ssd1306_SetCursor(20,0+8);
    ssd1306_WriteString(screensh,Font_7x10,White);
    ssd1306_SetCursor(20,0+8+10);
    ssd1306_WriteString(screensh,Font_11x18,White);
    ssd1306_SetCursor(20,0+8+10+18);
    ssd1306_WriteString(screensh,Font_16x26,White);
    ssd1306_UpdateScreen();
}

#ifdef FINSH_USING_MSH
MSH_CMD_EXPORT(rtt_scrinit,Screen init);
//MSH_CMD_EXPORT(s1_screen,s1_screen);
#endif
