
#ifndef __msp430x14x
#define __msp430x14x

/************************************************************
* STANDARD BITS
************************************************************/

#define BIT0                0x0001
#define BIT1                0x0002
#define BIT2                0x0004
#define BIT3                0x0008
#define BIT4                0x0010
#define BIT5                0x0020
#define BIT6                0x0040
#define BIT7                0x0080
#define BIT8                0x0100
#define BIT9                0x0200
#define BITA                0x0400
#define BITB                0x0800
#define BITC                0x1000
#define BITD                0x2000
#define BITE                0x4000
#define BITF                0x8000

/************************************************************
* STATUS REGISTER BITS
************************************************************/

#define C                   0x0001
#define Z                   0x0002
#define N                   0x0004
#define V                   0x0100
#define GIE                 0x0008
#define CPUOFF              0x0010
#define OSCOFF              0x0020
#define SCG0                0x0040
#define SCG1                0x0080

/* Low Power Modes coded with Bits 4-7 in SR */

#ifndef __IAR_SYSTEMS_ICC /* Begin #defines for assembler */
#define LPM0                CPUOFF
#define LPM1                SCG0+CPUOFF
#define LPM2                SCG1+CPUOFF
#define LPM3                SCG1+SCG0+CPUOFF
#define LPM4                SCG1+SCG0+OSCOFF+CPUOFF
/* End #defines for assembler */

#else /* Begin #defines for C */
#define LPM0_bits           CPUOFF
#define LPM1_bits           SCG0+CPUOFF
#define LPM2_bits           SCG1+CPUOFF
#define LPM3_bits           SCG1+SCG0+CPUOFF
#define LPM4_bits           SCG1+SCG0+OSCOFF+CPUOFF

#include <In430.h>

#define LPM0      _BIS_SR(LPM0_bits) /* Enter Low Power Mode 0 */
#define LPM0_EXIT _BIC_SR(LPM0_bits) /* Exit Low Power Mode 0 */
#define LPM1      _BIS_SR(LPM1_bits) /* Enter Low Power Mode 1 */
#define LPM1_EXIT _BIC_SR(LPM1_bits) /* Exit Low Power Mode 1 */
#define LPM2      _BIS_SR(LPM2_bits) /* Enter Low Power Mode 2 */
#define LPM2_EXIT _BIC_SR(LPM2_bits) /* Exit Low Power Mode 2 */
#define LPM3      _BIS_SR(LPM3_bits) /* Enter Low Power Mode 3 */
#define LPM3_EXIT _BIC_SR(LPM3_bits) /* Exit Low Power Mode 3 */
#define LPM4      _BIS_SR(LPM4_bits) /* Enter Low Power Mode 4 */
#define LPM4_EXIT _BIC_SR(LPM4_bits) /* Exit Low Power Mode 4 */
#endif /* End #defines for C */

/************************************************************
* PERIPHERAL FILE MAP
************************************************************/

/************************************************************
* ⹦ܼĴַͿλ
************************************************************/
/*жʹ1*/
#define IE1_                0x0000  
sfrb    IE1               = IE1_;
#define WDTIE               0x01     /*Źжʹ*/       
#define OFIE                0x02     /*ⲿжʹ*/ 
#define NMIIE               0x10     /*жʹ*/
#define ACCVIE              0x20     /*жʹ/flashджϴ*/
#define URXIE0              0x40     /*0жʹ*/
#define UTXIE0              0x80     /*0жʹ*/
/*жϱ־1*/
#define IFG1_               0x0002  
sfrb    IFG1              = IFG1_; 
#define WDTIFG              0x01     /*Źжϱ־*/
#define OFIFG               0x02     /*ⲿжϱ־*/
#define NMIIFG              0x10     /*жϱ־*/
#define URXIFG0             0x40     /*0жϱ־*/
#define UTXIFG0             0x80     /*0жϱ־*/
 /* жģʽʹ1 */
#define ME1_                0x0004 
sfrb    ME1               = ME1_;
#define URXE0               0x40        /* 0жģʽʹ */
#define USPIE0              0x40        /* ͬжģʽʹ */
#define UTXE0               0x80        /* 0жģʽʹ */
/* жʹ2 */
#define IE2_                0x0001  
sfrb    IE2               = IE2_;
#define URXIE1              0x10       /* 1жʹ */
#define UTXIE1              0x20       /* 1жʹ */
/* жϱ־2 */
#define IFG2_               0x0003  
sfrb    IFG2              = IFG2_;
#define URXIFG1             0x10         /* 1жϱ־ */
#define UTXIFG1             0x20         /* 1жϱ־ */
/* жģʽʹ2 */
#define ME2_                0x0005  
sfrb    ME2               = ME2_;
#define URXE1               0x10         /* 1жģʽʹ */
#define USPIE1              0x10         /* ͬжģʽʹ */
#define UTXE1               0x20         /* 1жģʽʹ */

/************************************************************
*           ŹʱļĴ
************************************************************/

#define WDTCTL_             0x0120 
sfrw    WDTCTL            = WDTCTL_;
#define WDTIS0              0x0001          /*ѡWDTCNTĸ֮һ*/
#define WDTIS1              0x0002          /*ѡWDTCNTĸ֮һ*/
#define WDTSSEL             0x0004          /*ѡWDTCNTʱԴ*/
#define WDTCNTCL            0x0008          /*WDTCNT: Ϊ1ʱ 0ʼ*/   
#define WDTTMSEL            0x0010          /*ѡģʽ  0: Źģʽ; 1: ʱģʽ*/ 
#define WDTNMI              0x0020          /*ѡNMI/RST Ź 0:Ϊ RST; 1:ΪNMI*/
#define WDTNMIES            0x0040          /*WDTNMI=1ʱ.ѡ񴥷 0:Ϊ 1:Ϊ½*/ 
#define WDTHOLD             0x0080          /*ֹͣŹʱ 0:;1:ֹͣ*/

#define WDTPW               0x5A00          /* д:߰λ*/ 


/* SMCLK= 1MHzʱģʽ */
#define WDT_MDLY_32         WDTPW+WDTTMSEL+WDTCNTCL                         /* TSMCLK*2POWER15=32ms λ״̬ */
#define WDT_MDLY_8          WDTPW+WDTTMSEL+WDTCNTCL+WDTIS0                  /* TSMCLK*2POWER13=8.192ms     " */
#define WDT_MDLY_0_5        WDTPW+WDTTMSEL+WDTCNTCL+WDTIS1                  /* TSMCLK*2POWER9=0.512ms   " */
#define WDT_MDLY_0_064      WDTPW+WDTTMSEL+WDTCNTCL+WDTIS1+WDTIS0           /* TSMCLK*2POWER6=0.512ms " */
/* ACLK=32.768KHz ʱģʽ*/
#define WDT_ADLY_1000       WDTPW+WDTTMSEL+WDTCNTCL+WDTSSEL                 /* TACLK*2POWER15=1000ms  " */
#define WDT_ADLY_250        WDTPW+WDTTMSEL+WDTCNTCL+WDTSSEL+WDTIS0          /* TACLK*2POWER13=250ms   " */
#define WDT_ADLY_16         WDTPW+WDTTMSEL+WDTCNTCL+WDTSSEL+WDTIS1          /* TACLK*2POWER9=16ms    " */
#define WDT_ADLY_1_9        WDTPW+WDTTMSEL+WDTCNTCL+WDTSSEL+WDTIS1+WDTIS0   /* TACLK*2POWER6=1.9ms   " */
/* SMCLK=1MHzŹģʽ */
#define WDT_MRST_32         WDTPW+WDTCNTCL                                  /* TSMCLK*2POWER15=32ms λ״̬  */
#define WDT_MRST_8          WDTPW+WDTCNTCL+WDTIS0                           /* TSMCLK*2POWER13=8.192ms   " */
#define WDT_MRST_0_5        WDTPW+WDTCNTCL+WDTIS1                           /* TSMCLK*2POWER9=0.512ms  " */
#define WDT_MRST_0_064      WDTPW+WDTCNTCL+WDTIS1+WDTIS0                    /* TSMCLK*2POWER6=0.512ms " */
/* ACLK=32KHzŹģʽ */
#define WDT_ARST_1000       WDTPW+WDTCNTCL+WDTSSEL                          /* TACLK*2POWER15=1000ms  " */
#define WDT_ARST_250        WDTPW+WDTCNTCL+WDTSSEL+WDTIS0                   /* TACLK*2POWER13=250ms   " */
#define WDT_ARST_16         WDTPW+WDTCNTCL+WDTSSEL+WDTIS1                   /* TACLK*2POWER9=16ms    " */
#define WDT_ARST_1_9        WDTPW+WDTCNTCL+WDTSSEL+WDTIS1+WDTIS0            /* TACLK*2POWER6=1.9ms   " */



/************************************************************
             Ӳ˷ļĴ
************************************************************/

#define MPY_                0x0130  /* ޷ų˷ */
sfrw    MPY               = MPY_;
#define MPYS_               0x0132  /* зų˷*/
sfrw    MPYS              = MPYS_;
#define MAC_                0x0134  /* ޷ų˼ */
sfrw    MAC               = MAC_;
#define MACS_               0x0136  /* зų˼ */
sfrw    MACS              = MACS_;
#define OP2_                0x0138  /* ڶ */
sfrw    OP2               = OP2_;
#define RESLO_              0x013A  /* 6λĴ */
sfrw    RESLO             = RESLO_;
#define RESHI_              0x013C  /* 6λĴ */
sfrw    RESHI             = RESHI_;
#define SUMEXT_             0x013E  /*չĴ  */
const sfrw SUMEXT         = SUMEXT_;

/************************************************************
* DIGITAL I/O Port1/2 Ĵ жϹ
************************************************************/

#define P1IN_               0x0020  /* P1 Ĵ */
const sfrb P1IN           = P1IN_;
#define P1OUT_              0x0021  /* P1 Ĵ */
sfrb    P1OUT             = P1OUT_;
#define P1DIR_              0x0022  /* P1 ѡĴ */
sfrb    P1DIR             = P1DIR_;
#define P1IFG_              0x0023  /* P1 жϱ־Ĵ*/
sfrb    P1IFG             = P1IFG_;
#define P1IES_              0x0024  /* P1 жϱѡĴ*/
sfrb    P1IES             = P1IES_;
#define P1IE_               0x0025  /* P1 жʹܼĴ */
sfrb    P1IE              = P1IE_;
#define P1SEL_              0x0026  /* P1 ѡĴ*/
sfrb    P1SEL             = P1SEL_;

#define P2IN_               0x0028  /* P2 Ĵ */
const sfrb P2IN           = P2IN_;
#define P2OUT_              0x0029  /* P2 Ĵ  */
sfrb    P2OUT             = P2OUT_;
#define P2DIR_              0x002A  /* P2 ѡĴ  */
sfrb    P2DIR             = P2DIR_;
#define P2IFG_              0x002B  /* P2 жϱ־Ĵ */
sfrb    P2IFG             = P2IFG_;
#define P2IES_              0x002C  /* P2 жϱѡĴ */
sfrb    P2IES             = P2IES_;
#define P2IE_               0x002D  /* P2 жʹܼĴ */
sfrb    P2IE              = P2IE_;
#define P2SEL_              0x002E  /* P2 ѡĴ */
sfrb    P2SEL             = P2SEL_;

/************************************************************
* DIGITAL I/O Port3/4Ĵ жϹ
************************************************************/

#define P3IN_               0x0018  /* P3 Ĵ */
const sfrb P3IN           = P3IN_;
#define P3OUT_              0x0019  /* P3 Ĵ */
sfrb    P3OUT             = P3OUT_;
#define P3DIR_              0x001A  /* P3 ѡĴ */
sfrb    P3DIR             = P3DIR_;
#define P3SEL_              0x001B  /* P3 ѡĴ*/
sfrb    P3SEL             = P3SEL_;

#define P4IN_               0x001C  /* P4 Ĵ */
const sfrb P4IN           = P4IN_;
#define P4OUT_              0x001D  /* P4 Ĵ */
sfrb    P4OUT             = P4OUT_;
#define P4DIR_              0x001E  /* P4 ѡĴ */
sfrb    P4DIR             = P4DIR_;
#define P4SEL_              0x001F  /* P4 ѡĴ */
sfrb    P4SEL             = P4SEL_;

/************************************************************
* DIGITAL I/O Port5/6       I/OڼĴPORT56  жϹ

************************************************************/

#define P5IN_               0x0030  /* P5 Ĵ */
const sfrb P5IN           = P5IN_;
#define P5OUT_              0x0031  /* P5 Ĵ*/
sfrb    P5OUT             = P5OUT_;
#define P5DIR_              0x0032  /* P5 ѡĴ*/
sfrb    P5DIR             = P5DIR_;
#define P5SEL_              0x0033  /* P5 ѡĴ*/
sfrb    P5SEL             = P5SEL_;

#define P6IN_               0x0034  /* P6 Ĵ */
const sfrb P6IN           = P6IN_;
#define P6OUT_              0x0035  /* P6 Ĵ*/
sfrb    P6OUT             = P6OUT_;
#define P6DIR_              0x0036  /* P6 ѡĴ*/
sfrb    P6DIR             = P6DIR_;
#define P6SEL_              0x0037  /* P6 ѡĴ*/
sfrb    P6SEL             = P6SEL_;

/************************************************************
* USART   ڼĴ"UCTL","UTCTL","URCTL"ĸλ ɴ1 2
************************************************************/
/* UCTL  ڿƼĴ*/  
#define PENA                0x80        /*Уλ*/
#define PEV                 0x40        /*żУ   Ϊ0ʱΪУ*/
#define SPB                 0x20        /*ֹͣλΪ2 Ϊ0ʱֹͣλΪ1*/
#define CHAR                0x10        /*λΪ8λ Ϊ0ʱλΪ7λ*/
#define LISTEN              0x08        /*Իģʽ(ͬʱڰѷݽջ)*/
#define SYNC                0x04        /*ͬģʽ  Ϊ0첽ģʽ*/
#define MM                  0x02        /*Ϊ1ʱַλЭ(첽) ģʽ(ͬ);Ϊ0ʱ·жЭ(첽) ӻģʽ(ͬ)*/
#define SWRST               0x01        /*λ*/

/* UTCTL ڷͿƼĴ*/
#define CKPH                0x80        /*ʱλλ(ֻͬʽ)Ϊ1ʱʱUCLKʱ*/    
#define CKPL                0x40        /*ʱӼԿλ Ϊ1ʱ첽UCLK෴;ͬ½Ч*/
#define SSEL1               0x20        /*ʱԴѡλ:SSEL0Ϊ0,1,2,3ַʽ*/
#define SSEL0               0x10        /*"0"ѡⲿʱ,"1"ѡʱ,"2","3"ѡϵͳʱ */
#define URXSE               0x08        /*մӿλ(ֻ첽ʽ)*/
#define TXWAKE              0x04        /*ദͨŴͿλ(ֻ첽ʽ)*/
#define STC                 0x02        /*ⲿSTEѡλ Ϊ0ʱΪ4ģʽ Ϊ1ʱΪ3ģʽ*/
#define TXEPT               0x01        /*ձ־*/

/* URCTL ڽտƼĴ                ͬģʽֻλ:FEOE*/
#define FE                  0x80         /*֡־*/           
#define PE                  0x40         /*У־λ*/
#define OE                  0x20         /*־λ*/
#define BRK                 0x10         /*ϼλ*/
#define URXEIE              0x08         /*ճжλ*/
#define URXWIE              0x04         /*ջжλ*/
#define RXWAKE              0x02         /*ջѼλ*/
#define RXERR               0x01         /*մ־λ*/

/************************************************************
* USART 0           0Ĵ
************************************************************/

#define U0CTL_              0x0070  /*  0ƼĴ */
sfrb    U0CTL             = U0CTL_;
#define U0TCTL_             0x0071  /* 0ͿƼĴ */
sfrb    U0TCTL            = U0TCTL_;
#define U0RCTL_             0x0072  /* 0տƼĴ */
sfrb    U0RCTL            = U0RCTL_;
#define U0MCTL_             0x0073  /* ʵĴ */
sfrb    U0MCTL            = U0MCTL_;
#define U0BR0_              0x0074  /* ѡĴ0 */
sfrb    U0BR0             = U0BR0_;
#define U0BR1_              0x0075  /* ѡĴ1 */
sfrb    U0BR1             = U0BR1_;
#define U0RXBUF_            0x0076  /* ջĴ */
const sfrb U0RXBUF        = U0RXBUF_;
#define U0TXBUF_            0x0077  /* ͻĴ */
sfrb    U0TXBUF           = U0TXBUF_;

/* ıļĴ */

#define UCTL0_              0x0070  /* UART 0 Control */
sfrb    UCTL0             = UCTL0_;
#define UTCTL0_             0x0071  /* UART 0 Transmit Control */
sfrb    UTCTL0            = UTCTL0_;
#define URCTL0_             0x0072  /* UART 0 Receive Control */
sfrb    URCTL0            = URCTL0_;
#define UMCTL0_             0x0073  /* UART 0 Modulation Control */
sfrb    UMCTL0            = UMCTL0_;
#define UBR00_              0x0074  /* UART 0 Baud Rate 0 */
sfrb    UBR00             = UBR00_;
#define UBR10_              0x0075  /* UART 0 Baud Rate 1 */
sfrb    UBR10             = UBR10_;
#define RXBUF0_             0x0076  /* UART 0 Receive Buffer */
const sfrb RXBUF0         = RXBUF0_;
#define TXBUF0_             0x0077  /* UART 0 Transmit Buffer */
sfrb    TXBUF0            = TXBUF0_;

#define UCTL_0_             0x0070  /* UART 0 Control */
sfrb    UCTL_0            = UCTL_0_;
#define UTCTL_0_            0x0071  /* UART 0 Transmit Control */
sfrb    UTCTL_0           = UTCTL_0_;
#define URCTL_0_            0x0072  /* UART 0 Receive Control */
sfrb    URCTL_0           = URCTL_0_;
#define UMCTL_0_            0x0073  /* UART 0 Modulation Control */
sfrb    UMCTL_0           = UMCTL_0_;
#define UBR0_0_             0x0074  /* UART 0 Baud Rate 0 */
sfrb    UBR0_0            = UBR0_0_;
#define UBR1_0_             0x0075  /* UART 0 Baud Rate 1 */
sfrb    UBR1_0            = UBR1_0_;
#define RXBUF_0_            0x0076  /* UART 0 Receive Buffer */
const sfrb RXBUF_0        = RXBUF_0_;
#define TXBUF_0_            0x0077  /* UART 0 Transmit Buffer */
sfrb    TXBUF_0           = TXBUF_0_;

/************************************************************
* USART 1         1Ĵ
************************************************************/

#define U1CTL_              0x0078  /* 1ƼĴ */
sfrb    U1CTL             = U1CTL_;
#define U1TCTL_             0x0079  /* 1ͿƼĴ */
sfrb    U1TCTL            = U1TCTL_;
#define U1RCTL_             0x007A  /* 1տƼĴ */
sfrb    U1RCTL            = U1RCTL_;
#define U1MCTL_             0x007B  /* ʵƼĴ */
sfrb    U1MCTL            = U1MCTL_;
#define U1BR0_              0x007C  /* ѡĴ0 */
sfrb    U1BR0             = U1BR0_;
#define U1BR1_              0x007D  /* ѡĴ1 */
sfrb    U1BR1             = U1BR1_;
#define U1RXBUF_            0x007E  /* ջ */
const sfrb U1RXBUF        = U1RXBUF_;
#define U1TXBUF_            0x007F  /* ͻ */
sfrb    U1TXBUF           = U1TXBUF_;

/* ıļĴ */

#define UCTL1_              0x0078  /* UART 1 Control */
sfrb    UCTL1             = UCTL1_;
#define UTCTL1_             0x0079  /* UART 1 Transmit Control */
sfrb    UTCTL1            = UTCTL1_;
#define URCTL1_             0x007A  /* UART 1 Receive Control */
sfrb    URCTL1            = URCTL1_;
#define UMCTL1_             0x007B  /* UART 1 Modulation Control */
sfrb    UMCTL1            = UMCTL1_;
#define UBR01_               0x007C  /* UART 1 Baud Rate 0 */
sfrb    UBR01             = UBR01_;
#define UBR11_              0x007D  /* UART 1 Baud Rate 1 */
sfrb    UBR11             = UBR11_;
#define RXBUF1_             0x007E  /* UART 1 Receive Buffer */
const sfrb RXBUF1         = RXBUF1_;
#define TXBUF1_             0x007F  /* UART 1 Transmit Buffer */
sfrb    TXBUF1            = TXBUF1_;

#define UCTL_1_             0x0078  /* UART 1 Control */
sfrb    UCTL_1            = UCTL_1_;
#define UTCTL_1_            0x0079  /* UART 1 Transmit Control */
sfrb    UTCTL_1           = UTCTL_1_;
#define URCTL_1_            0x007A  /* UART 1 Receive Control */
sfrb    URCTL_1           = URCTL_1_;
#define UMCTL_1_            0x007B  /* UART 1 Modulation Control */
sfrb    UMCTL_1           = UMCTL_1_;
#define UBR0_1_             0x007C  /* UART 1 Baud Rate 0 */
sfrb    UBR0_1            = UBR0_1_;
#define UBR1_1_             0x007D  /* UART 1 Baud Rate 1 */
sfrb    UBR1_1            = UBR1_1_;
#define RXBUF_1_            0x007E  /* UART 1 Receive Buffer */
const sfrb RXBUF_1        = RXBUF_1_;
#define TXBUF_1_            0x007F  /* UART 1 Transmit Buffer */
sfrb    TXBUF_1           = TXBUF_1_;

/************************************************************
* Timer A             ʱAĴ
************************************************************/

#define TAIV_               0x012E  /* Timer A жĴ */
sfrw    TAIV              = TAIV_;
#define TACTL_              0x0160  /* Timer A ƼĴ */
sfrw    TACTL             = TACTL_;
#define TACCTL0_            0x0162  /* Timer A /ȽϿƼĴ0 */
sfrw    TACCTL0           = TACCTL0_;
#define TACCTL1_            0x0164  /* Timer A /ȽϿƼĴ1 */
sfrw    TACCTL1           = TACCTL1_;
#define TACCTL2_            0x0166  /* Timer A /ȽϿƼĴ2 */
sfrw    TACCTL2           = TACCTL2_;
#define TAR_                0x0170  /* Timer A 16λ*/
sfrw    TAR               = TAR_;
#define TACCR0_             0x0172  /* Timer A /ȽϼĴ0 */
sfrw    TACCR0            = TACCR0_;
#define TACCR1_             0x0174  /* Timer A /ȽϼĴ1 */
sfrw    TACCR1            = TACCR1_;
#define TACCR2_             0x0176  /* Timer A /ȽϼĴ2 */
sfrw    TACCR2            = TACCR2_;

/* ıļĴ */
#define CCTL0_              0x0162  /* Timer A Capture/Compare Control 0 */
sfrw    CCTL0             = CCTL0_;
#define CCTL1_              0x0164  /* Timer A Capture/Compare Control 1 */
sfrw    CCTL1             = CCTL1_;
#define CCTL2_              0x0166  /* Timer A Capture/Compare Control 2 */
sfrw    CCTL2             = CCTL2_;
#define CCR0_               0x0172  /* Timer A Capture/Compare 0 */
sfrw    CCR0              = CCR0_;
#define CCR1_               0x0174  /* Timer A Capture/Compare 1 */
sfrw    CCR1              = CCR1_;
#define CCR2_               0x0176  /* Timer A Capture/Compare 2 */
sfrw    CCR2              = CCR2_;

/*TACTL ƼĴ 16λĴ*/
#define TASSEL2             0x0400  /* δ */
#define TASSEL1             0x0200  /* ʱԴλ1 */
#define TASSEL0             0x0100  /* ʱԴλ0 */
#define ID1                 0x0080  /* Ƶϵѡλ1 */
#define ID0                 0x0040  /* Ƶϵѡλ0 */
#define MC1                 0x0020  /* ģʽλ1 */
#define MC0                 0x0010  /* ģʽλ0 */
#define TACLR               0x0004  /* 1λʱ */
#define TAIE                0x0002  /* ʱж */
#define TAIFG               0x0001  /* ʱжϱ־ */

#define MC_0                00*0x10  /* ֹͣģʽ */
#define MC_1                01*0x10  /* ģʽ */
#define MC_2                02*0x10  /* ģʽ */
#define MC_3                03*0x10  /* /ģʽ */
#define ID_0                00*0x40  /* ֱͨ */
#define ID_1                01*0x40  /* 2Ƶ */
#define ID_2                02*0x40  /* 4Ƶ */
#define ID_3                03*0x40  /* 8Ƶ */
#define TASSEL_0            00*0x100  /* ʱԴΪ TACLK */
#define TASSEL_1            01*0x100  /* ʱԴΪACLK  */
#define TASSEL_2            02*0x100  /* ʱԴΪSMCLK */
#define TASSEL_3            03*0x100  /* ʱԴΪINCLK */

/* Timer A ,Timer B ɹ /ȽϿƼĴX */
#define CM1                 0x8000  /* ģʽѡλ1 */
#define CM0                 0x4000  /* ģʽѡλ0 */
#define CCIS1               0x2000  /* źԴѡλ1 */
#define CCIS0               0x1000  /* źԴѡλ0 */
#define SCS                 0x0800  /* źͬλ 0:첽;1:ͬ */
#define SCCI                0x0400  /* ź */
#define CAP                 0x0100  /* ģʽѡ: 0:Ƚģʽ;1:ģʽ */
#define OUTMOD2             0x0080  /* ģʽѡλ2 */
#define OUTMOD1             0x0040  /* ģʽѡλ1 */
#define OUTMOD0             0x0020  /* ģʽѡλ0 */
#define CCIE                0x0010  /* жλ */
#define CCI                 0x0008  /* źԴλccis0\1 */
#define OUT                 0x0004  /* ź(ѡģʽ0) */
#define COV                 0x0002  /* ־ */
#define CCIFG               0x0001  /* жϱ־ */

#define OUTMOD_0             0*0x20  /* ģʽ */
#define OUTMOD_1             1*0x20  /* λģʽ */
#define OUTMOD_2             2*0x20  /* ת/λģʽ */
#define OUTMOD_3             3*0x20  /* λ/λģʽ */
#define OUTMOD_4             4*0x20  /* תģʽ */
#define OUTMOD_5             5*0x20  /* λģʽ */
#define OUTMOD_6             6*0x20  /* ת/λģʽ */
#define OUTMOD_7             7*0x20  /* λ/λģʽ*/
#define CCIS_0               0*0x1000  /* ѡCCIXAΪ¼źԴ */
#define CCIS_1               1*0x1000  /* ѡCCIXBΪ¼źԴ */
#define CCIS_2               2*0x1000  /* ѡGNDΪ¼źԴ */
#define CCIS_3               3*0x1000  /* ѡVCCΪ¼źԴ */
#define CM_0                 0*0x4000  /* ֹģʽ */
#define CM_1                 1*0x4000  /* Ӳģʽ */
#define CM_2                 2*0x4000  /* ½زģʽ */
#define CM_3                 3*0x4000  /* غ½ضģʽ */

/************************************************************
* Timer B         ʱBĴ
************************************************************/

#define TBIV_               0x011E  /* жĴ:BIT1-BIT3Ч */
sfrw    TBIV              = TBIV_;
#define TBCTL_              0x0180  /* ʱBƼĴ:ȫƶ */
sfrw    TBCTL             = TBCTL_;
#define TBCCTL0_            0x0182  /* ʱB/ȽϿƼĴ0*/
sfrw    TBCCTL0           = TBCCTL0_;
#define TBCCTL1_            0x0184  /* ʱB/ȽϿƼĴ1 */
sfrw    TBCCTL1           = TBCCTL1_;
#define TBCCTL2_            0x0186  /* ʱB/ȽϿƼĴ2 */
sfrw    TBCCTL2           = TBCCTL2_;
#define TBCCTL3_            0x0188  /* ʱB/ȽϿƼĴ3 */
sfrw    TBCCTL3           = TBCCTL3_;
#define TBCCTL4_            0x018A  /* ʱB/ȽϿƼĴ4 */
sfrw    TBCCTL4           = TBCCTL4_;
#define TBCCTL5_            0x018C  /* ʱB/ȽϿƼĴ5 */
sfrw    TBCCTL5           = TBCCTL5_;
#define TBCCTL6_            0x018E  /* ʱB/ȽϿƼĴ6 */
sfrw    TBCCTL6           = TBCCTL6_;
#define TBR_                0x0190  /*  */
sfrw    TBR               = TBR_;
#define TBCCR0_             0x0192  /* ʱB/ȽϼĴ0 */
sfrw    TBCCR0            = TBCCR0_;
#define TBCCR1_             0x0194  /* ʱB/ȽϼĴ1 */
sfrw    TBCCR1            = TBCCR1_;
#define TBCCR2_             0x0196  /* ʱB/ȽϼĴ2 */
sfrw    TBCCR2            = TBCCR2_;
#define TBCCR3_             0x0198  /* ʱB/ȽϼĴ3 */
sfrw    TBCCR3            = TBCCR3_;
#define TBCCR4_             0x019A  /* ʱB/ȽϼĴ4 */
sfrw    TBCCR4            = TBCCR4_;
#define TBCCR5_             0x019C  /* ʱB/ȽϼĴ5 */
sfrw    TBCCR5            = TBCCR5_;
#define TBCCR6_             0x019E  /* ʱB/ȽϼĴ6 */
sfrw    TBCCR6            = TBCCR6_;
/* ʱBƼĴ:ȫƶ */
#define SHR1                0x4000  /* װرȽλ1 :TBCCTLxеCCLDxλ */
#define SHR0                0x2000  /* װرȽλ0 :TBCCTLxеCCLDxλ*/
#define TBCLGRP1            0x4000  /* װرȽλ1 :TBCCTLxеCCLDxλ*/
#define TBCLGRP0            0x2000  /* װرȽλ0 :TBCCTLxеCCLDxλ*/
#define CNTL1               0x1000  /* ʱλȿλ1 */
#define CNTL0               0x0800  /* ʱλȿλ0 */
#define TBSSEL2             0x0400  /* δ */
#define TBSSEL1             0x0200  /* ʱԴλ1 */
#define TBSSEL0             0x0100  /* ʱԴλ0 */
#define TBCLR               0x0004  /* 1ʱ */
#define TBIE                0x0002  /* ж */
#define TBIFG               0x0001  /* жϱ־ */

#define TBSSEL_0             0*0x0100  /* ʱԴΪ:TBCLK */
#define TBSSEL_1             1*0x0100  /* ʱԴΪ: ACLK  */
#define TBSSEL_2             2*0x0100  /* ʱԴΪ:SMCLK */
#define TBSSEL_3             3*0x0100  /* ʱԴΪ:INCLK */
#define CNTL_0               0*0x0800  /* 16 λģʽ*/
#define CNTL_1               1*0x0800  /* 12 λģʽ*/
#define CNTL_2               2*0x0800  /* 10 λģʽ */
#define CNTL_3               3*0x0800  /* 8  λģʽ */
#define SHR_0                0*0x2000  /* װ(ʼֵ) */
#define SHR_1                1*0x2000  /* װ: 1 - 3 groups (1-2, 3-4, 5-6) */
#define SHR_2                2*0x2000  /* ֶװ: 2 - 2 groups (1-3, 4-6)*/
#define SHR_3                3*0x2000  /* װ: 3 - 1 group (all) */
#define TBCLGRP_0            0*0x2000  /* װ(ʼֵ) */
#define TBCLGRP_1            1*0x2000  /* װ: 1 - 3 groups (1-2, 3-4, 5-6) */
#define TBCLGRP_2            2*0x2000  /* ֶװ: 2 - 2 groups (1-3, 4-6)*/
#define TBCLGRP_3            3*0x2000  /* װ: 3 - 1 group (all) */

/* Additional Timer B Control Register bits are defined in Timer A */

#define SLSHR1              0x0400  /* Compare latch load source 1 */
#define SLSHR0              0x0200  /* Compare latch load source 0 */
#define CLLD1               0x0400  /* ȽTBCLxװطʽλ1 */
#define CLLD0               0x0200  /* ȽTBCLxװطʽλ0 */

#define SLSHR_0              0*0x0200  /* װ */
#define SLSHR_1              1*0x0200  /* TBR 0ʱװ */
#define SLSHR_2              2*0x0200  /* ģʽ,TBCLx0ʱװ; ģʽ,0ʱװ */
#define SLSHR_3              3*0x0200  /* TBCL0ʱװ*/

#define CLLD_0               0*0x0200  /* װ  */
#define CLLD_1               1*0x0200  /* TBR 0ʱװ */
#define CLLD_2               2*0x0200  /* ģʽ,TBCLx0ʱװ; ģʽ,0ʱװ */
#define CLLD_3               3*0x0200  /* TBCL0ʱװ */

/************************************************************
* Basic Clock Module
************************************************************/

#define DCOCTL_             0x0056  /* DCO ʱƵʿƼĴ :λֵλ060h*/
sfrb    DCOCTL            = DCOCTL_;
#define BCSCTL1_            0x0057  /* ϵͳʱӿƼĴ1 :λֵλ084h*/
sfrb    BCSCTL1           = BCSCTL1_;
#define BCSCTL2_            0x0058  /* ϵͳʱӿƼĴ2 :λֵλ000h*/
sfrb    BCSCTL2           = BCSCTL2_;
/* DCO ʱƵʿƼĴ */
#define MOD0                0x01   /* DCOڿλ0 */
#define MOD1                0x02   /* DCOڿλ1 */
#define MOD2                0x04   /* DCOڿλ2 */
#define MOD3                0x08   /* DCOڿλ3 */
#define MOD4                0x10   /* DCOڿλ4 */
#define DCO0                0x20   /* 8Ƶʿλ0 */
#define DCO1                0x40   /* 8Ƶʿλ1 */
#define DCO2                0x80   /* 8Ƶʿλ2 */
/* ϵͳʱӿƼĴ1 :λֵλ084h*/
#define RSEL0               0x01   /* ѡڲλ0 */
#define RSEL1               0x02   /* ѡڲλ1 */
#define RSEL2               0x04   /* ѡڲλ2 */
#define XT5V                0x08   /* Ϊ0*/
#define DIVA0               0x10   /* ACLKƵϵλ0*/
#define DIVA1               0x20   /* ACLKƵϵλ1 */
#define XTS                 0x40   /* LFXT1ģʽλ 0:Ƶģʽ. / 1: Ƶģʽ. */
#define XT2OFF              0x80   /* XT2CLK ʹܿλ  0:; 1:ر */

#define DIVA_0              0x00   /* ACLKƵϵΪ: 1 */
#define DIVA_1              0x10   /* ACLKƵϵΪ: 2 */
#define DIVA_2              0x20   /* ACLKƵϵΪ: 4 */
#define DIVA_3              0x30   /* ACLKƵϵΪ: 8 */
/* ϵͳʱӿƼĴ2 :λֵλ000h*/
#define DCOR                0x01   /*  ѡλ */
#define DIVS0               0x02   /* SMCLKƵλ0*/
#define DIVS1               0x04   /* SMCLKƵλ1 */
#define SELS                0x08   /* SMCLK ʱԴѡλt 0:DCOCLK / 1:XT2CLK/LFXTCLK */
#define DIVM0               0x10   /* MCLKƵλ0  */
#define DIVM1               0x20   /* MCLKƵλ1 */
#define SELM0               0x40   /* MCLK ʱԴѡλ0 */
#define SELM1               0x80   /* MCLK ʱԴѡλ1 */

#define DIVS_0              0x00   /* SMCLK ƵϵΪ: 1 */
#define DIVS_1              0x02   /* SMCLK ƵϵΪ: 2 */
#define DIVS_2              0x04   /* SMCLK ƵϵΪ: 4 */
#define DIVS_3              0x06   /* SMCLK ƵϵΪ: 8 */

#define DIVM_0              0x00   /* MCLK ƵϵΪ: 1 */
#define DIVM_1              0x10   /* MCLK ƵϵΪ: 2 */
#define DIVM_2              0x20   /* MCLK ƵϵΪ: 4 */
#define DIVM_3              0x30   /* MCLK ƵϵΪ: 8 */

#define SELM_0              0x00   /* MCLK ʱԴ: DCOCLK */
#define SELM_1              0x40   /* MCLK ʱԴ: DCOCLK */
#define SELM_2              0x80   /* MCLK ʱԴ: XT2CLK/LFXTCLK */
#define SELM_3              0xC0   /* MCLK ʱԴ: LFXTCLK */

/*************************************************************
* Flash Memory      FLASHĴ
*************************************************************/

#define FCTL1_              0x0128  /* FLASHƼĴ1:Ʊ̡ */
sfrw    FCTL1             = FCTL1_;
#define FCTL2_              0x012A  /* FLASH ƼĴ2 ʱӷƵ*/
sfrw    FCTL2             = FCTL2_;
#define FCTL3_              0x012C  /* FLASH ƼĴ3 ״̬־ */
sfrw    FCTL3             = FCTL3_;

#define FRKEY               0x9600  /* FLASH  */
#define FWKEY               0xA500  /* дFLASH  */
#define FXKEY               0x3300  /* for use with XOR instruction */
/* FLASHƼĴ1:Ʊ̡ */
#define ERASE               0x0002  /* ʹ */
#define MERAS               0x0004  /* ʹ */
#define WRT                 0x0040  /* ʹ */
#define BLKWRT              0x0080  /* αʹ */
/* FLASH ƼĴ2 ʱӷƵ*/
#define FN_0                 0x0000  /*ֱͨ */
#define FN_1                 0x0001  /*2Ƶ  */
#define FN_2                 0x0002  /*3Ƶ*/
#define FN_3                 0x0003  /*4Ƶ */
#define FN_4                 0x0004  /*5Ƶ */
#define FN_5                 0x0005  /*6Ƶ*/
#define FN_6                 0x0006  /*7Ƶ  */
#define FN_7                 0x0007  /*8Ƶ*/
#define FN_8                 0x0008  /*9Ƶ */
#define FN_9                 0x0009  /*10Ƶ */
#define FN_10                0x000A  /*11Ƶ*/
#define FN_11                0x000B  /*12Ƶ  */
#define FN_12                0x000C  /*13Ƶ*/
#define FN_13                0x000D  /*14Ƶ */
#define FN_14                0x000E  /*15Ƶ */
#define FN_15                0x000F  /*16Ƶ*/
#define FN_16                0x0010  /*17Ƶ  */
#define FN_17                0x0011  /*18Ƶ*/
#define FN_18                0x0012  /*19Ƶ */
#define FN_19                0x0013  /*20Ƶ */
#define FN_20                0x0014  /*21Ƶ*/
#define FN_21                0x0015  /*22Ƶ  */
#define FN_22                0x0016  /*23Ƶ*/
#define FN_23                0x0017  /*24Ƶ */
#define FN_24                0x0018  /*25Ƶ */
#define FN_25                0x0019  /*26Ƶ*/
#define FN_26                0x001A  /*27Ƶ  */
#define FN_27                0x001B  /*28Ƶ*/
#define FN_28                0x001C  /*29Ƶ */
#define FN_29                0x001D  /*30Ƶ */
#define FN_30                0x001E  /*31Ƶ*/
#define FN_31                0x001F  /*32Ƶ  */
#define FN_32                0x0020  /*33Ƶ*/
#define FN_33                0x0021  /*34Ƶ */
#define FN_34                0x0022  /*35Ƶ */
#define FN_35                0x0023  /*36Ƶ*/
#define FN_36                0x0024  /*37Ƶ  */
#define FN_37                0x0025  /*38Ƶ*/
#define FN_38                0x0026  /*39Ƶ */
#define FN_39                0x0027  /*40Ƶ */
#define FN_40                0x0028  /*41Ƶ*/
#define FN_41                0x0029  /*42Ƶ  */
#define FN_42                0x002A  /*43Ƶ*/
#define FN_43                0x002B  /*44Ƶ */
#define FN_44                0x002C  /*45Ƶ */
#define FN_45                0x002D  /*46Ƶ*/
#define FN_46                0x002E  /*47Ƶ  */
#define FN_47                0x002F  /*48Ƶ*/
#define FN_48                0x0030  /*49Ƶ */
#define FN_49                0x0031  /*50Ƶ */
#define FN_50                0x0032  /*51Ƶ*/
#define FN_51                0x0033  /*52Ƶ  */
#define FN_52                0x0034  /*53Ƶ*/
#define FN_53                0x0035  /*54Ƶ */
#define FN_54                0x0036  /*55Ƶ */
#define FN_55                0x0037  /*56Ƶ*/
#define FN_56                0x0038  /*57Ƶ  */
#define FN_57                0x0039  /*58Ƶ*/
#define FN_58                0x003A  /*59Ƶ */
#define FN_59                0x003B  /*60Ƶ */
#define FN_60                0x003C  /*61Ƶ*/
#define FN_61                0x003D  /*62Ƶ  */
#define FN_62                0x003E  /*63Ƶ*/
#define FN_63                0x003F  /*64Ƶ */
#define FSSEL_0             0x0000  /* Flashʱѡ: ACLK */
#define FSSEL_1             0x0040  /* Flashʱѡ: MCLK */
#define FSSEL_2             0x0080  /* Flashʱѡ: SMCLK */
#define FSSEL_3             0x00C0  /* Flashʱѡ: SMCLK */
/* FLASH ƼĴ3 ״̬־ */
#define BUSY                0x0001  /* Flashæ־*/
#define KEYV                0x0002  /* Flashȫֵ־ */
#define ACCVIFG             0x0004  /* FlashǷжϱ־*/
#define WAIT                0x0008  /* ȴָʾźλ*/
#define LOCK                0x0010  /* λ */
#define EMEX                0x0020  /* ˳λ */

/************************************************************
* Comparator A            ȽAĴ
************************************************************/

#define CACTL1_             0x0059  /* ȽAƼĴ1 */
sfrb    CACTL1            = CACTL1_;
#define CACTL2_             0x005A  /* ȽAƼĴ2 */
sfrb    CACTL2            = CACTL2_;
#define CAPD_               0x005B  /*ȽA˿ڽֹĴ*/
sfrb    CAPD              = CAPD_;
/* ȽAƼĴ1 */
#define CAIFG               0x01    /*ȽAжϱ־*/
#define CAIE                0x02    /* ȽAжʹ */
#define CAIES               0x04    /* ȽAжϱشѡ 0: 1:½ */
#define CAON                0x08    /* ȽԴ*/
#define CAREF0              0x10    /* ѡοԴλ0 */
#define CAREF1              0x20    /* ѡοԴλ1 */
#define CARSEL              0x40    /* ѡڲοԴӵȽ˻򸺶 */
#define CAEX                0x80    /* Ƚ */

#define CAREF_0             0x00    /* ѡοԴ0 : Off ʹⲿοԴ*/
#define CAREF_1             0x10    /* ѡοԴ1 : 0.25*VccΪοԴ */
#define CAREF_2             0x20    /* ѡοԴ2 : 0.5*VccΪοԴ */
#define CAREF_3             0x30    /* ѡοԴ3 : Vt*/
 /* ȽAƼĴ2 */
#define CAOUT               0x01    /* Ƚ */
#define CAF                 0x02    /* ѡȽǷ񾭹RCͨ˲ */
#define P2CA0               0x04    /* ⲿźӵȽACA0 */
#define P2CA1               0x08    /* ⲿźӵȽACA1 */
#define CACTL24             0x10
#define CACTL25             0x20
#define CACTL26             0x40
#define CACTL27             0x80

#define CAPD0               0x01    /* Comp. A Disable Input Buffer of Port Register .0 */
#define CAPD1               0x02    /* Comp. A Disable Input Buffer of Port Register .1 */
#define CAPD2               0x04    /* Comp. A Disable Input Buffer of Port Register .2 */
#define CAPD3               0x08    /* Comp. A Disable Input Buffer of Port Register .3 */
#define CAPD4               0x10    /* Comp. A Disable Input Buffer of Port Register .4 */
#define CAPD5               0x20    /* Comp. A Disable Input Buffer of Port Register .5 */
#define CAPD6               0x40    /* Comp. A Disable Input Buffer of Port Register .6 */
#define CAPD7               0x80    /* Comp. A Disable Input Buffer of Port Register .7 */

/************************************************************
* ADC12   A/DĴ
************************************************************/
/*ADC12תĴ*/
#define ADC12CTL0_          0x0;' /* ADC12 Control 0 */
sfrw    ADC12CTL0         = ADC12CTL0_;
#define ADC12CTL1_          0x01A2  /* ADC12 Control 1 */
sfrw    ADC12CTL1         = ADC12CTL1_;

/*ADC12жϿĴ*/
#define ADC12IFG_           0x01A4  /* ADC12 Interrupt Flag */
sfrw    ADC12IFG          = ADC12IFG_;
#define ADC12IE_            0x01A6  /* ADC12 Interrupt Enable */
sfrw    ADC12IE           = ADC12IE_;
#define ADC12IV_            0x01A8  /* ADC12 Interrupt Vector Word */
sfrw    ADC12IV           = ADC12IV_;

/*ADC12Ĵ*/
#define ADC12MEM_           0x0140  /* ADC12 Conversion Memory */
#ifndef __IAR_SYSTEMS_ICC
#define ADC12MEM            ADC12MEM_ /* ADC12 Conversion Memory (for assembler) */
#else
#define ADC12MEM            ((int*) ADC12MEM_) /* ADC12 Conversion Memory (for C) */
#endif
#define ADC12MEM0_          ADC12MEM_ /* ADC12 Conversion Memory 0 */
sfrw    ADC12MEM0         = ADC12MEM0_;
#define ADC12MEM1_          0x0142  /* ADC12 Conversion Memory 1 */
sfrw    ADC12MEM1         = ADC12MEM1_;
#define ADC12MEM2_          0x0144  /* ADC12 Conversion Memory 2 */
sfrw    ADC12MEM2         = ADC12MEM2_;
#define ADC12MEM3_          0x0146  /* ADC12 Conversion Memory 3 */
sfrw    ADC12MEM3         = ADC12MEM3_;
#define ADC12MEM4_          0x0148  /* ADC12 Conversion Memory 4 */
sfrw    ADC12MEM4         = ADC12MEM4_;
#define ADC12MEM5_          0x014A  /* ADC12 Conversion Memory 5 */
sfrw    ADC12MEM5         = ADC12MEM5_;
#define ADC12MEM6_          0x014C  /* ADC12 Conversion Memory 6 */
sfrw    ADC12MEM6         = ADC12MEM6_;
#define ADC12MEM7_          0x014E  /* ADC12 Conversion Memory 7 */
sfrw    ADC12MEM7         = ADC12MEM7_;
#define ADC12MEM8_          0x0150  /* ADC12 Conversion Memory 8 */
sfrw    ADC12MEM8         = ADC12MEM8_;
#define ADC12MEM9_          0x0152  /* ADC12 Conversion Memory 9 */
sfrw    ADC12MEM9         = ADC12MEM9_;
#define ADC12MEM10_         0x0154  /* ADC12 Conversion Memory 10 */
sfrw    ADC12MEM10        = ADC12MEM10_;
#define ADC12MEM11_         0x0156  /* ADC12 Conversion Memory 11 */
sfrw    ADC12MEM11        = ADC12MEM11_;
#define ADC12MEM12_         0x0158  /* ADC12 Conversion Memory 12 */
sfrw    ADC12MEM12        = ADC12MEM12_;
#define ADC12MEM13_         0x015A  /* ADC12 Conversion Memory 13 */
sfrw    ADC12MEM13        = ADC12MEM13_;
#define ADC12MEM14_         0x015C  /* ADC12 Conversion Memory 14 */
sfrw    ADC12MEM14        = ADC12MEM14_;
#define ADC12MEM15_         0x015E  /* ADC12 Conversion Memory 15 */
sfrw    ADC12MEM15        = ADC12MEM15_;

/*ADC12Ĵ*/
#define ADC12MCTL_          0x0080  /* ADC12 Memory Control */
#ifndef __IAR_SYSTEMS_ICC
#define ADC12MCTL           ADC12MCTL_ /* ADC12 Memory Control (for assembler) */
#else
#define ADC12MCTL           ((char*) ADC12MCTL_) /* ADC12 Memory Control (for C) */
#endif
#define ADC12MCTL0_         ADC12MCTL_ /* ADC12 Memory Control 0 */
sfrb    ADC12MCTL0        = ADC12MCTL0_;
#define ADC12MCTL1_         0x0081  /* ADC12 Memory Control 1 */
sfrb    ADC12MCTL1        = ADC12MCTL1_;
#define ADC12MCTL2_         0x0082  /* ADC12 Memory Control 2 */
sfrb    ADC12MCTL2        = ADC12MCTL2_;
#define ADC12MCTL3_         0x0083  /* ADC12 Memory Control 3 */
sfrb    ADC12MCTL3        = ADC12MCTL3_;
#define ADC12MCTL4_         0x0084  /* ADC12 Memory Control 4 */
sfrb    ADC12MCTL4        = ADC12MCTL4_;
#define ADC12MCTL5_         0x0085  /* ADC12 Memory Control 5 */
sfrb    ADC12MCTL5        = ADC12MCTL5_;
#define ADC12MCTL6_         0x0086  /* ADC12 Memory Control 6 */
sfrb    ADC12MCTL6        = ADC12MCTL6_;
#define ADC12MCTL7_         0x0087  /* ADC12 Memory Control 7 */
sfrb    ADC12MCTL7        = ADC12MCTL7_;
#define ADC12MCTL8_         0x0088  /* ADC12 Memory Control 8 */
sfrb    ADC12MCTL8        = ADC12MCTL8_;
#define ADC12MCTL9_         0x0089  /* ADC12 Memory Control 9 */
sfrb    ADC12MCTL9        = ADC12MCTL9_;
#define ADC12MCTL10_        0x008A  /* ADC12 Memory Control 10 */
sfrb    ADC12MCTL10       = ADC12MCTL10_;
#define ADC12MCTL11_        0x008B  /* ADC12 Memory Control 11 */
sfrb    ADC12MCTL11       = ADC12MCTL11_;
#define ADC12MCTL12_        0x008C  /* ADC12 Memory Control 12 */
sfrb    ADC12MCTL12       = ADC12MCTL12_;
#define ADC12MCTL13_        0x008D  /* ADC12 Memory Control 13 */
sfrb    ADC12MCTL13       = ADC12MCTL13_;
#define ADC12MCTL14_        0x008E  /* ADC12 Memory Control 14 */
sfrb    ADC12MCTL14       = ADC12MCTL14_;
#define ADC12MCTL15_        0x008F  /* ADC12 Memory Control 15 */
sfrb    ADC12MCTL15       = ADC12MCTL15_;

/* ADC12CTL0 16λƼĴλ*/
#define ADC12SC             0x001         /*/תλ*/   
#define ENC                 0x002         /* תλ*/
#define ADC12TOVIE          0x004         /*תʱжλ*/
#define ADC12OVIE           0x008         /*жλ*/ 
#define ADC12ON             0x010         /*ADC12ں˿λ*/
#define REFON               0x020         /*οѹλ*/
#define REF2_5V             0x040         /*ڲοѹĵѹֵѡλ '0'Ϊ1.5V; '1'Ϊ2.5V*/
#define MSH                 0x080         /*β/תλ*/
#define MSC                 0x080         /*β/תλ*/
/*SHT0 ֶʱ0 ADC12ĽMEM0~MEM7Ĳ*/
#define SHT0_0               0*0x100       /*=TADC12CLK*4 */
#define SHT0_1               1*0x100       /*=TADC12CLK*8 */
#define SHT0_2               2*0x100       /*=TADC12CLK*16 */
#define SHT0_3               3*0x100       /*=TADC12CLK*32 */
#define SHT0_4               4*0x100       /*=TADC12CLK*64 */
#define SHT0_5               5*0x100       /*=TADC12CLK*96 */
#define SHT0_6               6*0x100       /*=TADC12CLK*128 */
#define SHT0_7               7*0x100       /*=TADC12CLK*192 */
#define SHT0_8               8*0x100       /*=TADC12CLK*256 */
#define SHT0_9               9*0x100       /*=TADC12CLK*384 */
#define SHT0_10             10*0x100       /*=TADC12CLK*512 */  
#define SHT0_11             11*0x100       /*=TADC12CLK*768 */
#define SHT0_12             12*0x100       /*=TADC12CLK*1024 */
#define SHT0_13             13*0x100       /*=TADC12CLK*1024 */ 
#define SHT0_14             14*0x100       /*=TADC12CLK*1024 */ 
#define SHT0_15             15*0x100       /*=TADC12CLK*1024 */
/*SHT1 ֶʱ1 ADC12ĽMEM8~MEM15Ĳ*/
#define SHT1_0               0*0x100       /*=TADC12CLK*4 */
#define SHT1_1               1*0x100       /*=TADC12CLK*8 */
#define SHT1_2               2*0x100       /*=TADC12CLK*16 */
#define SHT1_3               3*0x100       /*=TADC12CLK*32 */
#define SHT1_4               4*0x100       /*=TADC12CLK*64 */
#define SHT1_5               5*0x100       /*=TADC12CLK*96 */
#define SHT1_6               6*0x100       /*=TADC12CLK*128 */
#define SHT1_7               7*0x100       /*=TADC12CLK*192 */
#define SHT1_8               8*0x100       /*=TADC12CLK*256 */
#define SHT1_9               9*0x100       /*=TADC12CLK*384 */
#define SHT1_10             10*0x100       /*=TADC12CLK*512 */  
#define SHT1_11             11*0x100       /*=TADC12CLK*768 */
#define SHT1_12             12*0x100       /*=TADC12CLK*1024 */
#define SHT1_13             13*0x100       /*=TADC12CLK*1024 */ 
#define SHT1_14             14*0x100       /*=TADC12CLK*1024 */ 
#define SHT1_15             15*0x100       /*=TADC12CLK*1024 */


/* ADC12CTL1 16λƼĴλ*/
#define ADC12BUSY           0x0001         /*ADC12æ־λ*/
#define CONSEQ_0             0*2           /*ͨת*/ 
#define CONSEQ_1             1*2           /*ͨת*/
#define CONSEQ_2             2*2           /*ͨת*/
#define CONSEQ_3             3*2           /*ͨת*/
#define ADC12SSEL_0          0*8           /*ADC12ڲʱԴ*/
#define ADC12SSEL_1          1*8           /*ACLK*/
#define ADC12SSEL_2          2*8           /*MCLK*/
#define ADC12SSEL_3          3*8           /*SCLK*/
#define ADC12DIV_0           0*0x20        /*1Ƶ*/
#define ADC12DIV_1           1*0x20        /*2Ƶ*/
#define ADC12DIV_2           2*0x20        /*3Ƶ*/
#define ADC12DIV_3           3*0x20        /*4Ƶ*/ 
#define ADC12DIV_4           4*0x20        /*5Ƶ*/ 
#define ADC12DIV_5           5*0x20        /*6Ƶ*/
#define ADC12DIV_6           6*0x20        /*7Ƶ*/
#define ADC12DIV_7           7*0x20        /*8Ƶ*/
#define ISSH                 0x0100        /*źŷλ*/
#define SHP                  0x0200        /*ź(SAMPCON)ѡλ*/
#define SHS_0                0*0x400       /*źԴѡλ ADC12SC*/ 
#define SHS_1                1*0x400       /*źԴѡλ TIMER_A.OUT1*/
#define SHS_2                2*0x400       /*źԴѡλ TIMER_B.OUT0*/
#define SHS_3                3*0x400       /*źԴѡλ TIMER_B.OUT1*/
/*תַλ*/
#define CSTARTADD_0          0*0x1000      /*ѡMEM0׵ַ*/
#define CSTARTADD_1          1*0x1000      /*ѡMEM1׵ַ*/ 
#define CSTARTADD_2          2*0x1000      /*ѡMEM2׵ַ*/
#define CSTARTADD_3          3*0x1000      /*ѡMEM3׵ַ*/
#define CSTARTADD_4          4*0x1000      /*ѡMEM4׵ַ*/
#define CSTARTADD_5          5*0x1000      /*ѡMEM5׵ַ*/
#define CSTARTADD_6          6*0x1000      /*ѡMEM6׵ַ*/
#define CSTARTADD_7          7*0x1000      /*ѡMEM7׵ַ*/ 
#define CSTARTADD_8          8*0x1000      /*ѡMEM8׵ַ*/
#define CSTARTADD_9          9*0x1000      /*ѡMEM9׵ַ*/
#define CSTARTADD_10        10*0x1000      /*ѡMEM10׵ַ*/
#define CSTARTADD_11        11*0x1000      /*ѡMEM11׵ַ*/
#define CSTARTADD_12        12*0x1000      /*ѡMEM12׵ַ*/
#define CSTARTADD_13        13*0x1000      /*ѡMEM13׵ַ*/      
#define CSTARTADD_14        14*0x1000      /*ѡMEM14׵ַ*/    
#define CSTARTADD_15        15*0x1000      /*ѡMEM15׵ַ*/
  
/* ADC12MCTLx */
#define INCH_0               0                 /*ѡģͨ0 A0 */
#define INCH_1               1                 /*ѡģͨ0 A1*/
#define INCH_2               2                 /*ѡģͨ0 A2*/
#define INCH_3               3                 /*ѡģͨ0 A3*/
#define INCH_4               4                 /*ѡģͨ0 A4*/
#define INCH_5               5                 /*ѡģͨ0 A5*/
#define INCH_6               6                 /*ѡģͨ0 A6*/
#define INCH_7               7                 /*ѡģͨ0 A7*/
#define INCH_8               8                 /*VEREF+*/
#define INCH_9               9                 /*VEREF-*/
#define INCH_10             10                 /*Ƭ¶ȴ*/
#define INCH_11             11                 /*(AVCC-AVSS)/2*/
#define INCH_12             12                 /*(AVCC-AVSS)/2*/
#define INCH_13             13                 /*(AVCC-AVSS)/2*/
#define INCH_14             14                 /*(AVCC-AVSS)/2*/
#define INCH_15             15                 /*(AVCC-AVSS)/2*/
/*οѹԴѡλ*/
#define SREF_0               0*0x10            /*VR+ = AVCC; VR- = AVSS*/
#define SREF_1               1*0x10            /*VR+ = VREF+; VR- = AVSS*/
#define SREF_2               2*0x10            /*VR+ = VEREF+; VR- = AVSS*/
#define SREF_3               3*0x10            /*VR+ = VEREF+; VR- = AVSS*/
#define SREF_4               4*0x10            /*VR+ = AVCC; VR- = VREF-*/
#define SREF_5               5*0x10            /*VR+ = VREF+; VR- = VREF-*/
#define SREF_6               6*0x10            /*VR+ = VEREF+; VR- = VREF-*/
#define SREF_7               7*0x10            /*VR+ = VEREF+; VR- = VREF-*/
#define EOS                 0x80               /*нѡλ*/

/************************************************************
* Interrupt Vectors (offset from 0xFFE0) 16жʸ
************************************************************/

//#define BASICTIMER_VECTOR   0 * 2  /* 0xFFE0 Basic Timer MSP430F149 û*/
#define PORT2_VECTOR        1 * 2  /* 0xFFE2 Port 2 */
#define UART1TX_VECTOR      2 * 2  /* 0xFFE4 UART 1 Transmit */
#define UART1RX_VECTOR      3 * 2  /* 0xFFE6 UART 1 Receive */
#define PORT1_VECTOR        4 * 2  /* 0xFFE8 Port 1 */
#define TIMERA1_VECTOR      5 * 2  /* 0xFFEA Timer A CC1-2, TA */
#define TIMERA0_VECTOR      6 * 2  /* 0xFFEC Timer A CC0 */
#define ADC_VECTOR          7 * 2  /* 0xFFEE ADC */
#define UART0TX_VECTOR      8 * 2  /* 0xFFF0 UART 0 Transmit */
#define UART0RX_VECTOR      9 * 2  /* 0xFFF2 UART 0 Receive */
#define WDT_VECTOR          10 * 2 /* 0xFFF4 Watchdog Timer */
#define COMPARATORA_VECTOR  11 * 2 /* 0xFFF6 Comparator A */
#define TIMERB1_VECTOR      12 * 2 /* 0xFFF8 Timer B 1-6 */
#define TIMERB0_VECTOR      13 * 2 /* 0xFFFA Timer B 0 */
#define NMI_VECTOR          14 * 2 /* 0xFFFC Non-maskable */
#define RESET_VECTOR        15 * 2 /* 0xFFFE Reset [Highest Priority] */

/************************************************************
* End of Modules
************************************************************/

#endif /* #ifndef __msp430x44x */

