/************************************************************
************************************************************/
#include "bsp_TB6600_TIM.h"
#include "stm32f10x.h"
#include "stm32f10x_usart.h"
#include <stdio.h>

char RX=0;
extern __IO uint16_t prescaler;//pwmƵ
/////////////////////////ں///////////////////////////////
void Printf_Configuration(void);
void Usart_GPIO_Configuration(void);
////////////////////////////////////////////////////////////////
void RCC_Configuration(void);
void Limit(uint16_t F);//ٶ
////////////////////////////////////////////////////////////////
//////////////////////printf////////////////////////////////
int fputc(int ch,FILE*f)
{
	while(USART_GetFlagStatus( USART1,  USART_FLAG_TC)==RESET);//ȴ
	USART_SendData(USART1,ch);//ch͸usart1
	return(ch);//ch
}
//Ϊprintf()֮ĺʹ˰ģʽʹñ׼ᵼ³޷Сֽ
//1.ʹ΢⡣ħTargetCode GenerationѡʹUse MicroLIB
//2.³
struct __FILE 
{ 
int handle; 
/* Whatever you require here. If the only file you are using is */ 
/* standard output using printf() for debugging, no file handling */ 
/* is required. */ 
}; 
FILE __stdout; // FILE is typedefed in stdio.h. 
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////


int main(void)
{
 	RCC_Configuration();
	TB6600_TIMx_PWM_Init();
	Usart_GPIO_Configuration();
	Printf_Configuration();
	printf("start");
	while(1)       //while1ͻܷ
 	{
		while(USART_GetFlagStatus( USART1,  USART_FLAG_RXNE)==RESET);
		RX=USART_ReceiveData(USART1);
		if(RX=='Z')//ԭ300r/s
		{
			prescaler=125;
			printf("speed:300r/s\n\r");
		}
		if(RX=='A')//600r/s
		{
			prescaler=62;
			printf("speed:600/s\n\r");
		}
		if(RX=='E')//150r/s
		{
			prescaler=250;
			printf("speed:150/s\n\r");
		}
	}
}

void RCC_Configuration(void)
{
  RCC_DeInit();   //ʼȱʡֵ
  RCC_HSEConfig(RCC_HSE_ON);//ʹⲿʱ
  while(RCC_GetFlagStatus(RCC_FLAG_HSERDY) == RESET);
	FLASH_SetLatency(FLASH_Latency_2);
  FLASH_PrefetchBufferCmd(FLASH_PrefetchBuffer_Enable);
	RCC_HCLKConfig(RCC_SYSCLK_Div1);   //HCLK=SYSCLK
	RCC_PCLK2Config(RCC_HCLK_Div1);    //PCLK2=HCLK
	RCC_PCLK1Config(RCC_HCLK_Div2);    //PCLK1=HCLK/2
	RCC_PLLConfig(RCC_PLLSource_HSE_Div1, RCC_PLLMul_9);
	RCC_PLLCmd(ENABLE);
	while(RCC_GetFlagStatus(RCC_FLAG_PLLRDY) == RESET){};
  /* Select PLL as system clock source */
  RCC_SYSCLKConfig(RCC_SYSCLKSource_PLLCLK);
  /* Wait till PLL is used as system clock source */
  while(RCC_GetSYSCLKSource()!= 0x08);
  /* Enable GPIOB, GPIOC and AFIO clocks */
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA|RCC_APB2Periph_GPIOB, ENABLE);
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_AFIO , ENABLE);	
}

void Usart_GPIO_Configuration(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;
 
  /* Configure USARTX_TX as alternate function push-pull */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_2|GPIO_Pin_9;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
  GPIO_Init(GPIOA, &GPIO_InitStructure);
  /* Configure USARTX_RX as input floating */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_3|GPIO_Pin_10;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  GPIO_Init(GPIOA, &GPIO_InitStructure);
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_AFIO|RCC_APB2Periph_GPIOA, ENABLE);	
}

void Printf_Configuration(void)
{
	USART_InitTypeDef USART_InitStructure;
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART1 , ENABLE);
  USART_InitStructure.USART_BaudRate = 9600;
  USART_InitStructure.USART_WordLength = USART_WordLength_8b;
  USART_InitStructure.USART_StopBits = USART_StopBits_1;
  USART_InitStructure.USART_Parity = USART_Parity_No;
  USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
  USART_InitStructure.USART_Mode = USART_Mode_Rx | USART_Mode_Tx;
  USART_Init(USART1, &USART_InitStructure);
  USART_Cmd(USART1, ENABLE);
}
void USART2_IRQHandler(void)
{
  if(USART_GetITStatus(USART2, USART_IT_RXNE) != RESET)//жжԴ־
  {
		USART_ClearFlag(USART2,USART_IT_RXNE);//жϱ־
		while(USART_GetFlagStatus( USART2,USART_FLAG_RXNE)==RESET);//жϽձ־ݻᶪʧ
		RX=USART_ReceiveData(USART2)-0x30;
	}
}