/********************************************************************************
 Author             : CAST (China Applications Support Team) 

 Date               : 4-21-2011

 File name          : AD9122.c

 Description        : Using ADuC7026 to control AD9122 in software SPI form through GPIO;
			          In this project we use the example start-up routing in the datasheet;
			          You can both check it in the AD9122 datasheet page 59 and readme.txt 
					  inside the project folder.

 Hardware plateform : ADuC7026 + AD9122 	
********************************************************************************/
#include <ADuC7026.h>
#include "ADuC7026Driver.h"
#include "AD9122.h"


/********************************************************************************
Function that writes to the AD9122 via the SPI port.
********************************************************************************/


void WriteToAD9122ViaSpi(unsigned char *RegisterData)
{
	unsigned char i;
	unsigned char TempData = 0;
	TempData = *RegisterData;
	
	//Write out the ControlWord
	
	for(i=0; i<8; i++)
	{	
		ADuC7026_OutputBit(AD9122_SCLK,0);
		
		if(0x80 == (TempData & 0x80))
		{
			ADuC7026_OutputBit(AD9122_SDIN,1);	  //Send one to DIN pin
		}
		else
		{
			ADuC7026_OutputBit(AD9122_SDIN,0);	  //Send zero to DIN pin
		}
		
		ADuC7026_OutputBit(AD9122_SCLK,1);
		
		TempData <<= 1;	//Rotate data
		

	}
		

}

/********************************************************************************
Function that read from the AD9122 via the SPI port.
********************************************************************************/


void ReadFromAD9122ViaSpi(unsigned char *RegisterData)
{

	
	unsigned	int	    i= 0;
	unsigned	int  	iTemp = 0;


	// SPI start
	for(i=0; i<8; i++)
	{
		
		ADuC7026_OutputBit(AD9122_SCLK,1);
		
		ADuC7026_OutputBit(AD9122_SCLK,0);

		iTemp<<=1;
			 
		iTemp |= ADuC7026_InputBit(AD9122_SDOUT);			// P4.4->SDout


	}
  
	*RegisterData=iTemp;

}

