/********************************************************************************
 Author             : CAST (China Applications Support Team) 

 Date               : 4-21-2011

 File name          : AD9122.h

 DeScription        : Using ADuC7026 to control AD9122 in software SPI form through GPIO;
			          In this project we use the example start-up routing in the datasheet;
			          You can both check it in the AD9122 datasheet page 59 and readme.txt 
					  inside the project folder.

 Hardware plateform : ADuC7026 + AD9122 	
********************************************************************************/

#ifndef AD9122_IO_H
#define AD9122_IO_H

void WriteToAD9122ViaSpi(unsigned char *RegisterData);
void ReadFromAD9122ViaSpi(unsigned char *RegisterData);


#define READ    (0x01<<7)
#define WRITE   (0x00<<7)

//----------------------------------
/*********REGISTER AddreSS*********/
//----------------------------------
#define COMM                   0x00
#define POWER_CONTROL          0x01
#define DATA_FORMAT            0x03
#define INTERRUPT_ENABLE_1     0x04
#define INTERRUPT_ENABLE_2     0x05
#define EVENT_FLAG_1           0x06
#define EVENT_FLAG_2           0x07
#define CLOCK_RECEIVER_CONTROL 0x08
#define PLL_CONTROL_1          0x0A
#define PLL_CONTROL_2          0x0B
#define PLL_CONTROL_3          0x0C
#define PLL_CONTROL_4          0x0D
#define PLL_STATUS_1           0x0E
#define PLL_STATUS_2           0x0F
#define SYNC_CONTROL_1         0x10
#define SYNC_CONTROL_2         0x11
#define SYNC_STATUS_1          0x12
#define SYNC_STATUS_2          0x13
#define DATA_REGISTER_STATUS   0x15
#define DCI_DELAY              0x16
#define FIFO_CONTROL           0x17
#define FIFO_STATUS_1          0x18
#define FIFO_STATUS_2          0x19
#define DATAPATH_CONTROL       0x1B
#define HB1_CONTROL_1          0x1C
#define HB2_CONTROL_2          0x1D
#define HB3_CONTROL_3          0x1E
#define CHIP_ID                0x1F
#define FTW_LSB                0x30
#define FTW_1                  0x31
#define FTW_2                  0x32
#define FTW_MSB                0x33
#define NCO_PHASE_OFFSET_LSB   0x34
#define NCO_PHASE_OFFSET_MSB   0x35
#define NCO_FTW_UPDATE         0x36
#define I_PHASE_ADJ_LSB        0x38
#define I_PHASE_ADJ_MSB        0x39
#define Q_PHASE_ADJ_LSB        0x3A
#define Q_PHASE_ADJ_MSB        0x3B
#define I_DAC_OFFSET_LSB       0x3C
#define I_DAC_OFFSET_MSB       0x3D
#define Q_DAC_OFFSET_LSB       0x3E
#define Q_DAC_OFFSET_MSB       0x3F
#define I_DAC_FS_ADJ           0x40
#define I_DAC_CONTROL          0x41
#define AUX_DAC_I_DATA         0x42
#define I_AUX_DAC_CONTROL      0x43
#define Q_DAC_FS_ADJ           0x44
#define Q_DAC_CONTROL          0x45
#define AUX_DAC_Q_DATA         0x46
#define Q_AUX_DAC_CONTROL      0x47
#define DIE_TEMP_RANGE_CONTROL 0x48
#define DIE_TEMP_LSB           0x49
#define DIE_TEMP_MSB           0x4A
#define SED_CONTROL            0x67
#define COMPARE_IO_LSBS        0x68
#define COMPARE_IO_MSBS        0x69
#define COMPARE_Q0_LSBS        0x6A
#define COMPARE_QO_MSBS        0x6B
#define COMPARE_I1_LSBS        0x6C
#define COMPARE_I1_MSBS        0x6D
#define COMPARE_Q1_LSBS        0x6E
#define COMPARE_Q1_MSBS        0x6F
#define SED_I_LSBS             0x70
#define SED_I_MSBS             0x71
#define SED_Q_LSBS             0x72
#define SED_Q_MSBS             0x73
#define REVISION               0x7F

//function bitS' configuration
#define    NOP                        0x00

#define    SDIO                      (0x01<<7)
#define    LSB_FIRST                 (0x01<<6)
#define    RESET                     (0x01<<5)
#define    COMM_DEFAULT               0x00

#define    POWER_DOWN_DAC_I          (0x01<<7)
#define    POWER_DOWN_DAC_Q          (0x01<<6)
#define    POWER_DOWN_DATA_RECEIVER  (0x01<<5)
#define    POWER_DOWN_AUXILIARY_ADC  (0x01<<4)
#define    PLL_LOCK_STATUS           (0x01<<0)

#define    BINARY_DATA_FORMAT        (0x01<<7)
#define    Q_DATA_FIRST              (0x01<<6)
#define    MSB_SWAP                  (0x01<<5)
#define    DATA_WORD_MODE            0x00
#define    DATA_byte_MODE            0x01
#define    DATA_NIBBLE_MODE          0x10
#define    DATA_INVALID              0x11

#define    ENABLE_PLL_LOCK_LOST       (0x01<<7)
#define    ENABLE_PLL_LOCKED          (0x01<<6)
#define    ENABLE_SYNC_SINGAL_LOST    (0x01<<5)
#define    ENABLE_SYNC_SINGAL_LOCKED  (0x01<<4)
#define    ENABLE_SYNC_PHASE_LOCKED   (0x01<<3)
#define    ENABLE_SOFT_FIFO_SYNC      (0x01<<2)
#define    ENABLE_FIFO_WARNING_1       (0x01<<1)
#define    ENABLE_FIFO_WARNING_2      (0x01<<0)

#define    ENABLE_AED_COMPARISON_PASS  (0x01<<4)
#define    ENABLE_AED_COMPARISON_FAIL  (0x01<<3)
#define    ENABLE_SED_COMPARISON_FAIL  (0x01<<2)


#define     En_DACCLK_DUTY_CORRECTION   (0x01<<7)
#define     En_REFCLK_DUTY_CORRECTION   (0x01<<6)
#define     En_DACCLK_CROSS_CORRECTION  (0x01<<5)
#define     En_REFCLK_CROSS_CORRECTION  (0x01<<4)

#define     PLL_CONTROL_2_DEFAULT         0x00
#define     PLL_CONTROL_3_DEFAULT         0xD1
#define     PLL_CONTROL_4_DEFAULT         0xD9
#define     PLL_ENABLE                   (0x01<<7)
#define     PLL_MANUAL_ENABLE            (0x01<<6)
#define    	PLL_VCO_ENABLE               (0x01<<5)
#define     PLL_CHARGE_PUMP_4            (0x01<<4)

#define     SYNC_CONTROL_DEFAULT          0x48
#define     FIFO_CONTROL_DEFAULT          0x04
#define     FIFO_SOFT_ALIGN_REQUEST       0x02
#define     FIFO_CLR                      0x00
#define     BYPASS_PREMOD                (0x01<<7)
#define     NCO_GAIN                     (0x01<<3)

#define     HB1                           0x04
#define     HB3                           0x24
#define     BYPASS_HB3                    0x01

#define     UPDATE_FTW_REQUEST            0x01
#define     NCO_FTW_UPDATE_DEFAULT        0x00

#endif


























































