/********************************************************************************
 Author             : CAST (China Applications Support Team) 

 Date               : 4-21-2011

 File name          : ADuC7026Test.c

 Description        : Using ADuC7026 to CONTROL AD9122 in software SPI form through GPIO;
			          In this project we use the example start-up routing in the datasheet;
			          You can both check it in the AD9122 datasheet page 59 and readme.txt 
					  inside the project folder.

 Hardware plateform : ADuC7026 + AD9122 	
********************************************************************************/
#include <ADuC7026.h>
#include "ADuC7026Driver.h"
#include "AD9122.h"

//---------------------------------------------------------------
//The format of the  16bit instruction word read as follows
// |R/W|A6|A5|A4|A3||A2|A1|A0|
//---------------------------------------------------------------



unsigned char ins1[36] =
{
  (WRITE | COMM)           ,  RESET                                            ,
  (WRITE | COMM)           ,  COMM_DEFAULT                                     ,
  (WRITE | PLL_CONTROL_2)  ,  PLL_VCO_ENABLE                                   ,
  (WRITE | PLL_CONTROL_3)  , (PLL_CONTROL_3_DEFAULT | PLL_CHARGE_PUMP_4)       ,
  (WRITE | PLL_CONTROL_4)  ,  PLL_CONTROL_4_DEFAULT                            ,
  (WRITE | PLL_CONTROL_1)  , (PLL_ENABLE | PLL_MANUAL_ENABLE | 0x0F)           ,
  (WRITE | PLL_CONTROL_1)  , (PLL_ENABLE | 0x20)                               ,
  (WRITE | SYNC_CONTROL_1) ,  SYNC_CONTROL_DEFAULT                             ,
  (WRITE | FIFO_CONTROL)   ,  FIFO_CONTROL_DEFAULT                             ,
  (WRITE | FIFO_STATUS_1)  ,  FIFO_SOFT_ALIGN_REQUEST                          ,
  (WRITE | FIFO_STATUS_1)  ,  FIFO_CLR                                         ,
  (WRITE | HB3_CONTROL_3)  ,  BYPASS_HB3                                       ,
  (WRITE | FTW_LSB)        ,  0x55                                             ,
  (WRITE | FTW_1)          ,  0x55                                             ,
  (WRITE | FTW_2)          ,  0xD5                                             ,
  (WRITE | FTW_MSB)        ,  0x11                                             ,
  (WRITE | NCO_FTW_UPDATE) ,  UPDATE_FTW_REQUEST                               ,
  (WRITE | NCO_FTW_UPDATE) ,  NCO_FTW_UPDATE_DEFAULT
};

unsigned char ins2[14] =
{ 
  (READ | COMM)           ,       
  (READ | PLL_CONTROL_2)  ,       
  (READ | PLL_CONTROL_3)  ,         
  (READ | PLL_CONTROL_4)  ,       
  (READ | PLL_CONTROL_1)  ,       
  (READ | SYNC_CONTROL_1) ,       
  (READ | FIFO_CONTROL)   ,       
  (READ | FIFO_STATUS_1)  ,       
  (READ | HB3_CONTROL_3)  ,       
  (READ | FTW_LSB)        ,       
  (READ | FTW_1)          ,       
  (READ | FTW_2)          ,       
  (READ | FTW_MSB)        ,       
  (READ | NCO_FTW_UPDATE)       
} ;	



int main()
{ 
	unsigned char i;
	unsigned char buf;

	ADuC7026_Initiate();
	ADuC7026_OutputBit(AD9122_CS,1);

	for(i=0;i<36;i++)
	{
		ADuC7026_OutputBit(AD9122_CS,0);
		
		WriteToAD9122ViaSpi((ins1+i));
		++i;
		WriteToAD9122ViaSpi((ins1+i));

		ADuC7026_OutputBit(AD9122_CS,1);
	}
	
					  
    for(i=0;i<14;i++)
	{
		ADuC7026_OutputBit(AD9122_CS,0);
		
		WriteToAD9122ViaSpi((ins2+i));
		ReadFromAD9122ViaSpi(&buf);
		putchar(buf);

		ADuC7026_OutputBit(AD9122_CS,1);
	}


    while(1){;}
	return 0;
}

