/********************************************************************************
 Author             : CAST (China Applications Support Team) 

 Date               : 4-21-2011

 File name          : ADuC7026Driver.h

 Description        : Using ADuC7026 to control AD9122 in software SPI form through GPIO;
			          In this project we use the example start-up routing in the datasheet;
			          You can both check it in the AD9122 datasheet page 59 and readme.txt 
					  inside the project folder.

 Hardware plateform : ADuC7026 + AD9122 	
********************************************************************************/
#ifndef ADUC7026_DRIVER_H
#define ADUC7026_DRIVER_H
//-------------------------------------------------------------
//This file contains the common macro and function declarations
//-------------------------------------------------------------


//----------------------
//AD9122 pins configuration
//----------------------
#define AD9122_SDOUT		0x44	// P4.4->SDOUT
#define AD9122_CS   		0x46	// P4.6->CS
#define AD9122_SDIN 		0x43	// P4.3->SDIN
#define	AD9122_SCLK			0x23	// P2.3->SCLK



//----------------------
//External Function declarations
//----------------------
unsigned char ADuC7026_InputBit(unsigned char GPIONum);
void ADuC7026_OutputBit(unsigned char GPIONum, unsigned char Data);
void ADuC7026_Initiate(void);
void Delay(unsigned long int DelayTime);
void putchar(unsigned char);

#endif






