/************************************************************************************************

 Author        : ADI - Apps            www.analog.com/

 Date          : June 2010

 File          : DACTest.c

 Hardware      : ADuC7124

 Description   : This Simple DAC example shows how to initialize the part for 
 				continuous sampling using Single-ended inputs, how to calculate a voltage and send it to the UART
				Use HyperTerminal with 9600 baud, 8 data bits, No parity, 1 stop bit, No flow control as teh viewing terminal		
*************************************************************************************************/
#include<aduc7124.h>
# include "stdio.h"
# include "string.h"

void delay (int);                               // Delay function
void SelectDAC (unsigned char);

int szADCvalues[16];                   			// Used to save the 16 tension values 
unsigned char szADCvalues2[64] = "";			// Used to store ADC0 result before printing to UART
unsigned char ucSelectDAC = 0; 					// Indicates DAC output used in ADC tests
int readend=0;                                  // Used to indicate that the convertion of 16 values is over
int time=2000;
int i=0;
unsigned char ucADCChannel = 0;
unsigned char ucDACChannel = 0;
unsigned char ucGPIOStatus = 0;
 unsigned long timer0Value = 0;
 unsigned long timer1Value = 0;
 unsigned long timer2Value = 0;
 unsigned long timer3Value = 0;
int k=0;
int j=0;
int x=0;
int y=0x000;

// 64bit array to generate analog signal
unsigned long waveArray[64]={0x000,0x080,0x100,0x180,0x200,0x280,0x300,0x380,0x400,0x480,0x500,0x580,0x600,0x680,0x700,0x780,0x800,0x880,0x900,0x980,0xA00,0xA80,0xB00,0xB80,0xC00,0xC80,0xD00,0xD80,0xE00,0xE80,0xF00,0xF80,0xF80,0xF00,0xE80,0xE00,0xD80,0xD00,0xC80,0xC00,0xB80,0xB00,0xA80,0xA00,0x980,0x900,0x880,0x800,0x780,0x700,0x680,0x600,0x580,0x500,0x480,0x400,0x380,0x300,0x280,0x200,0x180,0x100,0x080,0x000};

int main(void)
{
     unsigned char z=0;

	POWKEY1 = 0x01;
	POWCON0 = 0x00;								// Set core at maximum speed
	POWKEY2 = 0xF4;
 
    DAC0CON = 0x13;
	DAC0DAT = 0x8000000;
 	
	while(1)
	{
  		for (z=0; z<64; z++)
  		{
			DAC0DAT=(waveArray[z] <<16);
			delay(500);
  		}
	}
}


void IRQ_Handler(void) __irq
{
}

void delay (int length)
{
	while (length >0)
    	length--;
}
