/************************************************************************************************

 Author        : ADI - Apps            www.analog.com/

 Date          : June 2010

 File          : I2CTestSlave.c

 Hardware      : ADuC7124

 Description   : This Simple example shows how to initialize the part as a Slave for 
 				 I2C communication and use it to recieve data from The Master chip. 		
*************************************************************************************************/
// Bit Definitions
#define BIT2  0x04
#define BIT3  0x08
#define BIT8  0x100
#define BIT10 0x400
#define BIT13 0x2000

#include<aduc7124.h>

unsigned char szTxData[16];	// Array to recieve from master
unsigned char ucTxCount = 0;  // Array index variable for szTxData[]
unsigned char szRxData[16];	  // Array for reading Data from Slave
unsigned char ucRxCount = 0;  // Array index variable for szRxData[]

unsigned char szStoreData[16];	// Array to store data from master
unsigned char ucStoreCount = 0;  // Array index variable for szStoreData[]

int main(void)
{
	POWKEY1 = 0x01;
	POWCON0 = 0x00;								// Set core at maximum speed
	POWKEY2 = 0xF4;

	POWKEY3 = 0x76;
	POWCON1 = 0x124;							//powers up SPI & I2C (by default)
	POWKEY4 = 0xB1;

	GP1CON = 0x2222;							//Set P1.0-3 as I2C pins
	
	I2C0SCON = 0x701;
	I2C0ID0 = 0xA0;

	// Begin Slave Transmit sequence
	I2C0FSTA = BIT8;						// Flush Slave Tx FIFO
	I2C0FSTA &= ~BIT8;

	IRQCONE = 0x02;			// Rising edge of XIRQ0
	IRQEN = 0x22200; 		// Enable I2C0S + XIRQ0 interrupt + uart

  	// Begin receive sequence
	ucTxCount = 0;
	I2C0STX = szTxData[ucTxCount++];
	ucRxCount = 0;

	while(1)
	{   
	}

}

void IRQ_Handler(void) __irq
{  
 unsigned long IRQSTATUS = 0;
 unsigned long I2C0SSTATUS = 0; 

	IRQSTATUS = IRQSTA;	                		// Read off IRQSTA register

	if ((IRQSTATUS & BIT13) == BIT13)	//If I2C Slave interrupt source
	{
	   I2C0SSTATUS = I2C0SSTA;
	   if ((I2C0SSTATUS & BIT2) == BIT2) // If I2C Slave Tx IRQ
	   {
			if (ucStoreCount < 6)		   // Have max 6 bytes been sent?
				I2C0STX = szStoreData[ucStoreCount++];	 // Load Tx buffer
	   }
	   if ((I2C0SSTATUS & BIT3) == BIT3) // If I2C Slave Rx IRQ
	   {
			if (ucStoreCount < 6)		   // Have max 6 bytes been received?
			{
				szStoreData[ucStoreCount] = I2C0SRX;  // Read Rx buffer
				ucStoreCount++;
			}
	   }
	   if ((I2C0SSTATUS & BIT10) == BIT10) // If I2C Stop after Start condition detected IRQ
	   {
			ucStoreCount = 0;	// Reset counter Array pointer.
			I2C0FSTA = BIT8;			// Flush Slave Tx FIFO
			I2C0FSTA &= ~BIT8;
	   }
	   if ((I2C0SSTATUS & BIT13) == BIT13) // If I2C Repeated Start detected IRQ
	   {
			ucStoreCount = 0;	// Reset counter Array pointer.
			I2C0FSTA = BIT8;			// Flush Slave Tx FIFO
			I2C0FSTA &= ~BIT8;
	   }
	}
}
