/*********************************************************************
  
 Author        : ADI - Apps            www.analog.com/ADuC7023

 Date          : October 2009

 File          : Lifetest.c

 Hardware      : Applicable to ADuC7023 rev A later silicon
                 
 Description   : Burnin Test code
		
*********************************************************************/
#include <aduc7124.h>
// Bit Definitions
#define BIT0  0x01
#define BIT1  0x02
#define BIT2  0x04
#define BIT3  0x08
#define BIT4  0x10
#define BIT5  0x20
#define BIT6  0x40
#define BIT7  0x80
#define BIT8  0x100
#define BIT9  0x200
#define BIT10 0x400
#define BIT11 0x800
#define BIT12 0x1000
#define BIT13 0x2000
#define BIT14 0x4000
#define BIT15 0x8000

// Place Global Variables here
unsigned long voltage, current;
unsigned long *Flash_Pointer;
unsigned long led_toggle;
unsigned int i;
unsigned long ADCDATA[32];
// array used to generate an sinewave using DAC	
const static unsigned short TableS[64] = 
{
 	0x07FF, 0x08C8, 0x098E, 0x0A51, 0x0B0F, 0x0BC4, 0x0C71, 0x0D12,
 	0x0DA7, 0x0E2E, 0x0EA5, 0x0F0D, 0x0F63, 0x0FA6, 0x0FD7, 0x0FF5,
 	0x0FFF, 0x0FF5, 0x0FD7, 0x0FA6, 0x0F63, 0x0F0D, 0x0EA5, 0x0E2E,
 	0x0DA7, 0x0D12, 0x0C71, 0x0BC4, 0x0B0F, 0x0A51, 0x098E, 0x08C8,
 	0x07FF, 0x0736, 0x0670, 0x05AD, 0x04EF, 0x043A, 0x038D, 0x02EC,
 	0x0257, 0x01D0, 0x0159, 0x00F1, 0x009B, 0x0058, 0x0027, 0x0009,
 	0x0000, 0x0009, 0x0027, 0x0058, 0x009B, 0x00F1, 0x0159, 0x01D0,
 	0x0257, 0x02EC, 0x038D, 0x043A, 0x04EF, 0x05AD, 0x0670, 0x0736  
};

// Place prototypes here
void Adc_code(void);
void Dac_code(void);
void CPU_test(void);
void Flash_test(void);
void delay(int);
void InitTimers(void);
void InitSPIandI2C(void);
void InitUart(void);
void ConfigurePWM(void);
short wait_flash_busy(void);
void ADCpoweron(int);
unsigned int uiPLLTST = 0;
volatile unsigned int ucTest = 0;


int main(void) 
{
	POWKEY1 = 0x01;					// Configure CPU Clock for 41.78MHz, CD=0
 	POWCON0 = 0x00;
 	POWKEY2 = 0xF4;	
	ADCpoweron(20000);				// power-on/init ADC
	// clear GP Ports and setup as inputs again.
  	GP0DAT = GP1DAT = GP2DAT = 0; 
	InitTimers();
	InitSPIandI2C();
	InitUart();
	ConfigurePWM();

	GP3DAT = 0x20000000;			//P3.5 as an output -- LED pin
	GP4DAT = 0x4000000;		 		//P4.2 as an output -- toggle pin
	
	  // Toggle P4.4 to indicate that we have entered user code ok
  	GP4DAT = 0x10000000;
  	delay(10);
  	GP4DAT = 0x10100000;
	GP0DAT = 0x80000000;			// P0.7 output
	  
  	led_toggle = 0;
	IRQEN = 0x114;					// Timer 0, ADC and Timer 2 IRQ sources
	FIQEN = 0x8;					// Timer 1 FIQ source
	while (1) 
	{
       // Toggle the LED on the burnin board 
	  led_toggle ^= 0x200000;
	  GP3DAT &= ~(0x200000);
      GP3DAT |= led_toggle | 0x20000000;
	 	 
      delay(2000);					// equates to approx 1mS
      Dac_code();					// execute DAC Test				 
      delay(2000);					// equates to approx 1mS	

      //Flash_test();				// execute FLASH Test
      delay(2000);					// equates to approx 1mS
	
      CPU_test();					// execute CPU Test					
      delay(2000);					// equates to approx 1mS
	  
 	 
    }		   	
					
}

void delay (int length) 
{
	while (length >=0)
	{
    	length--;
		GP4DAT ^= 0x0040000;		// Complement P4.2
	}
}
void InitTimers(void)
{
	T0CON = 0xC0;					// Enable Timer 0. HCLK source. Div/1
	T1CON = 0x2C0;					// Enable Timer 1. HCLK source. Div/256
	T3CON = 0xCA;					// Enable Timer 2. HCLK source. Div/256

	T0LD =  417800;					// 10mS Timer
	T1LD =  0x4FB06;				// 5S Timer
	T3LD =  0x27D83;				// 1S Timer
}
void InitSPIandI2C(void)
{
 	
	POWKEY3 = 0x76;
	POWCON1 = 0x924;				// Power up SPI, I2C0 and I2C1
	POWKEY4	= 0xB1;
	GP1CON = 0x22222211;			// Configure P1.[0:7] for UART0, I2C1 and SPI modes
	// Enable I2C Master mode, baud rate and interrupt sources
	I2C1MCON = 0x131;				// Enable I2C Master + Enable Rx interrupt
	 								// Enable Tx interrupt + Enable transmission complete interrupt
									// Enable Nack received IRQ
	I2C1DIV  = 0xC0C0;				// Select  clock rate
	// Begin Master Transmit sequence
	I2C1FSTA = BIT9;						// Flush Master Tx FIFO
	I2C1FSTA &= ~BIT9;

	SPICON = 0xAC3; 	  			// Enable SPI + Enable SPI Master
		    		 				// Clk pulses high at start of each bit + Initiate transfer on write to Tx FIFO
									// Transmit 0x00 when Tx FIFo is empty
									// Enable MISO output driver.
		   				   			//Continuous transfer mode + Enable IRQ on 2 byte transfer
	SPIDIV  = 0x31;	   				// Select 101kHz clock rate = 0x31
}
void InitUart(void)
{
	COM0CON0 = BIT7;			   	// Enable access to COMDIV registers
    COM0DIV0 = 0x88;	       		// Set baud rate to 9600.
    COM0DIV1 = 0x00;
    
    COM0CON0 = BIT0 + BIT1 + BIT2;
    COM0IEN0 = BIT0 + BIT1;	        // Enable UART interrupts when Rx full and Tx buffer empty.

}
void ConfigurePWM(void)
{
   //Configure PWM0 for 20khz duty cycle
	PWM0COM0 = 0x40;				//	Configure PWM0 output high trigger time
	PWM0COM1 = 0x9F;				//	Configure PWM0 output Low trigger time
	PWM0COM2 = 0x40;				//	Configure PWM1 output low trigger time
	PWM0LEN = 0xCF;					//	Configure PWM1 output high trigger time
		// Initialize the GPIO pins for PWM mode
//	GP0CON	|= 0x220;  				// Select PWM5,PWM6 as PWM outputs
	GP3CON  = 0x1111;			 	// Select PWM1PWM2,PWM3, PWM4 output, Trip input
	
	PWMCON	= 0x001;		 		// PWM Standard mode, UCLK/2, 		
}
void ADCpoweron(int time)
{
	ADCCON = 0x20;	 				// power-on the ADC
	while (time >=0)	  			// wait for ADC to be fully powered on
    time--;
	REFCON = 0x01;					// internal 2.5V reference. 2.5V on Vref pin	
	ADCCP = 0x00;	  				// select ADC channel 0
	ADCCN = 0x01;	  				// select ADC channel 1
	ADCCON = 0xEEC;					// ADC Config: fADC/8, acq. time = 8 clocks, Differential mode, Continuous conversion mode
}
void Dac_code()
{
	int j = 0;

	// generate 10 sinewaves
	int no_sine_wave = 10;

	DAC0DAT = 0x0;					// reset DATA register
	DAC0CON = 0x13;					// Enable DAC and select AVdd range
	DAC1DAT = 0x0;					// reset DATA register
	DAC1CON = 0x13;					// Enable DAC and select AVdd range
	DAC2DAT = 0x0;					// reset DATA register
	DAC2CON = 0x12;					// Enable DAC and select int_reference range
	DAC3DAT = 0x0;					// reset DATA register
	DAC3CON = 0x12;					// Enable DAC and select int_reference range
	while(j<=64*no_sine_wave)
	{
		// Sequentially output Table values to the DAC. The Table holds values representing
		// DAC Zero scale to full-scale in 64 steps.
		DAC0DAT = (TableS[i] << 16); 
		DAC1DAT = (TableS[i] << 16); 
		DAC2DAT = (TableS[i] << 16); 
		DAC3DAT = (TableS[i] << 16); 
		i++;
		i &= 0x03F;

		// counter used for no_sine_wave
		j++;         	
	}

	delay(100);
	DAC0DAT = 0x0;					// reset DATA register
	DAC1DAT = 0x0;					// reset DATA register
	DAC2DAT = 0x0;					// reset DATA register
	DAC3DAT = 0x0;					// reset DATA register
} // end of Dac_code
void CPU_test()
{
	// At this point the core is in CD == 001, the VCO is trimed 
	//  with 0x1000, PLL is LOCKed to internal OSC and IOCLK
	//  is connected to the PLL and the OSC is trimed with 0x80.

  	// All local variables 
  	unsigned char sys_error = 0x99; // gobal error flag
  	unsigned char loop = 0x0;
  	// 26 core test variables....
  	unsigned int C_var0, C_var1, C_var2, C_var3, C_var4, C_var5;
  	unsigned int C_var6, C_var7, C_var8, C_var9, C_var10, C_var11;
  	unsigned int C_var12, C_var13, C_var14, C_var15, C_var16;
  	unsigned int C_var17, C_var18, C_var19, C_var20, C_var21, C_var22;
  	unsigned int C_var23, C_var24, C_var25;
  	unsigned int C_num0, C_num1, C_num2; // Math variables.....
  	unsigned char C_crap = 0x0; 		 // crap variable to stop optmiz removing if else stuff..
  	unsigned int sys_i;

  	sys_error = 0;

  	// loop x times 
  	while((sys_error == 0x0) && (loop < 0x1))
	{
    	//====================================================
    	// Flash a LED once per loop to show it's still running
    	//====================================================

    	for(sys_i = 0; sys_i <= 2; sys_i++)    // do x num of times !!
 		{
      		//====================================================
      		// The following code tests the ARM and FLASH
      		//  working together as a system.
      		//====================================================
      		// First fill variables with data from flash.... 
      		C_var0  = 0x11111111;
      		C_var1  = 0x44444444;
	  		C_var2  = 0x88888888;
      		C_var3  = 0x55555555;
      		C_var4  = 0xF0F0F0F0;
      		C_var5  = 0x0F0F0F0F;
      		C_var6  = 0xA5A5A5A5;
      		C_var7  = 0x5A5A5A5A;
      		C_var8  = 0xAAAAAAAA;
      		C_var9  = 0x00FF00FF;
      		C_var10 = 0xFF00FF00;
      		C_var11 = 0x18181818;
      		C_var12 = 0x81818181;
      		C_var13 = 0x33333333;
      		C_var14 = 0xCCCCCCCC;
      		C_var15 = 0x66666666;
      		C_var16 = 0x99999999;
      		C_var17 = 0xFFFFFFFF;
      		C_var18 = 0x00000000;
      		C_var19 = 0x77777777;
      		C_var20 = 0xBBBBBBBB;
      		C_var21 = 0xDDDDDDDD;
      		C_var22 = 0xEEEEEEEE;
      		C_var23 = 0x22222222;
      		C_var24 = 0xE7E7E7E7;
      		C_var25 = 0x7E7E7E7E;
      
      		// Check variable contents....
      		if(C_var0  == 0x11111111){C_crap++;}else{C_var15 = 0x63457693;}
      		if(C_var1  == 0x44444444){C_crap++;}else{C_var11 = 0x89735135;}
      		if(C_var2  == 0x88888888){C_crap++;}else{C_var23 = 0x95191974;}
      		if(C_var3  == 0x55555555){C_crap++;}else{C_var16 = 0x65768768;}
      		if(C_var4  == 0xF0F0F0F0){C_crap++;}else{C_var14 = 0x43189732;}
      		if(C_var5  == 0x0F0F0F0F){C_crap++;}else{C_var19 = 0x53768753;}
      		if(C_var6  == 0xA5A5A5A5){C_crap++;}else{C_var12 = 0x77184844;}
      		if(C_var7  == 0x5A5A5A5A){C_crap++;}else{C_var4  = 0x16894696;}
      		if(C_var8  == 0xAAAAAAAA){C_crap++;}else{C_var0  = 0x68616143;}
      		if(C_var9  == 0x00FF00FF){C_crap++;}else{C_var18 = 0x87884786;}
      		if(C_var10 == 0xFF00FF00){C_crap++;}else{C_var21 = 0x64689416;}
      		if(C_var11 == 0x18181818){C_crap++;}else{C_var20 = 0x64701650;}
      		if(C_var12 == 0x81818181){C_crap++;}else{C_var9  = 0x68549846;}
      		if(C_var13 == 0x33333333){C_crap++;}else{C_var22 = 0x14350874;}
      		if(C_var14 == 0xCCCCCCCC){C_crap++;}else{C_var6  = 0x07458658;}
      		if(C_var15 == 0x66666666){C_crap++;}else{C_var7  = 0x96464684;}
      		if(C_var16 == 0x99999999){C_crap++;}else{C_var17 = 0x25478681;}
      		if(C_var17 == 0xFFFFFFFF){C_crap++;}else{C_var2  = 0x66689868;}
      		if(C_var18 == 0x00000000){C_crap++;}else{C_var13 = 0x19498666;}
      		if(C_var19 == 0x77777777){C_crap++;}else{C_var10 = 0x88476554;}
      		if(C_var20 == 0xBBBBBBBB){C_crap++;}else{C_var1  = 0x98325923;}
      		if(C_var21 == 0xDDDDDDDD){C_crap++;}else{C_var5  = 0x89327983;}
      		if(C_var22 == 0xEEEEEEEE){C_crap++;}else{C_var8  = 0x73448957;}
      		if(C_var23 == 0x22222222){C_crap++;}else{C_var3  = 0x33509059;}
      		if(C_var24 == 0xE7E7E7E7){C_crap++;}else{C_var25 = 0x32872449;}
      		if(C_var25 == 0x7E7E7E7E){C_crap++;}else{C_var24 = 0x34372232;}

      		// C_crap should be 26 after above if not error...
      		if(C_crap != 26)
			{
				sys_error = sys_error | 0x1;
      		}

      		C_crap = 0; // clearing for next run...
      
      		// check each variable to it's inverse...
      		if(~C_var0 == C_var22) {C_crap++;}else{C_var0=+1;}
      		if(~C_var1 == C_var20) {C_crap++;}else{C_var1=+1;}
      		if(~C_var2 == C_var19) {C_crap++;}else{C_var2=+1;}
      		if(~C_var3 == C_var8)  {C_crap++;}else{C_var3=+1;}
      		if(~C_var4 == C_var5)  {C_crap++;}else{C_var4=+1;}
      		if(~C_var5 == C_var4)  {C_crap++;}else{C_var5=+1;}
      		if(~C_var6 == C_var7)  {C_crap++;}else{C_var6=+1;}
      		if(~C_var7 == C_var6)  {C_crap++;}else{C_var7=+1;}
      		if(~C_var8 == C_var3)  {C_crap++;}else{C_var8=+1;}
      		if(~C_var9 == C_var10) {C_crap++;}else{C_var9=+1;}
      		if(~C_var10 == C_var9) {C_crap++;}else{C_var10=+1;}
      		if(~C_var11 == C_var24){C_crap++;}else{C_var11=+1;}
      		if(~C_var12 == C_var25){C_crap++;}else{C_var12=+1;}
      		if(~C_var13 == C_var14){C_crap++;}else{C_var13=+1;}
      		if(~C_var14 == C_var13){C_crap++;}else{C_var14=+1;}
      		if(~C_var15 == C_var16){C_crap++;}else{C_var15=+1;}
      		if(~C_var16 == C_var15){C_crap++;}else{C_var16=+1;}
      		if(~C_var17 == C_var18){C_crap++;}else{C_var17=+1;}
      		if(~C_var18 == C_var17){C_crap++;}else{C_var18=+1;}
      		if(~C_var19 == C_var2) {C_crap++;}else{C_var19=+1;}
      		if(~C_var20 == C_var1) {C_crap++;}else{C_var20=+1;}
      		if(~C_var21 == C_var23){C_crap++;}else{C_var21=+1;}
      		if(~C_var22 == C_var0) {C_crap++;}else{C_var22=+1;}
      		if(~C_var23 == C_var21){C_crap++;}else{C_var23=+1;}
      		if(~C_var24 == C_var11){C_crap++;}else{C_var24=+1;}
      		if(~C_var25 == C_var12){C_crap++;}else{C_var25=+1;}

      		// C_crap should be 26 after above if not error...
      		if(C_crap != 26)
			{
				sys_error = sys_error | 0x1;
      		}

      		C_crap = 0; // clearing for next run...

      	//	asm (".LTORG");
      		// Arithmetic tests....
      		// using & and | to generate numbers and answer for C_num0 * C_num1 = C_num2
      		C_num0 = 0x12345678;
      		if(0x3 == (C_num0 = ((C_num0 | 0x3) & 0x3))){C_crap++;}else{C_num0 = C_num0 * 0xF;}
      
      		C_num1 = 0x83487954;
      		if(0x8 == (C_num1 = ((C_num1 | 0x8) & 0x8))){C_crap++;}else{C_num1 = C_num1 * 0x8;}
      
      		C_num2 = 0x87384873;
      		if(0x18 == (C_num2 = ((C_num2 | 0x18) & 0x18))){C_crap++;}else{C_num2 = C_num2 * 0x8;}
       
      		if(C_num2 == (C_num0 * C_num1)){C_crap++;}else{C_num2 = 0x55555555;}
      
      		// C_crap should be 3 after above if not error...
     		if(C_crap != 4){sys_error = sys_error | 0x1;}
      		C_crap = 0; // clearing for next run...
      
      		// Setup new value for next test..
      		C_num0 = C_num1 = C_num2 = 0x8;
      
      		if(C_num0 == (((((((C_num1 + 0x10) * 0x2) - 0x15) * 3) - 0x50) ^ C_num2) - 1)){C_crap++;}else{C_num0 = 0x12121212;}
      
      		if(C_num1 == ((((((C_num0 * 5) + 8) * 3) & 0x10) ^ C_num2) - 0x10)){C_crap++;}else{C_num1 = 0x87349834;}
      
      		if(C_num2 == ((((((~(C_num0 >> 3) +1) + 1) * 0x15) | 0x33) & 0x10)>>1)){C_crap++;}else{C_num1 = 0x87349834;}
      
      		// C_crap should be 3 after above if not error...
      		if(C_crap != 3){sys_error = sys_error | 0x1;}
      		C_crap = 0; // clearing for next run...
      
      		// Setup variables for checks...
      		C_var0  = 0x78528979;
      		C_var1  = 0x33748637;
      		C_var2  = 0x53764985;
      		C_var3  = 0x66078980;
      		C_var4  = 0x56483618;
      		C_var5  = 0x55681764;
      		C_var6  = 0x58456548;
      		C_var7  = 0x65384046;
      		C_var8  = 0x80573495;
      		C_var9  = 0x47808347;
      		C_var10 = 0x86541638;
      		C_var11 = 0x75947658;
      		C_var12 = 0x65165610;
      		C_var13 = 0x54795674;
      		C_var14 = 0x93234612;
      		C_var15 = 0x16561085;
      		C_var16 = 0x56767865;
      		C_var17 = 0x49645464;
      		C_var18 = 0x82446652;
      		C_var19 = 0x97193413;
      		C_var20 = 0x54712536;
      		C_var21 = 0x89149476;
      		C_var22 = 0x75847549;
      		C_var23 = 0x24967987;
      		C_var24 = 0x86545673;
      		C_var25 = 0x54173217;
      
      		// Check variable contents....
      		if(C_var0  == 0x78528979){C_crap++;}else{C_var15 = 0x63463298;}
      		if(C_var1  == 0x33748637){C_crap++;}else{C_var11 = 0x83352456;}
      		if(C_var2  == 0x53764985){C_crap++;}else{C_var23 = 0x51974568;}
      		if(C_var3  == 0x66078980){C_crap++;}else{C_var16 = 0x76875785;}
      		if(C_var4  == 0x56483618){C_crap++;}else{C_var14 = 0x43973466;}
      		if(C_var5  == 0x55681764){C_crap++;}else{C_var19 = 0x76538799;}
      		if(C_var6  == 0x58456548){C_crap++;}else{C_var12 = 0x77449466;}
     		if(C_var7  == 0x65384046){C_crap++;}else{C_var4  = 0x89469678;}
      		if(C_var8  == 0x80573495){C_crap++;}else{C_var0  = 0x61618744;}
      		if(C_var9  == 0x47808347){C_crap++;}else{C_var18 = 0x80886386;}
      		if(C_var10 == 0x86541638){C_crap++;}else{C_var21 = 0x64363416;}
      		if(C_var11 == 0x75947658){C_crap++;}else{C_var20 = 0x70107827;}
      		if(C_var12 == 0x65165610){C_crap++;}else{C_var9  = 0x65498123;}
      		if(C_var13 == 0x54795674){C_crap++;}else{C_var22 = 0x14574534;}
      		if(C_var14 == 0x93234612){C_crap++;}else{C_var6  = 0x07865824;}
      		if(C_var15 == 0x16561085){C_crap++;}else{C_var7  = 0x46484234;}
      		if(C_var16 == 0x56767865){C_crap++;}else{C_var17 = 0x25476855;}
      		if(C_var17 == 0x49645464){C_crap++;}else{C_var2  = 0x68683693;}
      		if(C_var18 == 0x82446652){C_crap++;}else{C_var13 = 0x19654777;}
      		if(C_var19 == 0x97193413){C_crap++;}else{C_var10 = 0x47433974;}
      		if(C_var20 == 0x54712536){C_crap++;}else{C_var1  = 0x98325945;}
      		if(C_var21 == 0x89149476){C_crap++;}else{C_var5  = 0x82834743;}
      		if(C_var22 == 0x75847549){C_crap++;}else{C_var8  = 0x73895723;}
      		if(C_var23 == 0x24967987){C_crap++;}else{C_var3  = 0x50959456;}
      		if(C_var24 == 0x86545673){C_crap++;}else{C_var25 = 0x32724809;}
      		if(C_var25 == 0x54173217){C_crap++;}else{C_var24 = 0x37320894;}

      		// C_crap should be 26 after above if not error...
      		if(C_crap != 26)
			{
				sys_error = sys_error | 0x1;
      		}

      		C_crap = 0; // clearing for next run...
      
		}
		loop++;
	}

	delay(100);

} // end of cpu_test


void	IRQ_Handler(void) __irq		  
{
	unsigned long IRQSTATUS = 0;

	IRQSTATUS = IRQSTA;	   			// Read off IRQSTA register
	if ((IRQSTATUS & 0x4) == 0x4)	//Timer 0
	{									
	   T0CLRI = 0x55;				// Clear Timer 0 IRQ
	   T0LD =  417800;				// 10mS Timer
	   SPITX = 0x55;
	   COM0TX= 0x4A;
	}
	if ((IRQSTATUS & 0x10) == 0x10)	//Timer 2
	{
	   T3CLRI = 0x55;				// Clear Timer 0 IRQ
	   T3LD =  0x27D83;				// 1S Timer
	   GP0DAT ^= 0x00800000;		// Complement P0.7
	}
	if ((IRQSTATUS & 0x100) == 0x100)// ADC interrupt source
	{
		ADCDATA[i++] = ADCDAT ;		// Read ADC result
		I2C1MTX = 0x55;
	    I2C1ADR0 = 0xA0; 
		if (i >= 32)
		{
		    i = 0;
		}
	}
}

void	FIQ_Handler(void) __irq
{
	unsigned long ulFIQSTA = 0;

	ulFIQSTA = FIQSTA;	   			// Read off IRQSTA register

	if ((ulFIQSTA & 0x8) == 0x8)	//Timer 1
	{
	   T1CLRI = 0x55;				// Clear Timer 1 IRQ
	   T1LD =  0xFFB06;				// 5S Timer	
	   I2C1MTX = 0x55;
	   I2C1ADR0 = 0xA0; 
	   GP0DAT ^= 0x00800000;		// Complement P0.7
	}
}
