/************************************************************************************************

 Author        : ADI - Apps            www.analog.com/

 Date          : June 2010

 File          : MeterTest.c

 Hardware      : ADuC7124

 Description   : This Simple ADC example shows how to initialize the ADC for 
 				 continuous sampling using Single-ended inputs, how to calculate a voltage and send it to the UART
				 Use HyperTerminal with 9600 baud, 8 data bits, No parity, 1 stop bit, No flow control as the viewing terminal		
*************************************************************************************************/
// Bit Definitions
#define BIT0  0x01
#define BIT1  0x02
#define BIT2  0x04
#define BIT4  0x10
#define BIT7  0x80
#define BIT8  0x100
#define BIT9  0x200

#include<aduc7124.h>
# include "stdio.h"
# include "string.h"

void delay (int);                               // Delay function
void SendToUART (unsigned char);

volatile unsigned char bSendResultToUART = 0;	// Flag used to indicate ADC0 resutl ready to send to UART	
int szADCvalues[16];                   			// Used to save the 16 tension values 
unsigned char szADCvalues2[64] = "";			// Used to store ADC0 result before printing to UART
unsigned char ucTxBufferEmpty  = 0;				// Used to indicate that the UART Tx buffer is empty
unsigned char ucCharIn = 0;						// Flags byte received over UART - triggers moving to next test.
unsigned char ucSelectDAC = 0; 					// Indicates DAC output used in ADC tests
int readend=0;                                  // Used to indicate that the convertion of 16 values is over
int time=2000;
int i=0;
unsigned char ucADCChannel = 0;
unsigned char ucDACChannel = 0;
unsigned char ucGPIOStatus = 0;
unsigned long ulGP4Val = 0;
unsigned long ulGP3Val = 0;
unsigned long ulGP1Val = 0;
unsigned long ulGP0Val = 0;
unsigned long ulTemp3 = 0;
float ulTemp1  = 0.0;
float ulTemp2  = 0.0;
unsigned char nLen = 0;
int k=0;


int main(void)
{
	ucCharIn = 0;

	POWKEY1 = 0x01;
	POWCON0 = 0x00;								// Set core at maximum speed
	POWKEY2 = 0xF4;
 
    DAC0CON = 0x13;
	DAC0DAT = 0x8000000;

  while (1)
  { 
	REFCON = 0x1;							   // Enables the 2.5V internal reference
	ADCCON = 0x26A4;						   // configure adc for continuous conversion in single-ended mode
	ADCCP =  0x0;							   // select ADC0 Pin
	ulGP4Val = (ADCDAT & 0x0FFF0000) >> 16;	   // read 12 bit ADC result from ADCDAT
	ulTemp1	= (2.5 / 4096);
	ulTemp2 = (ulGP4Val * ulTemp1);

	GP1CON = BIT0 + BIT4;						// P1.0/1.1 as SIN0/SOUT0
	COM0CON0 = BIT7;			        		// Enable access to COMDIV registers
    COM0DIV0 = 0x88;				       		// Set baud rate to 9600.
    COM0DIV1 = 0x00;

    COM0CON0 = BIT0 + BIT1 + BIT2;
    COM0IEN0 = BIT0 + BIT1;	                	// Enable UART interrupts when Rx full and Tx buffer empty.
    IRQEN |= BIT9;
    bSendResultToUART = 0;          
    
   	delay(5000000);
   	
	sprintf ( (char*)szADCvalues2, "Voltage %fV\r\n", ulTemp2 );                        
    nLen = strlen((char*)szADCvalues2);     	// Send the voltage Result to the UART 
	SendToUART(nLen);
  }
}

void SendToUART (unsigned char ucLength)
{
	unsigned char f=0;

	for ( f = 0 ; f < ucLength ; f++ )	        // loop to send ADC0 result
   		{
			COM0TX = szADCvalues2[f];
			ucTxBufferEmpty = 0;
        	while (ucTxBufferEmpty == 0)
	  		{
	  		}
        } 
}

 void IRQ_Handler(void) __irq
{ 
 unsigned long IRQSTATUS = 0; 
 unsigned char ucCOMIID0 = 0;
 volatile unsigned char ucRdUART = 0;

	IRQSTATUS = IRQSTA;	                		// Read off IRQSTA register
	if ((IRQSTATUS & BIT9) == BIT9)				//UART interrupt source
	{
		ucCOMIID0 = COM0IID0;
		if ((ucCOMIID0 & 0x2) == 0x2)			// Transmit buffer empty
		{
		  ucTxBufferEmpty = 1;
		} 
		if ((ucCOMIID0 & 0x4) == 0x4)			// Receive buffer full
		{
		  ucRdUART = COM0RX;
		  ucSelectDAC++;
		  if (ucSelectDAC >=4)
		  	ucSelectDAC = 0;
		  ucCharIn = 1;							// Charachter received so move to next test.
		}	
	}
    if ((IRQSTATUS & BIT8) == BIT8) 			//If ADC0 interrupt source
	{
        if(i<16)
        {
            readend=0;
			szADCvalues[i] = (ADCDAT>>16);      // Read ADC conversion result 
            i++;
        }
        if(i>=16)
        { 
        	readend=1;                 			// Wait 16 values
            IRQCLR = BIT8;
            i=0;
        }    
  	}   
}


void delay (int length)
{
	while (length >0)
    	length--;
}
