/************************************************************************************************

 Author        : ADI - Apps            www.analog.com/

 Date          : June 2010

 File          : PLATest.c

 Hardware      : ADuC7124

 Description   : This Simple example shows how to initialize the PLA on the Aduc7124, use it to incriment a counter
 					on the rising edge of the clock signal and display it's value using the uart.
					Short gpio pins 1.6 & together in order to run this example.
*************************************************************************************************/
// Bit Definitions
#define BIT0  0x01
#define BIT1  0x02
#define BIT2  0x04
#define BIT4  0x10
#define BIT7  0x80
#define BIT9  0x200
#define BIT21 0x200000
#define BIT24 0x1000000

#include<aduc7124.h>
# include "stdio.h"
# include "string.h"

void SendToUART (unsigned char);

volatile unsigned char bSendResultToUART = 0;	// Flag used to indicate ADC0 resutl ready to send to UART	
int szADCvalues[16];                   			// Used to save the 16 tension values 
unsigned char szADCvalues2[64] = "";			// Used to store ADC0 result before printing to UART
unsigned char ucTxBufferEmpty  = 0;				// Used to indicate that the UART Tx buffer is empty
unsigned char ucCharIn = 0;						// Flags byte received over UART - triggers moving to next test.
unsigned char ucSelectDAC = 0; 					// Indicates DAC output used in ADC tests
int readend=0;                                  // Used to indicate that the convertion of 16 values is over
int time=2000;
int i=0;
unsigned char ucADCChannel = 0;
unsigned char ucDACChannel = 0;
unsigned char ucGPIOStatus = 0;
int count  = 0;
unsigned char nLen = 0;
int flagUart = 0;

unsigned long timer0Value = 0;
unsigned long timer1Value = 0;

int main(void)
{
   	ucCharIn = 0;

	POWKEY1 = 0x01;
	POWCON0 = 0x00;								// Set core at maximum speed
	POWKEY2 = 0xF4;

	GP1CON = 0x0011;
	GP1DAT = 0xC0C00000;

	PLAELM1 = 0x004A;				
	PLACLK = 0x00;
	PLAIRQ =0x11;				   //set p.05 as clock input for block0
	
	GP1CON = BIT0 + BIT4;						// P1.0/1.1 as SIN0/SOUT0
	COM0CON0 = BIT7;			        		// Enable access to COMDIV registers
    COM0DIV0 = 0x88;	//0x7C;		       		// Set baud rate to 9600.
    COM0DIV1 = 0x00;

    COM0CON0 = BIT0 + BIT1 + BIT2;
    COM0IEN0 = BIT0 + BIT1;	                	// Enable UART interrupts when Rx full and Tx buffer empty.
    IRQEN |= BIT9;
    bSendResultToUART = 0;

	IRQEN |= BIT21 + BIT24;

	IRQEN |= BIT2;				   //timer0
	T0LD = 0xFFFF;
	T0CON = 0x88;
	timer0Value = T0VAL;

  while (1)
  { 
	if(flagUart == 1)
	{  
	sprintf ( (char*)szADCvalues2, "%d\r", count );                        
    nLen = strlen((char*)szADCvalues2);     // Send the counters' Result to the UART 
	SendToUART(nLen);
	flagUart = 0;
	}
  }    
}

void SendToUART (unsigned char ucLength)
{
	 unsigned char f=0;

	for ( f = 0 ; f < ucLength ; f++ )	        // loop to send ADC0 result
   		{
			ucTxBufferEmpty = 0;
			COM0TX = szADCvalues2[f];
        	while (ucTxBufferEmpty == 0)
	  		{
	  		} 
		}
}

void IRQ_Handler(void) __irq
{ 
 unsigned long IRQSTATUS = 0; 
 unsigned char ucCOMIID0 = 0;
 volatile unsigned char ucRdUART = 0;

	IRQSTATUS = IRQSTA;	                		// Read off IRQSTA register

	 if ((IRQSTATUS & BIT2) == BIT2)				//Timer0
	{		 
		GP1DAT ^=0x800000;
		T0CLRI = 0xFF;
	}

	if ((IRQSTATUS & BIT9) == BIT9)				//UART interrupt source
	{
		ucCOMIID0 = COM0IID0;
		if ((ucCOMIID0 & 0x2) == 0x2)			// Transmit buffer empty
		{
		  ucTxBufferEmpty = 1;
		} 
		if ((ucCOMIID0 & 0x4) == 0x4)			// Receive buffer full
		{
		  ucRdUART = COM0RX;
		  ucSelectDAC++;
		  if (ucSelectDAC >=4)
		  	ucSelectDAC = 0;
		  ucCharIn = 1;							// Charachter received so move to next test.
		}	
	}   
    
	if ((IRQSTATUS & BIT21) == BIT21)
	{
	 if (PLADOUT == 0x02)
  	 {
	 count++;
	 flagUart = 1;
	 GP1DAT ^= 0x400000;		   //P1.6
     }		 
	}   
}
