/************************************************************************************************

 Author        : ADI - Apps            www.analog.com/

 Date          : June 2010

 File          : PWMTest.c

 Hardware      : ADuC7124

 Description   : This Simple example shows how to initialize the PWM on the ADuC7124		
*************************************************************************************************/
// Bit Definitions
#define BIT0  0x01
#define BIT4  0x10
#define BIT8  0x100
#define BIT10 0x400
#define BIT12 0x1000
#define BIT16 0x10000
#define BIT20 0x100000
#define BIT24 0x1000000
#define BIT25 0x2000000
#define BIT28 0x10000000

#include<aduc7124.h>
# include "stdio.h"
# include "string.h"

void delay (int);                               // Delay function
void SelectDAC (unsigned char);

int szADCvalues[16];                   			// Used to save the 16 tension values 
unsigned char szADCvalues2[64] = "";			// Used to store ADC0 result before printing to UART
unsigned char ucSelectDAC = 0; 					// Indicates DAC output used in ADC tests
int readend=0;                                  // Used to indicate that the convertion of 16 values is over
int time=2000;
int i=0;
unsigned char ucADCChannel = 0;
unsigned char ucDACChannel = 0;
unsigned char ucGPIOStatus = 0;

void ConfigurePWM(void);
unsigned char bTripDetected = 0;

int main(void)
{
	POWKEY1 = 0x01;
	POWCON0 = 0x00;								// Set core at maximum speed
	POWKEY2 = 0xF4;

	POWKEY3 = 0x76;
	POWCON1 = 0x924;							//powers up SPI & I2C
	POWKEY4 = 0xB1;
 
	// Initialize the GPIO pins for PWM mode
	GP0CON	= BIT16;  			// Select PWMtrip
	GP2CON  = BIT4 + BIT8		// Select PWM1 and PWM2
			+ BIT16 + BIT20 	// Select PWM1 and PWM2
			+ BIT24 + BIT28; 	// Select PWM3 and PWM4 
	GP3CON  = BIT0 + BIT4 		// Select PWM1 and PWM2
			+ BIT8 + BIT12		// Select PWM3 and PWM3
			+ BIT16 + BIT20 	// Select PWM5 and PWM6
			+ BIT24 + BIT28;	// Select PWMtip and PWMsync
	PWMCON	= BIT0 + BIT10; 	// PWM Standard mode, UCLK/2, PWM Trip interrupt enabled	
	
	ConfigurePWM();			// Call function to configure PWM
	bTripDetected = 0;
	IRQEN	= BIT25;	 	// Enable PWM Trip interrupt source

	while(1)
	{
	   if (bTripDetected == 1)
	    {
	   		bTripDetected = 0;
	   		ConfigurePWM();
		}	   
	}
}
void IRQ_Handler(void) __irq
{
  
   unsigned long IRQSTATUS = 0;

	IRQSTATUS = IRQSTA;	   // Read off IRQSTA register

	if ((IRQSTATUS & BIT25) == BIT25)	//If PWM trip interrupt source
	{
		 bTripDetected = 1;		// Set flag to re configure the PWM block
		 PWMCLRI = 0xFF;		// Clear the PWM trip interrupt source
	}

}

void ConfigurePWM(void)
{
	PWM1COM0 = 0x08;		//	Configure PWM2 output high trigger time
	PWM1COM1 = 0x62;		//	Configure PWM2 output Low trigger time
	PWM1COM2 = 0x01;		//	Configure PWM3 output low trigger time
	PWM1LEN = 0x62;		//	Configure PWM3 output high trigger time
}

void delay (int length)
{
	while (length >0)
    	length--;
}
