/************************************************************************************************

 Author        : ADI - Apps            www.analog.com/

 Date          : June 2010

 File          : PWMTest.c

 Hardware      : ADuC7124

 Description   : This Simple example shows how to initialize the PWM on the ADuC7124		
*************************************************************************************************/
// Bit Definitions
#define BIT0  0x01
#define BIT10 0x400
#define BIT25 0x2000000


#include<aduc7124.h>
# include "stdio.h"
# include "string.h"

void delay (int);                               // Delay function
void SelectDAC (unsigned char);

int szADCvalues[16];                   			// Used to save the 16 tension values 
unsigned char szADCvalues2[64] = "";			// Used to store ADC0 result before printing to UART
unsigned char ucSelectDAC = 0; 					// Indicates DAC output used in ADC tests
int readend=0;                                  // Used to indicate that the convertion of 16 values is over
int time=2000;
int i=0;
unsigned char ucADCChannel = 0;
unsigned char ucDACChannel = 0;
unsigned char ucGPIOStatus = 0;

unsigned char bTripDetected = 0;
void PwmDutyCycle(void);

int main(void)
{
   	POWKEY1 = 0x01;
	POWCON0 = 0x00;								// Set core at maximum speed
	POWKEY2 = 0xF4;

	POWKEY3 = 0x76;
	POWCON1 = 0x924;							//powers up SPI & I2C
	POWKEY4 = 0xB1;

    GP0CON	= 0x10000;  			// Enable the PWM outputs to the GPIO
    GP2CON  = 0x11110110;
	GP3CON 	= 0x11111111;

   PWMCON	= BIT0 + BIT10;
   
  PwmDutyCycle();				// Call Function to configure duty cycle
  bTripDetected = 0;
  IRQEN	= 0x2000000;

   while (1)
   {	     
	 if (bTripDetected == 1)
	    {
	   		bTripDetected = 0;
	   		PwmDutyCycle();
		}	
   }
}

void IRQ_Handler(void) __irq
{ 
   unsigned long IRQSTATUS = 0;

	IRQSTATUS = IRQSTA;	   // Read off IRQSTA register

	if ((IRQSTATUS & BIT25) == BIT25)	//If PWM trip interrupt source
	{
		 bTripDetected = 1;		// Set flag to re configure the PWM block
		 PWMCLRI = 0xFF;		// Clear the PWM trip interrupt source
	}
}

void PwmDutyCycle(void)
{
	PWM1COM0 = 0x08;		  //high
	PWM1COM1 = 0x62;		  //low
	PWM1COM2 = 0x01;		  //high
	PWM1LEN  = 0x62;		  //low
}


void delay (int length)
{
	while (length >0)
    	length--;
}
