/************************************************************************************************

 Author        : ADI - Apps            www.analog.com/

 Date          : June 2010

 File          : SPITestMaster.c

 Hardware      : ADuC7124

 Description   : This Simple example shows how to initialize the SPI on the Master Microcontroller
 				 and use in to transmit data to be stored on the slave chip.		
*************************************************************************************************/
// Bit Definitions
#define BIT4  0x10
#define BIT5  0x20
#define BIT6  0x40
#define BIT9  0x200
#define BIT12 0x1000
#define BIT16 0x10000
#define BIT17 0x20000
#define BIT22 0x400000

#include<aduc7124.h>

void delay (int);                               // Delay function

unsigned char ucWaitingForXIRQ0 = 1; // Flag to begin reading from Slave - controlled by XIRQ0
unsigned char szTxData[] = {0x41, 0x42, 0x43, 0x44, 0xd, 0x0a};	// Array to send to Slave
unsigned char ucTxCount = 0;  // Array index variable for szTxData[]
unsigned char szRxData[16];	  // Array for reading Data from Slave
unsigned char ucRxCount = 0;  // Array index variable for szRxData[]
unsigned char ucDummyRd = 0;
unsigned int SPIMSTATUS = 0;
unsigned char ucTest = 0;
unsigned char UartBytesToSend = 0;
unsigned char ucTxBufferEmpty = 0;
unsigned char n = 0;

int main(void)
{
	POWKEY1 = 0x01;
	POWCON0 = 0x00;								// Set core at maximum speed
	POWKEY2 = 0xF4;

	POWKEY3 = 0x76;
	POWCON1 = 0x124;							//powers up SPI & I2C (by default)
	POWKEY4 = 0xB1;

	GP1CON = 0x22222211;					        

	SPICON = 0xAC3;
	SPIDIV = 0x31;	   		// Select 101kHz clock rate = 0x31
	IRQCONE = 0x02;			// Rising edge of XIRQ0
	IRQEN = 0x30200; 		// Enable SPI + XIRQ0 interrupt	+ uart

	ucTxCount = 0;

	SPITX = szTxData[ucTxCount++];
	ucWaitingForXIRQ0 = 1;
	ucRxCount = 0;

	while(1)
	{
		if (ucWaitingForXIRQ0 == 0)	// Wait for XIRQ0 to trigger - cleared in XIRQ0 ISR
		{
			ucWaitingForXIRQ0 = 1;
			ucRxCount = 0;
			SPICON |= BIT12; // Flush Rx FIFO
			SPICON &= ~BIT12; 
			SPICON &= ~BIT6; // Generate Interrupt on receiving data
			ucDummyRd = SPIRX;
		}

		if (UartBytesToSend == 1)
		{
		 	for (n = 1; n < 7 ; n++)
			{
			while (ucTxBufferEmpty != 1){}
				ucTxBufferEmpty = 0;
				COM0TX = szRxData[n];
			}
			UartBytesToSend = 0;				
		}  
	}
}

void IRQ_Handler(void) __irq
{
 unsigned long IRQSTATUS = 0; 

	unsigned char Underflow = 0;
	unsigned char ucCOM0IID0 = 0;

	IRQSTATUS = IRQSTA;	                		// Read off IRQSTA register
 
	if ((IRQSTATUS & BIT17) == BIT17)	//XIRQ0 interrupt source
	{
		ucWaitingForXIRQ0 = 0;			// Enable Read request from Slave.
		IRQCLRE = BIT17;
	}

	if ((IRQSTATUS & BIT16) == BIT16)	//If SPI Master interrupt source
	{
	   SPIMSTATUS = SPISTA;
	   if ((SPIMSTATUS & BIT4) == BIT4) // SPI Tx underflow
	   {
			Underflow = 1;
	   }
	   if ((SPIMSTATUS & BIT5) == BIT5) // If SPI Master Tx IRQ
	   {
			if (ucTxCount < 6)		   // Have max 6 bytes been sent?
			{
				SPITX = szTxData[ucTxCount++];	 // Load Tx buffer
				SPITX = szTxData[ucTxCount++];	 // Load Tx buffer
				SPITX = szTxData[ucTxCount++];	 // Load Tx buffer
			}
	   }
	   if ((SPIMSTATUS & BIT6) == BIT6) // If SPI Master Rx IRQ
	   {
			ucTest++;
			GP0DAT ^= BIT22;	// Toggle LED on Evaluation board (P0.6)
			if (ucRxCount < 7)		   // Have max 6 bytes been received?
			{
				szRxData[ucRxCount++] = SPIRX;  // Read Rx buffer
				szRxData[ucRxCount++] = SPIRX;  // Read Rx buffer
				szRxData[ucRxCount++] = SPIRX;  // Read Rx buffer
			}
			else
			{
				ucRxCount = 0;

				UartBytesToSend = 1;
			}
			GP0DAT ^= BIT22;	// Toggle LED on Evaluation board (P0.6)
	   }
	}
	if ((IRQSTATUS & BIT9) == BIT9)	//UART interrupt source
	{
		ucCOM0IID0 = COM0IID0;
		if ((ucCOM0IID0 & 0x2) == 0x2)	  // Transmit buffer empty
		{
		  ucTxBufferEmpty = 1;
		}
	}

	if ((IRQSTATUS & 0x4) == 0x4)	//Timer 0
	{									
	   T0CLRI = 0x55;				// Clear Timer 0 IRQ
	   T0LD =  417800;				// 10mS Timer
	   SPITX = 0x55;
	   COM0TX= 0x4A;
	}
}

void delay (int length)
{
	while (length >0)
    	length--;
}
