/************************************************************************************************

 Author        : ADI - Apps            www.analog.com/

 Date          : June 2010

 File          : SPITestSlave.c

 Hardware      : ADuC7124

 Description   : This Simple example shows how to initialize the SPI on the Slave Microcontroller
 				 and use in to recive and store data from the Master chip.		
*************************************************************************************************/
// Bit Definitions
#define BIT6  0x40
#define BIT7  0x80
#define BIT13 0x2000
#define BIT16 0x10000
#define BIT17 0x20000

#include<aduc7124.h>                               // Delay function

unsigned char szStoreData[16] ;	// Array to recieve from master
unsigned char ucStoreCount = 0;  // Array index variable for szStoreData[]
unsigned char ucWaitingForXIRQ0 = 1; // Flag to begin write from Slave - controlled by XIRQ0
unsigned char ucReadOnly = 0;
unsigned char ucTxCnt = 0;
unsigned char ucbuffer = 0;

int main(void)
{
	POWKEY1 = 0x01;
	POWCON0 = 0x00;								// Set core at maximum speed
	POWKEY2 = 0xF4;

	POWKEY3 = 0x76;
	POWCON1 = 0x124;							//powers up SPI & I2C
	POWKEY4 = 0xB1;

    GP1CON = 0x22220000;					        //Set P1.4, P1.5, P1.6, P1.7 as SPI Pin

	SPICON = 0xB81;							//Slave Setup
	IRQCONE = 0x02;			// Rising edge of XIRQ0
	IRQEN = 0x30000; 		// Enable SPI + XIRQ0 interrupt
	ucStoreCount = 0;

	while(1)
	{
	}
}

void IRQ_Handler(void) __irq
{
 unsigned long IRQSTATUS = 0;
 unsigned int SPIMSTATUS = 0; 

	IRQSTATUS = IRQSTA;	                		// Read off IRQSTA register

	if ((IRQSTATUS & BIT16) == BIT16)	//If SPI Slave interrupt source
	{
	   SPIMSTATUS = SPISTA;
 
	   if ((SPIMSTATUS & BIT6) == BIT6) // If SPI Slave Rx IRQ
	   {
			if (ucStoreCount < 6)		   // Have max 6 bytes been received?
			{
				if ( ucReadOnly == 0)
				{
					szStoreData[ucStoreCount++] = SPIRX;  // Read Rx buffer
					if (ucStoreCount >=6)
					{
						ucStoreCount = 0;
						ucReadOnly = 1;
						SPICON |= BIT13; // Flush Tx FIFO
						SPICON &= ~BIT13; 
					}
				}
				if (ucReadOnly == 1)
				{
					SPITX = szStoreData[ucStoreCount++]; //ucbuffer;
					ucTxCnt++; 
				}
			}
	   }
	   if ((SPIMSTATUS & BIT7) == BIT7) // If SPI Slave Rx FIFO Overflow status IRQ
	   {
		   ucTxCnt++; 
	   }
	}
	if ((IRQSTATUS & BIT17) == BIT17)	//XIRQ0 interrupt source
	{
		ucWaitingForXIRQ0 = 0;			// Enable Write from Slave.
	}
}
