/************************************************************************************************

 Author        : ADI - Apps            www.analog.com/

 Date          : June 2010

 File          : TimerTest.c

 Hardware      : ADuC7124

 Description   : This Simple example shows how to initialize the internal Timers on the Part
 				 and how to use the wake-up timer to awaken the part from Sleep Mode.		
*************************************************************************************************/
// Bit Definitions 
#define BIT2  0x04
#define BIT3  0x08
#define BIT4  0x10
#define BIT5  0x20

#include<aduc7124.h>

unsigned long timer0Value = 0;
unsigned long timer1Value = 0;
unsigned long timer2Value = 0;
unsigned long timer3Value = 0;
void Timer0Init(void);
void Timer1Init(void);
void Timer2Init(void);
void Timer3Init(void);

int main(void)
{
	POWKEY1 = 0x01;
	POWCON0 = 0x00;								// Set core at maximum speed
	POWKEY2 = 0xF4;
  
    GP1CON = 0x0;					            //Set P1.7-P1.5 as output pin
	GP1DAT |= 0xE0E00000;						//Set P1.7-P1.5 as an output

	IRQEN |= 0x3C;
	  
	Timer0Init();						//call timer0
	Timer1Init();						//call timer1
	Timer2Init();						//call timer2
	Timer3Init();						//call timer3

	while (1)
	{
	}    
}

void Timer0Init(void)
{
	T0LD = 0xFFFF;
	T0CON = 0x80;
	timer0Value = T0VAL;
}

void Timer1Init(void)
{
	T1LD = 0xFFFF;
	T1LD = 0x2000;
	T1CON = 0x2C0;						// Periodic mode, Uclk source
}

void Timer2Init(void)
{
	T2LD = 0xFFFF;
	T2CON = 0x680;
	timer2Value = T2VAL;
}

void Timer3Init(void)
{
	T3LD = 0xFFFF;
	T3CON = 0x80;				   //irq mode
	timer3Value = T3VAL;
}

void IRQ_Handler(void) __irq
{
 unsigned long IRQSTATUS = 0; 

	IRQSTATUS = IRQSTA;	                		// Read off IRQSTA register
    
	if ((IRQSTATUS & BIT2) == BIT2)				//Timer0
	{		
		GP1DAT ^=0x800000;
		T0CLRI = 0xFF;
	}

	if ((IRQSTATUS & BIT3) == BIT3)				//timer1
	{	 
		GP1DAT ^=0x400000;
		T1CLRI = 0xFF;
	}

	if ((IRQSTATUS & BIT4) == BIT4)				//Timer2
	{	 
		T2CLRI = 0xFF;
	}

	if ((IRQSTATUS & BIT5) == BIT5)				//Timer3/Watchdog
	{
		GP1DAT ^=0x200000;
		T3CLRI = 0xFF;
	}
}
