/************************************************************************************************

 Author        : ADI - Apps            www.analog.com/

 Date          : June 2010

 File          : XIrqTest.c

 Hardware      : ADuC7124

 Description   : This Simple example shows how to initialize the part for Exteral inturrupts,
 				 and demonstrate how to use inturrupts on the ADuC7124		
*************************************************************************************************/
// Bit Definitions
#define BIT17 0x20000
#define BIT20 0x100000
#define BIT22 0x400000
#define BIT23 0x800000

#include<aduc7124.h>

void delay (int);                               // Delay function

int main(void)
{
	POWKEY1 = 0x01;
	POWCON0 = 0x00;								// Set core at maximum speed
	POWKEY2 = 0xF4; 
  
	IRQCONE = 0x28A;
	IRQEN |= 0xD20000;							//Enable External inturrupts

  while (1)
  {
  }    
}

void IRQ_Handler(void) __irq
{
  
 unsigned long IRQSTATUS = 0; 

  IRQSTATUS = IRQSTA;	                		// Read off IRQSTA register

	if ((IRQSTATUS & BIT17) == BIT17)				//XIRQ0
	{		 
		  IRQCLRE = BIT17;
	}

 
	if ((IRQSTATUS & BIT20) == BIT20)				//XIRQ1
	{	 
		  IRQCLRE = BIT20;
	}


	if ((IRQSTATUS & BIT22) == BIT22)				//XIRQ2
	{	 
		  IRQCLRE = BIT22;
	}


	if ((IRQSTATUS & BIT23) == BIT23)				//XIRQ3
	{
		  IRQCLRE = BIT23;
		  IRQCLR = BIT23;
	}
}

void delay (int length)
{
	while (length >0)
    	length--;
}
