/*********************************************************************

 Author        : ADI - Apps            

 Date          : Sept. 2006

 File          : Main.c

 Hardware      : Applicable to ADuC702x rev H or I silicon
                 Currently targetting ADuC7026.

 Description   : Network Addressable Uart writing to 2 slave devices
 				 
		
*********************************************************************/

#include "ADuC7026.h"

void delay(int);
void main()
{
  unsigned char tx_data = 0;
  /*----------------------------------------------------------------------------*/
  // Network settings
  /*----------------------------------------------------------------------------*/
  COMCON0  = 0x80;                    // settings of speed
  COMDIV0  = 0x88;// : 9600bps         //0x0C; : 115Kbps       //1; : max
  COMDIV1  = 0x00;
  COMCON0  = 0x03;                 

  //sb 28 / 7 / 2006
  GP1CON   = 0x00000011; // enable both uart Rx & Tx
  COMIEN1  = 0xE7;       //  Setting ENAM, E9BT, E9BR, ETD, NABP and NAB

  //-------------------------------------------------------------------
  // Two slaves. First with address 0x41, second with address 0x10
  // Write to Slave with address 0x41               
  //-------------------------------------------------------------------     
  COMTX = 0x41;  // Slave address 0x41
  while(!(0x020==(COMSTA0 & 0x020))){} // wait for adr tx to finish.

  COMIEN1  = 0xE6;       //  Setting ENAM, E9BT, E9BR, ETD, NABP
	
  COMTX = 0x55; // Tx data to slave: 
  while(!(0x020==(COMSTA0 & 0x020))){} // wait for adr tx to finish.

    // Write to Slave with address 0x0F
  COMIEN1  = 0xE7;       //  Setting ENAM, E9BT, E9BR, ETD, NABP
  COMTX = 0x0f;  // Slave address 
  while(!(0x020==(COMSTA0 & 0x020))){} // wait for adr tx to finish.
  COMIEN1  = 0xE6;       //  Setting ENAM, E9BT, E9BR, ETD, NABP
   COMTX = 0x6; // Tx data to slave: 
   while(!(0x020==(COMSTA0 & 0x020))){} // wait for data tx to finish.

  // Write to Slave with address 0x10
  COMIEN1  = 0xE7;       //  Setting ENAM, E9BT, E9BR, ETD, NABP
  COMTX = 0x10;  // Slave address tx: pattern 111011111110111
  while(!(0x020==(COMSTA0 & 0x020))){} // wait for adr tx to finish.
  COMIEN1  = 0xE6;       //  Setting ENAM, E9BT, E9BR, ETD, NABP
  COMTX = 0x99; // Tx data to slave: 
  while(!(0x020==(COMSTA0 & 0x020))){} // wait for adr tx to finish.

  while( 1 )
  {
  }
} 

