#define _ADuC7020
#include "ADuC70x.h"         
#include "type_synonyms.h"
//---------------------------------------------------------------------------
#define UART_SLAVE_ADDRESS 0x41
#define DATA_SIZE          0x100    // size of receiving data
//---------------------------------------------------------------------------
/*
#define SET_NETWORK_MODE         \
{                                \
  COMIEN0 = 0;                   \
  COMADR  = UART_SLAVE_ADDRESS;  \                  
  COMIEN1 =                      \
    COMIEN1_BIT_NETWORKING       \
   |COMIEN1_BIT_9BIT_IN          \
   |COMIEN1_BIT_NETINTR_ENABLE   \
  ;                              \
}*/ 

#define SET_NETWORK_MODE         \
{                                \
  COMIEN0 = 0;                   \
  COMADR  = UART_SLAVE_ADDRESS;  \                  
  COMIEN1 =                      \
    COMIEN1_BIT_NETWORKING       \
   |COMIEN1_BIT_NETINTR_ENABLE   \
  ;                              \
} 


volatile unsigned int uiNINTcount = 0;
volatile unsigned int uiNAMintCount = 0;
volatile unsigned int uiComIID1 = 0;
volatile unsigned char uiComRx;
volatile unsigned int uiIRQSTA = 0;
volatile unsigned int uiValidIRQ = 0;
volatile unsigned int uiTest = 0;
volatile unsigned int uiCntNAMaddressInt = 0;
volatile unsigned char uiComRx;
volatile unsigned char ComRx;
volatile unsigned char ComIntrId1; //= 0xF & COMIID1;      // identifier of interrupt
volatile unsigned char ComIntrId0; //= 0xF & COMIID1;      // identifier of interrupt
//---------------------------------------------------------------------------

int main()
{
 /* POWKEY1 = 0x01;                                  // settings of clock frequency 
  POWCON &= ~POWCON_CORE_CLOCK_MASK;
  POWKEY2 = 0xF4;
  POWKEY1 = 0x01;
  POWCON |=  POWCON_CORE_CLOCK_kHz_45088;
  POWKEY2 = 0xF4; 
*/
  
  COMADR = 0x41;
//  COMIEN1 |= 0x80;
  IRQEN |=  UART_BIT;                              // set interrupt from UART
  COMIEN0 |= 0x01;
  T1LD = 0x20000;						// Counter Value
  T1CON = 0xC4;						// Enabled,Periodic,Binary and CLK/16

//  IRQEN |= GP_TIMER_BIT;		//	 Timer1 IRQ

  COMCON0 |= COMCON0_DLAB_BIT;                     // settings UART speed
  COMDIV0  = 0x88;// : 9600bps   //0x0C : 115Kbps  // 1 : max
  COMDIV1  = 0x00;
  COMCON0 &= ~COMCON0_DLAB_BIT; 
  COMCON0  = COMCON0_8BIT_LEN | COMCON0_STOP_BIT;  // Configuration of UART
  
  GP1CON  = 0x11;//GP1CON_P10_SIN;                        // set UART input as GPIO P1.0

  SET_NETWORK_MODE;
//  COMIEN1 = 0xB2;
  while(1);                                        // main cycle
  {
  }

  return 0;
}
//---------------------------------------------------------------------------
                 
void IRQ_Handler() __irq                          // interrupt handler
{
 

  uiIRQSTA = IRQSTA;
  ComIntrId1 =  COMIID1;      // identifier of interrupt
  ComIntrId0 = COMIID0;
  if ((uiIRQSTA & GP_TIMER_BIT) != 0)	 		// Timer1 IRQ?
  {
		T1CLRI = 0;								// Clear Timer IRQ
		GP4DAT ^= 0x00040000;					// Complement P4.2
		return;
  }
  if( !(COMSTA0 & COMSTA0_BIT_RX_FULL) )
  {
    uiTest++;
	return;
  }

  if ((uiIRQSTA & 0x4000 )== 0x4000) 
  	uiValidIRQ++;
  uiComIID1	= ComIntrId1;
//  if(( ComIntrId1 & COMIID1_BIT_NO_INTERRUPT ) == 0x1)     // Was set NINT bit?
  if(( ComIntrId1 & 0x1 ) == 0x1)
  {
    ComRx = COMRX;    // Breakpoint must be set here
	uiNINTcount++;
  }
  else
  {
    ComRx = COMRX;    // Breakpoint must be set here
	uiNAMintCount++;
  }
  uiComRx =  ComRx;
}
/*
//---------------------------------------------------------------------------
#define ORIGINAL_DATA_SIZE 0x03
const uint8 OriginalData[ORIGINAL_DATA_SIZE] = { 1, 2, 3 };  // bench mark (for compare with receiving data)
//---------------------------------------------------------------------------
uint8 Data[DATA_SIZE];                    // Receiving data
uint8 Errors[] = {0,0,0,0,0,0,0,0,0,0};   // Array, which fix errors
uint8 FirstError = 0;                     // Code of first error
uint8 Index = 0;                          // Index receiving data
//---------------------------------------------------------------------------
#define ERROR_ADDRESS  1                  // Code of errors is index of array 'Errors'
#define ERROR_DATA     2
#define ERROR_OVERFLOW 3
//---------------------------------------------------------------------------
void IRQ_Handler() __irq                          // interrupt handler
{
 // volatile unsigned char uiComRx;
  volatile unsigned char ComIntrId1 = 0xF & COMIID1;      // identifier of interrupt

  uiIRQSTA = IRQSTA;
  uiComIID1 = ComIntrId1;
  
  if( !(COMSTA0 & COMSTA0_BIT_RX_FULL) )
  {
    uiTest++;
	return;
  }

  uiComRx = COMRX;                                // read the receiving byte 
  //  if (((ucTestComIID1 & 0x4) == 0x4) && ((ucTestComIID1 & 0x1) == 0x0))
  if (uiComIID1 > 0x1)
	uiValidIRQ++;
  else if ((uiComIID1 & 0x1) == 0x1)
	uiNINTcount++;
  if ((ComIntrId1 > 0x1) && ((ComIntrId1 & 0x1) == 0x0))
  //  if (ComIntrId1 > 0x1)
	uiNAMintCount++;
  else if ((ComIntrId1 & 0x1) == 0x1)
	uiNINTcount++;  

  if ((uiComIID1 & 0xc) == 0xc)
  	uiCntNAMaddressInt++;
  if( COMIEN1 & COMIEN1_BIT_NETWORKING )        // The receiving byte is address of this slave
  {
	Index = 0;                                    // set index for receiving data
    if( uiComRx != UART_SLAVE_ADDRESS )             // check for address 
    {
      Errors[ERROR_ADDRESS] = uiComRx;              // fix address error
      if( !FirstError )
        FirstError = ERROR_ADDRESS;               // fix first error
    }
    else
	{
//      SET_PEER2PEER_MODE;
	  GP4DAT ^= 0x00020000;
	}
    return;
  }

  if( Index >= ORIGINAL_DATA_SIZE )               // Received data is too much
  {
    Errors[ERROR_OVERFLOW] = uiComRx;               
    if( !FirstError )
      FirstError = ERROR_OVERFLOW;                
  }
  //else if( ComRx != OriginalData[Index] )         // Received data is not equal to sent data 
  else if( uiComRx != 0x01 )         // Received data is not equal to sent data 
  {
    Errors[ERROR_DATA] = uiComRx;
    if( !FirstError )
      FirstError = ERROR_DATA;
  }
  
  if( Index == ORIGINAL_DATA_SIZE-1 )              
    SET_NETWORK_MODE;

  Data[Index++] = uiComRx;                          // Store received data
  
} */
//---------------------------------------------------------------------------
