/*********************************************************************

 Author        : ADI - Apps            

 Date          : Sept. 2006

 File          : Main.c

 Hardware      : Applicable to ADuC702x rev H or I silicon
                 Currently targetting ADuC7026.

 Description   : Network Addressable Uart writing to 2 slave devices
 				 
		
*********************************************************************/

#define _ADuC7020
#include "ADuC7020.h"         

volatile unsigned int uiComIID1 = 0;
volatile unsigned int uiIRQSTA = 0;
volatile unsigned int uiCOMSTA0 = 0;
volatile unsigned char ucComRx[16];
volatile unsigned char ComIntrId1; //= 0xF & COMIID1;      // identifier of interrupt
volatile unsigned char ucCnt = 0;
volatile unsigned char ucCntInterrupts = 0;

//---------------------------------------------------------------------------

int main()
{
  GP4DAT = 0x04000000;              // P4.2(GPO)
  GP4SET = 0x00040000;				// Turn LED off 
  ucCnt = 0;
  COMADR   = 0x41;	   // Setup the Uart Network address
  IRQEN   |= UART_BIT; // set interrupt from UART
  COMCON0  = 0x80;     // settings UART speed
  COMDIV0  = 0x88;     // : 9600bps   //0x0C : 115Kbps  // 1 : max
  COMDIV1  = 0x00;
  COMCON0  = 0x03;     // 8 bit data transfer 
  GP1CON   = 0x11;     // enable UART rx and tx
  COMIEN0 = 0x01;
  COMIEN1 = 0xF2;     //  Setting ENAM, E9BT, E9BR, ENI and NABP 
  while(1);                                        // main cycle
  {
  }

  return 0;
}
//---------------------------------------------------------------------------
                 
void IRQ_Handler() __irq             // interrupt handler
{
  uiIRQSTA   = IRQSTA;               // save irq source
    	 
  if ((uiIRQSTA & UART_BIT) == 0x4000) 		// Uart IRQ?   -  check for UART
  { 
  	uiCOMSTA0	 = COMSTA0;				// read Status register
  	if ((uiCOMSTA0 & 0x20) == 0x20)		// Check for Tx Buffer empty
	{
	   COMIEN1 = 0xF2;					 // Disable transmissions
	}
    ComIntrId1 = COMIID1;      			 // identifier of interrupt
    if (( ComIntrId1 & 0x0C) == 0x0C)	 // My address detect ??
		GP4CLR = 0x00040000;			 // Turn LED On
	else
		GP4SET = 0x00040000;			 // Turn LED Off	
    ucComRx[ucCnt++] = COMRX;    
	if ( ucCnt == 0x2)
	{
		COMIEN1 |= 0x4;
		COMTX = 0x55;
	}
	if ( ucCnt >=16)
		ucCnt = 0;	 
  }
}
//---------------------------------------------------------------------------
