/*********************************************************************

 Author        : ADI - Apps            www.analog.com/MicroConverter

 Date          : May. 2007

 File          : UART2.c

 Hardware      : Applicable to ADuC702x rev H or I silicon
                 Currently targetting ADuC7028.

 Description   : Read part of memory and output through UART (SPM0&1).
				 The baudrate is calculated with the following formula:
 
					DL = HCLK										   
						_______										   
						Baudrate * 2 *16							   

				 A 9600 8-N-1 Hyperterminal window is required to observe
				 the results.
		
*********************************************************************/
#include <ADuC7028.h>

             
void senddata(short);
void delay(int);
char hex2ascii(char);

int main (void)  {

static unsigned short SOMEDATA[1024];
int i;

	POWKEY1 = 0x01;
	POWCON = 0x00;		   			// 41.78MHz
	POWKEY2 = 0xF4;

   	GP0CON = 0x10000000; 		// enable ECLK output on P0.5

 	// configures GPIO to flash LED P4.2
	GP4DAT = 0x04000000;		// P4.2 configured as an output. LED is turned on	

	// Setup tx & rx pins on SPM 0 and SPM 1
	GP1CON = 0x011;

     // Start setting up UART at 9600bps
   	COMCON0 = 0x080;			// Setting DLAB
   	COMDIV0 = 0x088;			// Setting DIV0 and DIV1 to DL calculated
   	COMDIV1 = 0x000;
   	COMCON0 = 0x007;			// Clearing DLAB

	for (i=0; i <1024; i++)
	{
		SOMEDATA[i]=i;
	}	
	
	while(1)
	{
	for (i=0; i <1024; i++)
	{
		senddata (SOMEDATA[i]);
	}
	GP4DAT ^= 0x00040000;		// Complement P4.2
	delay(2000);
	}
}


void delay (int length)
{
	while (length >=0)
    	length--;
}

void senddata(short to_send)
{
	while(!(0x020==(COMSTA0 & 0x020))){}
		COMTX = 0x0A;						// output LF 
	while(!(0x020==(COMSTA0 & 0x020))){}
		COMTX = 0x0D;						// output CR 
	while(!(0x020==(COMSTA0 & 0x020))){}
		COMTX = hex2ascii ((to_send >> 8) & 0x0F);
	while(!(0x020==(COMSTA0 & 0x020))){}
		COMTX = hex2ascii ((to_send >> 4) & 0x0F);						
	while(!(0x020==(COMSTA0 & 0x020))){}
		COMTX = hex2ascii (to_send & 0x0F);							
}


char hex2ascii(char toconv)
{
	if (toconv<0x0A) 
	{
		toconv += 0x30;
	}
	else 
	{
		toconv += 0x37;
	}
	
	return (toconv);
}

