/*********************************************************************

 Author        : ADI - Apps            www.analog.com/MicroConverter

 Date          : May. 2007

 File          : UART3.c

 Hardware      : Applicable to ADuC702x rev H or I silicon
                 Currently targetting ADuC7028.

 Description   : This code demonstrates basic UART functionality.
				 The baudrate is calculated with the following formula:
 
					DL = HCLK										   
						_______										   
						Baudrate * 2 *16							   
                                          																   
***********************************************************************/

#include <ADuC7028.h>
#include"stdio.h" 	

void delay(int);

int main (void)  {

	POWKEY1 = 0x01;
	POWCON = 0x00;		   			// 41.78MHz
	POWKEY2 = 0xF4;

	// Setup tx & rx pins on P1.0 and P1.1
	GP1CON = 0x011;
   	// Start setting up UART at 9600bps
   	COMCON0 = 0x080;				// Setting DLAB
   	COMDIV0 = 0x088;				// Setting DIV0 and DIV1 to DL calculated
   	COMDIV1 = 0x000;
   	COMCON0 = 0x007;				// Clearing DLAB

	GP4DAT = 0x04000000;			// P4.2 configured as an output. LED is turned on
  	printf ("Hello World\n");       // printf function call   

while (1)
	{
	GP4DAT ^= 0x00040000;		// Complement P4.2
	delay(200000);
	}				
}

void delay (int length)
{
	while (length >=0)
    	length--;
}
