/*********************************************************************

 Author        : ADI - Apps            www.analog.com/MicroConverter

 Date          : May. 2007

 File          : UART4.c

 Hardware      : Applicable to ADuC702x rev H or I silicon
                 Currently targetting ADuC7028.

 Description   : This code demonstrates the use of the fractional divider.
				 The baudrate generated is 115200bps, with a CD of 3.
				 
				 Without using a fractional divider, the baudrate generated
				 would be 88062bps or an error of 24%
 
				 with the fractional divider, we can acheive an error of
				 3.54 E-3%										   
													                                     																   
***********************************************************************/

#include <ADuC7028.h>
 	
extern int write (int file, char * ptr, int len);	// Functions used to 
extern int getchar (void);							// to output data 	 
extern int putchar(int);                     		// Write character to Serial Port  

int main (void)  {
  unsigned char jchar = 0x30;

	char output1[13] = "Hello World\n";

	POWKEY1 = 0x01;
	POWCON = 0x00;		   			// 41.78MHz
	POWKEY2 = 0xF4;

	// Setup tx & rx pins on P1.0 and P1.1
	GP1CON = 0x011;
 
	 // CD = 3 !		 
	COMCON0 = 0x80;					// Setting DLAB
   	COMDIV0 = 0x01;					// Setting DIV0 and DIV1 to DL calculated
	COMDIV1 = 0x00;
   	COMCON0 = 0x07;					// Clearing DLAB
	COMDIV2 = 0x8B55;				// fractional divider

	GP4DAT = 0x04000000;			// P4.2 configured as an output. LED is turned on

	while(1)
	{

		GP4DAT ^= 0x00040000;		// Complement P4.2
		write(0,output1,13);		// Output Data
		jchar = getchar();			// RX Data, Single Byte
		write(0,&jchar,1);			// Output Rxed Data
	}
}
