/******************************************************************************
* File Name: main.c
*
* Version: 1.10
*
* Description: This is the source code for the Blinking LED code example.
*
* Related Document: CE195352_PSoC_5LP_Blinking_LED.pdf
*
* Hardware Dependency: See CE195352_PSoC_5LP_Blinking_LED.pdf
*
*******************************************************************************
* Copyright (2018), Cypress Semiconductor Corporation. All rights reserved.
*******************************************************************************
* This software, including source code, documentation and related materials
* (“Software”), is owned by Cypress Semiconductor Corporation or one of its
* subsidiaries (“Cypress”) and is protected by and subject to worldwide patent
* protection (United States and foreign), United States copyright laws and
* international treaty provisions. Therefore, you may use this Software only
* as provided in the license agreement accompanying the software package from
* which you obtained this Software (“EULA”).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the Software source
* code solely for use in connection with Cypress’s integrated circuit products.
* Any reproduction, modification, translation, compilation, or representation
* of this Software except as specified above is prohibited without the express
* written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO WARRANTY OF ANY KIND, 
* EXPRESS OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED 
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. Cypress 
* reserves the right to make changes to the Software without notice. Cypress 
* does not assume any liability arising out of the application or use of the 
* Software or any product or circuit described in the Software. Cypress does 
* not authorize its products for use in any products where a malfunction or 
* failure of the Cypress product may reasonably be expected to result in 
* significant property damage, injury or death (“High Risk Product”). By 
* including Cypress’s product in a High Risk Product, the manufacturer of such 
* system or application assumes all risk of such use and in doing so agrees to 
* indemnify Cypress against all liability.
*******************************************************************************/

#include <project.h>
#include <FS.h>

/*******************************************************************************
* Function Name: main
********************************************************************************
*
* Summary:
*  The PWM is configured and started in the PWM_1_Start() function.
*  The firmware then enters an idle loop, leaving control of the project
*  to the fixed function PWM peripheral.
*
* Parameters:
*  None.
*
* Return:
*  None.
*
*******************************************************************************/
int main()
{
    char sdVolName[10];     /* Buffer that will hold SD card Volume name */
 char sdFile[9] = "File.txt";

//    U16 step = 1u;
    FS_FILE * pFile;
    
    /* Start LCD */
 //   LCD_Start();
    
    /* Initialize file system */
    FS_Init();
    
    /* Display step number */
//    NextStep(step++, "SD CARD NAME");
    
 //   LCD_Position(0u, 0u);
    
    /* Get volume name of SD card #0 */
    if(0 != FS_GetVolumeName(0u, &sdVolName[0], 9u))
    {
        /* Getting volume name succeeded so prompt it on the LCD */
       // Led=PWM_Out_1;
        
    }
    else
    {
        /* Operation Failed - indicate this */
   //    Led=PWM_Out_1;
    //    CyDelay(2000u);
     //   Led=0;
    }
    
    /* Need some delay to indicate output on the LCD */
    CyDelay(2000u);
    
    //NextStep(step++, "SD CARD FORMAT");
        
   // LCD_Position(0u, 0u);
   // LCD_PrintString("SD card format");
    
    if(0 == FS_FormatSD(sdVolName))
    {
     //   LCD_Position(1u, 0u);
      //  LCD_PrintString("Succeeded");
    }
    else
    {
//Led=0;

        //LCD_Position(1u, 0u);
        //LCD_PrintString("Failed");
    }
    
    /* Need some delay to indicate output on the LCD */
    CyDelay(2000u);
    
//    NextStep(step++, "DIRECTORY");
    
 //   LCD_Position(0u, 0u);
    
    /* This will create directory "Dir" on SD card */
    if(0 == FS_MkDir("Dir"))
    {
        /* Display successful directory creation message */
 //       LCD_PrintString("\"Dir\" created");
    }
    else
    {
        /* Display failure message */
   //     LCD_PrintString("Failed to create");
    //    LCD_Position(1u, 0u);
     //   LCD_PrintString("directory");
  // Led=0;

        }
    
    /* Need some delay to indicate output on the LCD */
    CyDelay(2000u);
    
    //NextStep(step++, "FILE");
    
    /* Create specific file for modification */
    pFile = FS_FOpen(sdFile, "w");
    
//    LCD_Position(0u, 0u);
    
    /* Check if file was created */
    if(pFile)
    {
        /* Indicate successful file creation message */
      /*  LCD_PrintString("File ");
        LCD_PrintString(sdFile);
        LCD_Position(1u, 0u);
        LCD_PrintString("was opened");
        */
        /* Need some delay to indicate output on the LCD */
        CyDelay(2000u);
        
       // LCD_ClearDisplay();
        
       // LCD_Position(0u, 0u);
        
        if(0 != FS_Write(pFile, "0123456789", 10u)) 
        {
            /* Inditate that data was written to a file */
         /*   LCD_PrintString("\"0123456789\"");
            LCD_PrintString(sdFile);
            LCD_Position(1u, 0u);
            LCD_PrintString("written to file");
       */ }
        else
        {
         /*   LCD_PrintString("Failed to write");
            LCD_Position(1u, 0u);
            LCD_PrintString("data to file");
       */ }
        
        /* Need some delay to indicate output on the LCD */
        CyDelay(2000u);
        
       // LCD_ClearDisplay();
        
      //  LCD_Position(0u, 0u);
        
        if(0 == FS_FClose(pFile))
        {
        //    LCD_PrintString("File was closed");
        }
        else
        {
         //   LCD_PrintString("Failed to close");
         //   LCD_Position(1u, 0u);
        //    LCD_PrintString("file");
        }
    }
    else
    {
       // LCD_PrintString("Failed to create");
      //  LCD_Position(1u, 0u);
      //  LCD_PrintString("file");
    }
    
    /* Need some delay to indicate output on the LCD */
    CyDelay(2000u);
        
//    LCD_ClearDisplay();
    
 //   NextStep(step++, "COPY");
    
  //  LCD_Position(0u, 0u);
    
    /* Copy a file to a previously created directory */
    if(0 == FS_CopyFile(sdFile, "\\Dir\\file1.txt"))
    {
   //     LCD_PrintString("File was ");
    //    LCD_Position(1u, 0u);
     //   LCD_PrintString("copied to \"DIR\"");
    }
    else
    {
     //   LCD_PrintString("Failed to copy");
      //  LCD_Position(1u, 0u);
       // LCD_PrintString("file");
    }
    
    /* Need some delay to indicate output on the LCD */
    CyDelay(2000);
    
   // LCD_ClearDisplay();
    
  //  LCD_Position(0u, 0u);
  //  LCD_PrintString("Example project");
  //  LCD_Position(1u, 0u);
  //  LCD_PrintString("completed");
    
    for(;;)
    {

    }
}


/* [] END OF FILE */
