/*
 ## Cypress USB 3.0 Platform header file (cyfxuac.h)
 ## ===========================
 ##
 ##  Copyright Cypress Semiconductor Corporation, 2012-2013,
 ##  All Rights Reserved
 ##  UNPUBLISHED, LICENSED SOFTWARE.
 ##
 ##  CONFIDENTIAL AND PROPRIETARY INFORMATION
 ##  WHICH IS THE PROPERTY OF CYPRESS.
 ##
 ##  Use of this file is governed
 ##  by the license agreement included in the file
 ##
 ##     <install>/license/license.txt
 ##
 ##  where <install> is the Cypress software
 ##  installation root directory path.
 ##
 ## ===========================
*/

#ifndef _INCLUDED_CYFXUAC_H_
#define _INCLUDED_CYFXUAC_H_

#include <cyu3externcstart.h>
#include <cyu3types.h>
#include <cyu3usbconst.h>

/* This header file comprises of the UAC application constants */

#define CY_FX_UAC_APP_THREAD_STACK     (0x1000)        /* Thread stack size */
#define CY_FX_UAC_APP_THREAD_PRIORITY  (8)             /* Thread priority */

/* Endpoint definition for UAC application */
#define CY_FX_EP_ISO_AUDIO             (0x81)          /* EP 1 IN */
#define CY_FX_EP_AUDIO_CONS_SOCKET     (CY_U3P_UIB_SOCKET_CONS_1) /* Consumer socket 1 */

/* UAC streaming endpoint packet Count */
#define CY_FX_EP_ISO_AUDIO_PKTS_COUNT  (0x01)

/* UAC Buffer count */
#define CY_FX_UAC_STREAM_BUF_COUNT     (16)

#define CY_FX_UAC_STREAM_INTERFACE     (uint8_t)(1)   /* Streaming Interface : Alternate setting 1 */

#define CY_FX_AUDIO_CONTROL_IF_NUMBER (0x00)

#define CY_FX_AUDIO_STREAM_IF_NUMBER (0x01)

#define CY_FX_USB_AUDIO_SET_CUR		0x01
#define CY_FX_USB_AUDIO_GET_CUR		0x81
#define CY_FX_USB_AUDIO_SET_MIN		0x02
#define CY_FX_USB_AUDIO_GET_MIN		0x82
#define CY_FX_USB_AUDIO_SET_MAX		0x03
#define CY_FX_USB_AUDIO_GET_MAX		0x83
#define CY_FX_USB_AUDIO_SET_RES		0x04
#define CY_FX_USB_AUDIO_GET_RES		0x84


#define CY_FX_AUDIO_FU_MUTE_CONTROL                 0x01
#define CY_FX_AUDIO_FU_VOLUME_CONTROL               0x02
#define CY_FX_AUDIO_FU_BASE_CONTROL                 0x03
#define CY_FX_AUDIO_FU_MID_CONTROL                  0x04
#define CY_FX_AUDIO_FU_TREBLE_CONTROL               0x05
#define CY_FX_AUDIO_FU_GRAPHIC_EQUALIZER_CONTROL    0x06
#define CY_FX_AUDIO_FU_AUTOMATIC_GAIN_CONTROL       0x07
#define CY_FX_AUDIO_FU_DELAY_CONTROL                0x08
#define CY_FX_AUDIO_FU_BASS_BOOST_CONTROL           0x09
#define CY_FX_AUDIO_FU_LOUDNESS_CONTROL             0x0A





#define AUDIO_SAMPLE_RATE_MIN	41100
#define AUDIO_SAMPLE_RATE_MAX	48000

#define AUDIO_VOLUME_RES		256
#define AUDIO_VOLUME_MIN		0
#define AUDIO_VOLUME_MID		(10*AUDIO_VOLUME_RES)
#define AUDIO_VOLUME_MAX		(20*AUDIO_VOLUME_RES)

#define AUDIO_BUFFER_SIZE		1024
#define AUDIO_BUFFER_MASK		(AUDIO_BUFFER_SIZE - 1)

#define AUDIO_RATE_FILTER_GAIN	8
#define AUDIO_RATE_FILTER_SHIFT	4

/* Extern definitions of the USB Enumeration constant arrays used for the Application */
extern const uint8_t CyFxUsb20DeviceDscr[];
extern const uint8_t CyFxUsb30DeviceDscr[];
extern const uint8_t CyFxUsbDeviceQualDscr[];
extern const uint8_t CyFxUsbFSConfigDscr[];
extern const uint8_t CyFxUsbHSConfigDscr[];
extern const uint8_t CyFxUsbBOSDscr[];
extern const uint8_t CyFxUsbSSConfigDscr[];
extern const uint8_t CyFxUsbStringLangIDDscr[];
extern const uint8_t CyFxUsbManufactureDscr[];
extern const uint8_t CyFxUsbProductDscr[];

#include <cyu3externcend.h>

#endif /* _INCLUDED_CYFXUAC_H_ */

/*[]*/

