/*******************************************************************************
* File Name: SwitchCheckInterrupt.h
* Version 1.70
*
*  Description:
*   Provides the function definitions for the Interrupt Controller.
*
*
********************************************************************************
* Copyright 2008-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/
#if !defined(CY_ISR_SwitchCheckInterrupt_H)
#define CY_ISR_SwitchCheckInterrupt_H


#include <cytypes.h>
#include <cyfitter.h>

/* Interrupt Controller API. */
void SwitchCheckInterrupt_Start(void);
void SwitchCheckInterrupt_StartEx(cyisraddress address);
void SwitchCheckInterrupt_Stop(void);

CY_ISR_PROTO(SwitchCheckInterrupt_Interrupt);

void SwitchCheckInterrupt_SetVector(cyisraddress address);
cyisraddress SwitchCheckInterrupt_GetVector(void);

void SwitchCheckInterrupt_SetPriority(uint8 priority);
uint8 SwitchCheckInterrupt_GetPriority(void);

void SwitchCheckInterrupt_Enable(void);
uint8 SwitchCheckInterrupt_GetState(void);
void SwitchCheckInterrupt_Disable(void);

void SwitchCheckInterrupt_SetPending(void);
void SwitchCheckInterrupt_ClearPending(void);


/* Interrupt Controller Constants */

/* Address of the INTC.VECT[x] register that contains the Address of the SwitchCheckInterrupt ISR. */
#define SwitchCheckInterrupt_INTC_VECTOR            ((reg32 *) SwitchCheckInterrupt__INTC_VECT)

/* Address of the SwitchCheckInterrupt ISR priority. */
#define SwitchCheckInterrupt_INTC_PRIOR             ((reg32 *) SwitchCheckInterrupt__INTC_PRIOR_REG)

/* Priority of the SwitchCheckInterrupt interrupt. */
#define SwitchCheckInterrupt_INTC_PRIOR_NUMBER      SwitchCheckInterrupt__INTC_PRIOR_NUM

/* Address of the INTC.SET_EN[x] byte to bit enable SwitchCheckInterrupt interrupt. */
#define SwitchCheckInterrupt_INTC_SET_EN            ((reg32 *) SwitchCheckInterrupt__INTC_SET_EN_REG)

/* Address of the INTC.CLR_EN[x] register to bit clear the SwitchCheckInterrupt interrupt. */
#define SwitchCheckInterrupt_INTC_CLR_EN            ((reg32 *) SwitchCheckInterrupt__INTC_CLR_EN_REG)

/* Address of the INTC.SET_PD[x] register to set the SwitchCheckInterrupt interrupt state to pending. */
#define SwitchCheckInterrupt_INTC_SET_PD            ((reg32 *) SwitchCheckInterrupt__INTC_SET_PD_REG)

/* Address of the INTC.CLR_PD[x] register to clear the SwitchCheckInterrupt interrupt. */
#define SwitchCheckInterrupt_INTC_CLR_PD            ((reg32 *) SwitchCheckInterrupt__INTC_CLR_PD_REG)



#endif /* CY_ISR_SwitchCheckInterrupt_H */


/* [] END OF FILE */
