/*******************************************************************************
* File Name: ResetTimerCLK.h
* Version 2.20
*
*  Description:
*   Provides the function and constant definitions for the clock component.
*
*  Note:
*
********************************************************************************
* Copyright 2008-2012, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_CLOCK_ResetTimerCLK_H)
#define CY_CLOCK_ResetTimerCLK_H

#include <cytypes.h>
#include <cyfitter.h>


/***************************************
*        Function Prototypes
***************************************/
#if defined CYREG_PERI_DIV_CMD

void ResetTimerCLK_StartEx(uint32 alignClkDiv);
#define ResetTimerCLK_Start() \
    ResetTimerCLK_StartEx(ResetTimerCLK__PA_DIV_ID)

#else

void ResetTimerCLK_Start(void);

#endif/* CYREG_PERI_DIV_CMD */

void ResetTimerCLK_Stop(void);

void ResetTimerCLK_SetFractionalDividerRegister(uint16 clkDivider, uint8 clkFractional);

uint16 ResetTimerCLK_GetDividerRegister(void);
uint8  ResetTimerCLK_GetFractionalDividerRegister(void);

#define ResetTimerCLK_Enable()                         ResetTimerCLK_Start()
#define ResetTimerCLK_Disable()                        ResetTimerCLK_Stop()
#define ResetTimerCLK_SetDividerRegister(clkDivider, reset)  \
    ResetTimerCLK_SetFractionalDividerRegister((clkDivider), 0u)
#define ResetTimerCLK_SetDivider(clkDivider)           ResetTimerCLK_SetDividerRegister((clkDivider), 1u)
#define ResetTimerCLK_SetDividerValue(clkDivider)      ResetTimerCLK_SetDividerRegister((clkDivider) - 1u, 1u)


/***************************************
*             Registers
***************************************/
#if defined CYREG_PERI_DIV_CMD

#define ResetTimerCLK_DIV_ID     ResetTimerCLK__DIV_ID

#define ResetTimerCLK_CMD_REG    (*(reg32 *)CYREG_PERI_DIV_CMD)
#define ResetTimerCLK_CTRL_REG   (*(reg32 *)ResetTimerCLK__CTRL_REGISTER)
#define ResetTimerCLK_DIV_REG    (*(reg32 *)ResetTimerCLK__DIV_REGISTER)

#define ResetTimerCLK_CMD_DIV_SHIFT          (0u)
#define ResetTimerCLK_CMD_PA_DIV_SHIFT       (8u)
#define ResetTimerCLK_CMD_DISABLE_SHIFT      (30u)
#define ResetTimerCLK_CMD_ENABLE_SHIFT       (31u)

#define ResetTimerCLK_CMD_DISABLE_MASK       ((uint32)((uint32)1u << ResetTimerCLK_CMD_DISABLE_SHIFT))
#define ResetTimerCLK_CMD_ENABLE_MASK        ((uint32)((uint32)1u << ResetTimerCLK_CMD_ENABLE_SHIFT))

#define ResetTimerCLK_DIV_FRAC_MASK  (0x000000F8u)
#define ResetTimerCLK_DIV_FRAC_SHIFT (3u)
#define ResetTimerCLK_DIV_INT_MASK   (0xFFFFFF00u)
#define ResetTimerCLK_DIV_INT_SHIFT  (8u)

#else 

#define ResetTimerCLK_DIV_REG        (*(reg32 *)ResetTimerCLK__REGISTER)
#define ResetTimerCLK_ENABLE_REG     ResetTimerCLK_DIV_REG
#define ResetTimerCLK_DIV_FRAC_MASK  ResetTimerCLK__FRAC_MASK
#define ResetTimerCLK_DIV_FRAC_SHIFT (16u)
#define ResetTimerCLK_DIV_INT_MASK   ResetTimerCLK__DIVIDER_MASK
#define ResetTimerCLK_DIV_INT_SHIFT  (0u)

#endif/* CYREG_PERI_DIV_CMD */

#endif /* !defined(CY_CLOCK_ResetTimerCLK_H) */

/* [] END OF FILE */
