/***************************************************************************//**
* \file .h
* \version 3.20
*
* \brief
*  This private file provides constants and parameter values for the
*  SCB Component in _EZI2C mode.
*  Do not use this file or its content in your project.
*
* Note:
*
********************************************************************************
* \copyright
* Copyright 2013-2016, Cypress Semiconductor Corporation. All rights reserved.
* You may use this file only in accordance with the license, terms, conditions,
* disclaimers, and limitations in the end user license agreement accompanying
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_SCB_EZI2C_PVT_SPIM_H)
#define CY_SCB_EZI2C_PVT_SPIM_H

#include "SPIM_EZI2C.h"


/***************************************
*      EZI2C Private Vars
***************************************/

extern volatile uint8 SPIM_curStatus;
extern uint8 SPIM_fsmState;

/* Variables intended to be used with Buffer 1: Primary slave address */
extern volatile uint8 * SPIM_dataBuffer1;
extern uint16 SPIM_bufSizeBuf1;
extern uint16 SPIM_protectBuf1;
extern uint16 SPIM_offsetBuf1;
extern uint16 SPIM_indexBuf1;

#if(SPIM_SECONDARY_ADDRESS_ENABLE_CONST)
    extern uint8 SPIM_addrBuf1;
    extern uint8 SPIM_addrBuf2;

    /* Variables intended to be used with Buffer 2: Primary slave address */
    extern volatile uint8 * SPIM_dataBuffer2;
    extern uint16 SPIM_bufSizeBuf2;
    extern uint16 SPIM_protectBuf2;
    extern uint16 SPIM_offsetBuf2;
    extern uint16 SPIM_indexBuf2;
#endif /* (SPIM_SECONDARY_ADDRESS_ENABLE_CONST) */


/***************************************
*     Private Function Prototypes
***************************************/

#if(SPIM_SCB_MODE_EZI2C_CONST_CFG)
    void SPIM_EzI2CInit(void);
#endif /* (SPIM_SCB_MODE_EZI2C_CONST_CFG) */

void SPIM_EzI2CStop(void);
#if(SPIM_EZI2C_WAKE_ENABLE_CONST)
    void SPIM_EzI2CSaveConfig(void);
    void SPIM_EzI2CRestoreConfig(void);
#endif /* (SPIM_EZI2C_WAKE_ENABLE_CONST) */

#endif /* (CY_SCB__EZI2C_PVT_SPIM_H) */


/* [] END OF FILE */
