/***************************************************************************//**
* \file .h
* \version 3.20
*
* \brief
*  This private file provides constants and parameter values for the
*  SCB Component in I2C mode.
*  Please do not use this file or its content in your project.
*
* Note:
*
********************************************************************************
* \copyright
* Copyright 2013-2016, Cypress Semiconductor Corporation. All rights reserved.
* You may use this file only in accordance with the license, terms, conditions,
* disclaimers, and limitations in the end user license agreement accompanying
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_SCB_I2C_PVT_SPIM_H)
#define CY_SCB_I2C_PVT_SPIM_H

#include "SPIM_I2C.h"


/***************************************
*     Private Global Vars
***************************************/

extern volatile uint8 SPIM_state; /* Current state of I2C FSM */

#if(SPIM_I2C_SLAVE_CONST)
    extern volatile uint8 SPIM_slStatus;          /* Slave Status */

    /* Receive buffer variables */
    extern volatile uint8 * SPIM_slWrBufPtr;      /* Pointer to Receive buffer  */
    extern volatile uint32  SPIM_slWrBufSize;     /* Slave Receive buffer size  */
    extern volatile uint32  SPIM_slWrBufIndex;    /* Slave Receive buffer Index */

    /* Transmit buffer variables */
    extern volatile uint8 * SPIM_slRdBufPtr;      /* Pointer to Transmit buffer  */
    extern volatile uint32  SPIM_slRdBufSize;     /* Slave Transmit buffer size  */
    extern volatile uint32  SPIM_slRdBufIndex;    /* Slave Transmit buffer Index */
    extern volatile uint32  SPIM_slRdBufIndexTmp; /* Slave Transmit buffer Index Tmp */
    extern volatile uint8   SPIM_slOverFlowCount; /* Slave Transmit Overflow counter */
#endif /* (SPIM_I2C_SLAVE_CONST) */

#if(SPIM_I2C_MASTER_CONST)
    extern volatile uint16 SPIM_mstrStatus;      /* Master Status byte  */
    extern volatile uint8  SPIM_mstrControl;     /* Master Control byte */

    /* Receive buffer variables */
    extern volatile uint8 * SPIM_mstrRdBufPtr;   /* Pointer to Master Read buffer */
    extern volatile uint32  SPIM_mstrRdBufSize;  /* Master Read buffer size       */
    extern volatile uint32  SPIM_mstrRdBufIndex; /* Master Read buffer Index      */

    /* Transmit buffer variables */
    extern volatile uint8 * SPIM_mstrWrBufPtr;   /* Pointer to Master Write buffer */
    extern volatile uint32  SPIM_mstrWrBufSize;  /* Master Write buffer size       */
    extern volatile uint32  SPIM_mstrWrBufIndex; /* Master Write buffer Index      */
    extern volatile uint32  SPIM_mstrWrBufIndexTmp; /* Master Write buffer Index Tmp */
#endif /* (SPIM_I2C_MASTER_CONST) */

#if (SPIM_I2C_CUSTOM_ADDRESS_HANDLER_CONST)
    extern uint32 (*SPIM_customAddressHandler) (void);
#endif /* (SPIM_I2C_CUSTOM_ADDRESS_HANDLER_CONST) */

/***************************************
*     Private Function Prototypes
***************************************/

#if(SPIM_SCB_MODE_I2C_CONST_CFG)
    void SPIM_I2CInit(void);
#endif /* (SPIM_SCB_MODE_I2C_CONST_CFG) */

void SPIM_I2CStop(void);
void SPIM_I2CSaveConfig(void);
void SPIM_I2CRestoreConfig(void);

#if(SPIM_I2C_MASTER_CONST)
    void SPIM_I2CReStartGeneration(void);
#endif /* (SPIM_I2C_MASTER_CONST) */

#endif /* (CY_SCB_I2C_PVT_SPIM_H) */


/* [] END OF FILE */
