/*******************************************************************************
* File Name: SPIM_spi_sclk.h  
* Version 2.20
*
* Description:
*  This file contains Pin function prototypes and register defines
*
********************************************************************************
* Copyright 2008-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_SPIM_spi_sclk_H) /* Pins SPIM_spi_sclk_H */
#define CY_PINS_SPIM_spi_sclk_H

#include "cytypes.h"
#include "cyfitter.h"
#include "SPIM_spi_sclk_aliases.h"


/***************************************
*     Data Struct Definitions
***************************************/

/**
* \addtogroup group_structures
* @{
*/
    
/* Structure for sleep mode support */
typedef struct
{
    uint32 pcState; /**< State of the port control register */
    uint32 sioState; /**< State of the SIO configuration */
    uint32 usbState; /**< State of the USBIO regulator */
} SPIM_spi_sclk_BACKUP_STRUCT;

/** @} structures */


/***************************************
*        Function Prototypes             
***************************************/
/**
* \addtogroup group_general
* @{
*/
uint8   SPIM_spi_sclk_Read(void);
void    SPIM_spi_sclk_Write(uint8 value);
uint8   SPIM_spi_sclk_ReadDataReg(void);
#if defined(SPIM_spi_sclk__PC) || (CY_PSOC4_4200L) 
    void    SPIM_spi_sclk_SetDriveMode(uint8 mode);
#endif
void    SPIM_spi_sclk_SetInterruptMode(uint16 position, uint16 mode);
uint8   SPIM_spi_sclk_ClearInterrupt(void);
/** @} general */

/**
* \addtogroup group_power
* @{
*/
void SPIM_spi_sclk_Sleep(void); 
void SPIM_spi_sclk_Wakeup(void);
/** @} power */


/***************************************
*           API Constants        
***************************************/
#if defined(SPIM_spi_sclk__PC) || (CY_PSOC4_4200L) 
    /* Drive Modes */
    #define SPIM_spi_sclk_DRIVE_MODE_BITS        (3)
    #define SPIM_spi_sclk_DRIVE_MODE_IND_MASK    (0xFFFFFFFFu >> (32 - SPIM_spi_sclk_DRIVE_MODE_BITS))

    /**
    * \addtogroup group_constants
    * @{
    */
        /** \addtogroup driveMode Drive mode constants
         * \brief Constants to be passed as "mode" parameter in the SPIM_spi_sclk_SetDriveMode() function.
         *  @{
         */
        #define SPIM_spi_sclk_DM_ALG_HIZ         (0x00u) /**< \brief High Impedance Analog   */
        #define SPIM_spi_sclk_DM_DIG_HIZ         (0x01u) /**< \brief High Impedance Digital  */
        #define SPIM_spi_sclk_DM_RES_UP          (0x02u) /**< \brief Resistive Pull Up       */
        #define SPIM_spi_sclk_DM_RES_DWN         (0x03u) /**< \brief Resistive Pull Down     */
        #define SPIM_spi_sclk_DM_OD_LO           (0x04u) /**< \brief Open Drain, Drives Low  */
        #define SPIM_spi_sclk_DM_OD_HI           (0x05u) /**< \brief Open Drain, Drives High */
        #define SPIM_spi_sclk_DM_STRONG          (0x06u) /**< \brief Strong Drive            */
        #define SPIM_spi_sclk_DM_RES_UPDWN       (0x07u) /**< \brief Resistive Pull Up/Down  */
        /** @} driveMode */
    /** @} group_constants */
#endif

/* Digital Port Constants */
#define SPIM_spi_sclk_MASK               SPIM_spi_sclk__MASK
#define SPIM_spi_sclk_SHIFT              SPIM_spi_sclk__SHIFT
#define SPIM_spi_sclk_WIDTH              1u

/**
* \addtogroup group_constants
* @{
*/
    /** \addtogroup intrMode Interrupt constants
     * \brief Constants to be passed as "mode" parameter in SPIM_spi_sclk_SetInterruptMode() function.
     *  @{
     */
        #define SPIM_spi_sclk_INTR_NONE      ((uint16)(0x0000u)) /**< \brief Disabled             */
        #define SPIM_spi_sclk_INTR_RISING    ((uint16)(0x5555u)) /**< \brief Rising edge trigger  */
        #define SPIM_spi_sclk_INTR_FALLING   ((uint16)(0xaaaau)) /**< \brief Falling edge trigger */
        #define SPIM_spi_sclk_INTR_BOTH      ((uint16)(0xffffu)) /**< \brief Both edge trigger    */
    /** @} intrMode */
/** @} group_constants */

/* SIO LPM definition */
#if defined(SPIM_spi_sclk__SIO)
    #define SPIM_spi_sclk_SIO_LPM_MASK       (0x03u)
#endif

/* USBIO definitions */
#if !defined(SPIM_spi_sclk__PC) && (CY_PSOC4_4200L)
    #define SPIM_spi_sclk_USBIO_ENABLE               ((uint32)0x80000000u)
    #define SPIM_spi_sclk_USBIO_DISABLE              ((uint32)(~SPIM_spi_sclk_USBIO_ENABLE))
    #define SPIM_spi_sclk_USBIO_SUSPEND_SHIFT        CYFLD_USBDEVv2_USB_SUSPEND__OFFSET
    #define SPIM_spi_sclk_USBIO_SUSPEND_DEL_SHIFT    CYFLD_USBDEVv2_USB_SUSPEND_DEL__OFFSET
    #define SPIM_spi_sclk_USBIO_ENTER_SLEEP          ((uint32)((1u << SPIM_spi_sclk_USBIO_SUSPEND_SHIFT) \
                                                        | (1u << SPIM_spi_sclk_USBIO_SUSPEND_DEL_SHIFT)))
    #define SPIM_spi_sclk_USBIO_EXIT_SLEEP_PH1       ((uint32)~((uint32)(1u << SPIM_spi_sclk_USBIO_SUSPEND_SHIFT)))
    #define SPIM_spi_sclk_USBIO_EXIT_SLEEP_PH2       ((uint32)~((uint32)(1u << SPIM_spi_sclk_USBIO_SUSPEND_DEL_SHIFT)))
    #define SPIM_spi_sclk_USBIO_CR1_OFF              ((uint32)0xfffffffeu)
#endif


/***************************************
*             Registers        
***************************************/
/* Main Port Registers */
#if defined(SPIM_spi_sclk__PC)
    /* Port Configuration */
    #define SPIM_spi_sclk_PC                 (* (reg32 *) SPIM_spi_sclk__PC)
#endif
/* Pin State */
#define SPIM_spi_sclk_PS                     (* (reg32 *) SPIM_spi_sclk__PS)
/* Data Register */
#define SPIM_spi_sclk_DR                     (* (reg32 *) SPIM_spi_sclk__DR)
/* Input Buffer Disable Override */
#define SPIM_spi_sclk_INP_DIS                (* (reg32 *) SPIM_spi_sclk__PC2)

/* Interrupt configuration Registers */
#define SPIM_spi_sclk_INTCFG                 (* (reg32 *) SPIM_spi_sclk__INTCFG)
#define SPIM_spi_sclk_INTSTAT                (* (reg32 *) SPIM_spi_sclk__INTSTAT)

/* "Interrupt cause" register for Combined Port Interrupt (AllPortInt) in GSRef component */
#if defined (CYREG_GPIO_INTR_CAUSE)
    #define SPIM_spi_sclk_INTR_CAUSE         (* (reg32 *) CYREG_GPIO_INTR_CAUSE)
#endif

/* SIO register */
#if defined(SPIM_spi_sclk__SIO)
    #define SPIM_spi_sclk_SIO_REG            (* (reg32 *) SPIM_spi_sclk__SIO)
#endif /* (SPIM_spi_sclk__SIO_CFG) */

/* USBIO registers */
#if !defined(SPIM_spi_sclk__PC) && (CY_PSOC4_4200L)
    #define SPIM_spi_sclk_USB_POWER_REG       (* (reg32 *) CYREG_USBDEVv2_USB_POWER_CTRL)
    #define SPIM_spi_sclk_CR1_REG             (* (reg32 *) CYREG_USBDEVv2_CR1)
    #define SPIM_spi_sclk_USBIO_CTRL_REG      (* (reg32 *) CYREG_USBDEVv2_USB_USBIO_CTRL)
#endif    
    
    
/***************************************
* The following code is DEPRECATED and 
* must not be used in new designs.
***************************************/
/**
* \addtogroup group_deprecated
* @{
*/
#define SPIM_spi_sclk_DRIVE_MODE_SHIFT       (0x00u)
#define SPIM_spi_sclk_DRIVE_MODE_MASK        (0x07u << SPIM_spi_sclk_DRIVE_MODE_SHIFT)
/** @} deprecated */

#endif /* End Pins SPIM_spi_sclk_H */


/* [] END OF FILE */
