/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/
#include "project.h"
#include "SPIM_SPI_UART.h"
#include "SPIButtons.h"

uint8 data;
uint8 NO_touch_A=0;
uint8 NO_touch_B=0;


void SPIM_Config_CAP1128_A(void)
{
    while(SPIM_SpiIsBusBusy()) //SPIM must be idle first
    {
        ; // Wait until not busy
    }
    SPIM_Stop();
    CyDelay(5);
    SPIM_SpiInit(&SPIM_8BitconfigSpi);
    SPIM_SpiSetActiveSlaveSelect(SPIM_SPI_SLAVE_SELECT1); // set Slave Select to 1 (CAP1128 #1 = U11)
	SPIM_Start();

    SPIM_SpiUartWriteTxData(0x7A);                  //Reset SPI i/f on CAP1128 #1 (U11, RHS 8 Buttons)
    SPIM_SpiUartWriteTxData(0x7A);                 //
    SPIM_SpiUartWriteTxData(CAP1128_SET_ADDR_PTR); //Send Set Address Pointer Command (0x7A) to CAP1128 #1
    SPIM_SpiUartWriteTxData(0x20);                 //Set address to 0x20 (Configuration Register)
    SPIM_SpiUartWriteTxData(CAP1128_WRITE_DATA);  //Send Set Address Pointer Command (0x7E) to CAP1128 #1
    SPIM_SpiUartWriteTxData(0x20);               //This register value should be 0x20
                                                     //All others, defaults are okay.

}

void SPIM_Config_CAP1128_B(void)
{
    while(SPIM_SpiIsBusBusy()) //SPIM must be idle first
    {
        ; // Wait until not busy
    }
    SPIM_Stop();
    CyDelay(5);
    SPIM_SpiInit(&SPIM_8BitconfigSpi);
    SPIM_SpiSetActiveSlaveSelect(SPIM_SPI_SLAVE_SELECT2); // set Slave Select to 2 (CAP1128 #2 = U5)
	SPIM_Start();
    CyDelay(5);
    SPIM_SpiUartWriteTxData(0x7A);                  //Reset SPI i/f on CAP1128 #1 (U11, RHS 8 Buttons)
    SPIM_SpiUartWriteTxData(0x7A);                 //
    SPIM_SpiUartWriteTxData(CAP1128_SET_ADDR_PTR); //Send Set Address Pointer Command (0x7A) to CAP1128 #1
    SPIM_SpiUartWriteTxData(0x20);                 //Set address to 0x20 (Configuration Register)
    SPIM_SpiUartWriteTxData(CAP1128_WRITE_DATA);  //Send Set Address Pointer Command (0x7E) to CAP1128 #1
    SPIM_SpiUartWriteTxData(0x20);               //This register value should be 0x20
                                                     //All others, defaults are okay.

}

void CheckCAP1128_A(void)
{
    uint8 i;
    uint8 MainCtlReg;
    uint8 SensInputReg;
    uint8 SensInputOLD=0;
//    uint8 YES_touch=0;
    extern uint8 active[9];
    
    while(SPIM_SpiIsBusBusy()) //SPIM must be idle first
    {
        ; // Wait until not busy
    }
        SPIM_Stop();
        CyDelay(5);
        SPIM_SpiInit(&SPIM_8BitconfigSpi);
        SPIM_SpiSetActiveSlaveSelect(SPIM_SPI_SLAVE_SELECT1); // set Slave Select to 1 (CAP1128 #1 = U11)
    	SPIM_Start();
        
        
        SPIM_SpiUartClearRxBuffer();                    //Clear the recieve buffer
        SPIM_SpiUartWriteTxData(0x7A);                  //Reset SPI i/f on CAP1128 #1 (U11)
        SPIM_SpiUartWriteTxData(0x7A);                 // (two 0x7A in sequence)
        SPIM_SpiUartWriteTxData(CAP1128_SET_ADDR_PTR);      //Send Set Address Pointer Command (0x7A) to CAP1128 #1
        SPIM_SpiUartWriteTxData(0x00); //Set address to 0
        SPIM_SpiUartWriteTxData(CAP1128_WRITE_DATA);  //Send Write Data Command (0x7F) to CAP1128 #1 (U11)
        SPIM_SpiUartWriteTxData(0x40);               //Set Gain to 2 and Clear INT
        SPIM_SpiUartWriteTxData(CAP1128_SET_ADDR_PTR);      //Send Set Address Pointer Command (0x7A) to CAP1128 #1
        SPIM_SpiUartWriteTxData(0x1F); //Set address to 1F (Sensitivity Control Register)
        SPIM_SpiUartWriteTxData(CAP1128_WRITE_DATA);  //Send Write Data Command (0x7F) to CAP1128 #1 (U11)
        SPIM_SpiUartWriteTxData(0x4F);               //Set Sensitivity to 8x (from defaul 32)
        SPIM_SpiUartWriteTxData(CAP1128_SET_ADDR_PTR);      //Send Set Address Pointer Command (0x7A) to CAP1128 #1
        SPIM_SpiUartWriteTxData(0x00); //Set address to 0
        
        for(i=0; i <= 12; i++)
        {
            SPIM_SpiUartWriteTxData(CAP1128_READ_DATA);  //Send Read Data Command (0x7F) to CAP1128 #1 (U11)
            if(SPIM_SpiUartGetRxBufferSize()>0)
            {
                data = SPIM_SpiUartReadRxData(); 
                CyDelay(1);
            }

            if(i==9)
            {
                MainCtlReg=data;
            
                if((MainCtlReg & 0x01)!=0) //If INT is set
                {
//                    YES_touch=1;
//                    if((MainCtlReg & 0x80)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 7 of address counter as ASCII
//                    if((MainCtlReg & 0x40)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 6 of address counter as ASCII
//                    if((MainCtlReg & 0x20)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 5 of address counter as ASCII
//                    if((MainCtlReg & 0x10)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 4 of address counter as ASCII
//                    if((MainCtlReg & 0x08)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 3 of address counter as ASCII
//                    if((MainCtlReg & 0x04)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 2 of address counter as ASCII
//                    if((MainCtlReg & 0x02)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 1 of address counter as ASCII
//                    if((MainCtlReg & 0x01)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 0 of address counter as ASCII
//                    UART_UartPutString("...");
                }
            }
            if(i==12)
            {
                SensInputReg=data; //Update status of sensing register
                    if((SensInputReg & 0x80)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 7 of address counter as ASCII
                    if((SensInputReg & 0x40)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 6 of address counter as ASCII
                    if((SensInputReg & 0x20)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 5 of address counter as ASCII
                    if((SensInputReg & 0x10)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 4 of address counter as ASCII
                    if((SensInputReg & 0x08)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 3 of address counter as ASCII
                    if((SensInputReg & 0x04)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 2 of address counter as ASCII
                    if((SensInputReg & 0x02)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 1 of address counter as ASCII
                    if((SensInputReg & 0x01)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 0 of address counter as ASCII
                    UART_UartPutString("...");
                    if((NO_touch_A & 0x80)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 7 of address counter as ASCII
                    if((NO_touch_A & 0x40)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 6 of address counter as ASCII
                    if((NO_touch_A & 0x20)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 5 of address counter as ASCII
                    if((NO_touch_A & 0x10)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 4 of address counter as ASCII
                    if((NO_touch_A & 0x08)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 3 of address counter as ASCII
                    if((NO_touch_A & 0x04)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 2 of address counter as ASCII
                    if((NO_touch_A & 0x02)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 1 of address counter as ASCII
                    if((NO_touch_A & 0x01)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 0 of address counter as ASCII
                    UART_UartPutString("\r\n");

                    switch(SensInputReg)
                    {
                        case 0x80 :
                        if((NO_touch_A) >= 2)
                        {
                            ++active[7]; //Up button for column 7. Increment.
                            if(active[7]>=8) active[7]=7;
                            active[8]=7; //Last column changed = 7
//                            SensInputOLD = SensInputOLD | 0x80; //Mark this touch as finished
                            NO_touch_A = 0;
                        }
                            break;
                        case 0x40 :
                        if((NO_touch_A) >= 2)
                        {
                            --active[7]; //Down button for column 7. Decrement.
                            if(active[7]>=8) active[7]=0;
                            active[8]=7; //Last column changed = 7
                            SensInputOLD = SensInputOLD | 0x40; //Mark this touch as finished
                            NO_touch_A = 0;
                        }
                            break;
                        case 0x20 :
                        if((NO_touch_A) >= 2)
                        {
                            ++active[6]; //Up button for column 6. Increment.
                            if(active[6]>=8) active[6]=7;
                            active[8]=6; //Last column changed = 6
                            SensInputOLD = SensInputOLD | 0x20; //Mark this touch as finished
                            NO_touch_A = 0;
                        }
                            break;
                        case 0x10 :
                        if((NO_touch_A) >= 2)
                        {
                            --active[6]; //Down button for column 6. Decrement.
                            if(active[6]>=8) active[6]=0;
                            active[8]=6; //Last column changed = 6
                            SensInputOLD = SensInputOLD | 0x10; //Mark this touch as finished
                            NO_touch_A = 0;
                        }
                            break;
                        case 0x08 :
                        if((NO_touch_A) >= 2)
                        {
                            ++active[5]; //Up button for column 5. Increment.
                            if(active[5]>=8) active[5]=7;
                            active[8]=5; //Last column changed = 5
                            SensInputOLD = SensInputOLD | 0x08; //Mark this touch as finished
                            NO_touch_A = 0;
                        }
                            break;
                        case 0x04 :
                        if((NO_touch_A) >= 2)
                        {
                            --active[5]; //Down button for column 5. Decrement.
                            if(active[5]>=8) active[5]=0;
                            active[8]=5; //Last column changed = 5
                            SensInputOLD = SensInputOLD | 0x04; //Mark this touch as finished
                            NO_touch_A = 0;
                        }
                            break;
                        case 0x02 :
                        if((NO_touch_A) >= 2)
                        {
                            ++active[4]; //Up button for column 4. Increment.
                            if(active[4]>=8) active[4]=7;
                            active[8]=4; //Last column changed = 4
                            SensInputOLD = SensInputOLD | 0x02; //Mark this touch as finished
                            NO_touch_A = 0;
                        }
                            break;
                        case 0x01 :
                        if((NO_touch_A) >= 2)
                        {
                            --active[4]; //Down button for column 4. Decrement.
                            if(active[4]>=8) active[4]=0;
                            active[8]=4; //Last column changed = 4
                            SensInputOLD = SensInputOLD | 0x01; //Mark this touch as finished
                            NO_touch_A = 0;
                        }
                            break;
                        case 0x00 :
                            if(NO_touch_A <= 254) ++NO_touch_A;

//                            SensInputOLD = 0; //No touches happening now
                            break;
                        default   :
                            break;
                    }
            }
        }
            

}

void CheckCAP1128_B(void)
{
    uint8 i;
    uint8 MainCtlReg;
    uint8 SensInputReg;
    uint8 SensInputOLD=0;
//    uint8 YES_touch=0;
    extern uint8 active[9];
    
    while(SPIM_SpiIsBusBusy()) //SPIM must be idle first
    {
        ; // Wait until not busy
    }
        SPIM_Stop();
        CyDelay(5);
        SPIM_SpiInit(&SPIM_8BitconfigSpi);
        CyDelay(2);
        SPIM_SpiSetActiveSlaveSelect(SPIM_SPI_SLAVE_SELECT2); // set Slave Select to 1 (CAP1128 #1 = U11)
    	SPIM_Start();
        CyDelay(5);
        
        SPIM_SpiUartClearRxBuffer();                    //Clear the recieve buffer
        SPIM_SpiUartWriteTxData(0x7A);                  //Reset SPI i/f on CAP1128 #1 (U11)
        SPIM_SpiUartWriteTxData(0x7A);                 // (two 0x7A in sequence)
        SPIM_SpiUartWriteTxData(CAP1128_SET_ADDR_PTR);      //Send Set Address Pointer Command (0x7A) to CAP1128 #1
        SPIM_SpiUartWriteTxData(0x00); //Set address to 0
        SPIM_SpiUartWriteTxData(CAP1128_WRITE_DATA);  //Send Write Data Command (0x7F) to CAP1128 #1 (U11)
        SPIM_SpiUartWriteTxData(0x40);               //Set Gain to 2 and Clear INT
        SPIM_SpiUartWriteTxData(CAP1128_SET_ADDR_PTR);      //Send Set Address Pointer Command (0x7A) to CAP1128 #1
        SPIM_SpiUartWriteTxData(0x1F); //Set address to 1F (Sensitivity Control Register)
        SPIM_SpiUartWriteTxData(CAP1128_WRITE_DATA);  //Send Write Data Command (0x7F) to CAP1128 #1 (U11)
        SPIM_SpiUartWriteTxData(0x4F);               //Set Sensitivity to 8x (from defaul 32)
        SPIM_SpiUartWriteTxData(CAP1128_SET_ADDR_PTR);      //Send Set Address Pointer Command (0x7A) to CAP1128 #1
        SPIM_SpiUartWriteTxData(0x00); //Set address to 0
        
        for(i=0; i <= 12; i++)
        {
            SPIM_SpiUartWriteTxData(CAP1128_READ_DATA);  //Send Read Data Command (0x7F) to CAP1128 #1 (U11)
            if(SPIM_SpiUartGetRxBufferSize()>0)
            {
                data = SPIM_SpiUartReadRxData(); 
                CyDelay(1);
            }

            if(i==9)
            {
                MainCtlReg=data;
            
                if((MainCtlReg & 0x01)!=0) //If INT is set
                {
//                    YES_touch=1;
//                    if((MainCtlReg & 0x80)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 7 of address counter as ASCII
//                    if((MainCtlReg & 0x40)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 6 of address counter as ASCII
//                    if((MainCtlReg & 0x20)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 5 of address counter as ASCII
//                    if((MainCtlReg & 0x10)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 4 of address counter as ASCII
//                    if((MainCtlReg & 0x08)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 3 of address counter as ASCII
//                    if((MainCtlReg & 0x04)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 2 of address counter as ASCII
//                    if((MainCtlReg & 0x02)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 1 of address counter as ASCII
//                    if((MainCtlReg & 0x01)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 0 of address counter as ASCII
//                    UART_UartPutString("...");
                }
            }
            if(i==12)
            {
                SensInputReg=data; //Update status of sensing register
                    if((SensInputReg & 0x80)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 7 of address counter as ASCII
                    if((SensInputReg & 0x40)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 6 of address counter as ASCII
                    if((SensInputReg & 0x20)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 5 of address counter as ASCII
                    if((SensInputReg & 0x10)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 4 of address counter as ASCII
                    if((SensInputReg & 0x08)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 3 of address counter as ASCII
                    if((SensInputReg & 0x04)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 2 of address counter as ASCII
                    if((SensInputReg & 0x02)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 1 of address counter as ASCII
                    if((SensInputReg & 0x01)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 0 of address counter as ASCII
                    UART_UartPutString("...");
                    if((NO_touch_B & 0x80)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 7 of address counter as ASCII
                    if((NO_touch_B & 0x40)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 6 of address counter as ASCII
                    if((NO_touch_B & 0x20)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 5 of address counter as ASCII
                    if((NO_touch_B & 0x10)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 4 of address counter as ASCII
                    if((NO_touch_B & 0x08)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 3 of address counter as ASCII
                    if((NO_touch_B & 0x04)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 2 of address counter as ASCII
                    if((NO_touch_B & 0x02)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 1 of address counter as ASCII
                    if((NO_touch_B & 0x01)!=0) UART_UartPutChar(49); else UART_UartPutChar(48); //print bit 0 of address counter as ASCII
                    UART_UartPutString("\r\n");

                    switch(SensInputReg)
                    {
                        case 0x80 :
                        if((NO_touch_B) >= 2)
                        {
                            ++active[7]; //Up button for column 7. Increment.
                            if(active[7]>=8) active[7]=7;
                            active[8]=7; //Last column changed = 7
//                            SensInputOLD = SensInputOLD | 0x80; //Mark this touch as finished
                            NO_touch_B = 0;
                        }
                            break;
                        case 0x40 :
                        if((NO_touch_B) >= 2)
                        {
                            --active[7]; //Down button for column 7. Decrement.
                            if(active[7]>=8) active[7]=0;
                            active[8]=7; //Last column changed = 7
                            SensInputOLD = SensInputOLD | 0x40; //Mark this touch as finished
                            NO_touch_B = 0;
                        }
                            break;
                        case 0x20 :
                        if((NO_touch_B) >= 2)
                        {
                            ++active[6]; //Up button for column 6. Increment.
                            if(active[6]>=8) active[6]=7;
                            active[8]=6; //Last column changed = 6
                            SensInputOLD = SensInputOLD | 0x20; //Mark this touch as finished
                            NO_touch_B = 0;
                        }
                            break;
                        case 0x10 :
                        if((NO_touch_B) >= 2)
                        {
                            --active[6]; //Down button for column 6. Decrement.
                            if(active[6]>=8) active[6]=0;
                            active[8]=6; //Last column changed = 6
                            SensInputOLD = SensInputOLD | 0x10; //Mark this touch as finished
                            NO_touch_B = 0;
                        }
                            break;
                        case 0x08 :
                        if((NO_touch_B) >= 2)
                        {
                            ++active[5]; //Up button for column 5. Increment.
                            if(active[5]>=8) active[5]=7;
                            active[8]=5; //Last column changed = 5
                            SensInputOLD = SensInputOLD | 0x08; //Mark this touch as finished
                            NO_touch_B = 0;
                        }
                            break;
                        case 0x04 :
                        if((NO_touch_B) >= 2)
                        {
                            --active[5]; //Down button for column 5. Decrement.
                            if(active[5]>=8) active[5]=0;
                            active[8]=5; //Last column changed = 5
                            SensInputOLD = SensInputOLD | 0x04; //Mark this touch as finished
                            NO_touch_B = 0;
                        }
                            break;
                        case 0x02 :
                        if((NO_touch_B) >= 2)
                        {
                            ++active[4]; //Up button for column 4. Increment.
                            if(active[4]>=8) active[4]=7;
                            active[8]=4; //Last column changed = 4
                            SensInputOLD = SensInputOLD | 0x02; //Mark this touch as finished
                            NO_touch_B = 0;
                        }
                            break;
                        case 0x01 :
                        if((NO_touch_B) >= 2)
                        {
                            --active[4]; //Down button for column 4. Decrement.
                            if(active[4]>=8) active[4]=0;
                            active[8]=4; //Last column changed = 4
                            SensInputOLD = SensInputOLD | 0x01; //Mark this touch as finished
                            NO_touch_B = 0;
                        }
                            break;
                        case 0x00 :
                            if(NO_touch_B <= 254) ++NO_touch_B;

//                            SensInputOLD = 0; //No touches happening now
                            break;
                        default   :
                            break;
                    }
            }
        }
            

}

/* [] END OF FILE */
