/* ========================================
 *
 * Copyright DAVE BAILEY, 2017
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF Dave Bailey.
 *
 * ========================================
*/

#include <SPIM_SPI_UART.h>

uint8 mrow=0,chl=0,chr=0,i=0;
uint32 data=0;
extern uint8 active[9];
//extern uint8 TxCol;


void setup_matrix()
{
    
    while(SPIM_SpiIsBusBusy()) //SPIM must be idle first
    {
        ; // Wait until not busy
    }
    SPIM_Stop();
    CyDelay(5);
    SPIM_SpiInit(&SPIM_configSpi);
    SPIM_SpiSetActiveSlaveSelect(SPIM_SPI_SLAVE_SELECT0); // set Slave Select to 0 (LED Matrix)
	SPIM_Start();

    data=0x0B07;    //enable all LEDS
    for(i=0;i<4;i++)
    {
        SPIM_SpiUartWriteTxData(data); //shift out the data
    }
    CyDelay(2);
    data=0x0900;    //using one matrix
    for(i=0;i<4;i++)
    {
        SPIM_SpiUartWriteTxData(data); //shift out the data
    }
    CyDelay(2);
    data=0x0F00;    //no display test
    for(i=0;i<4;i++)
    {
        SPIM_SpiUartWriteTxData(data); //shift out the data
    }
    CyDelay(2);
    data=0x0C01;    //no shutdown
    for(i=0;i<4;i++)
    {
        SPIM_SpiUartWriteTxData(data); //shift out the data
    }
    CyDelay(2);
    data=0x0A01;    //intensity 
    for(i=0;i<4;i++)
    {
        SPIM_SpiUartWriteTxData(data); //shift out the data
    }
    CyDelay(2);
    for(mrow=0;mrow<8;mrow++)
    {
        data=(mrow+1)<<8;   //create the code to clear each column
        for(i=0;i<4;i++)    //then shift it out to four displays in sequence
        {
            SPIM_SpiUartWriteTxData(data); //shift out the data
        }
        CyDelay(2);
    }

}

void update_matrix(void)
{
    uint8 i,j;
    
    while(SPIM_SpiIsBusBusy()) //SPIM must be idle first
    {
        ; // Wait until not busy
    }
    SPIM_Stop();
    CyDelay(5);
    SPIM_SpiInit(&SPIM_configSpi);
    SPIM_SpiSetActiveSlaveSelect(SPIM_SPI_SLAVE_SELECT0); // set Slave Select to 1 (CAP1128 #1 = U11)
    SPIM_Start();


            for(mrow=0;mrow<8;mrow++)
            {                           //2 vertical bars per 8x8 LED matix
                i=!((mrow+1)<=(7-active[0])); //if the bar extends vertically to this row, i=1.
                if(active[8]==0)
                {
                    j=(((mrow)<=(7-active[0])) | i);
                }
                else
                {
                    j=i;
                }
                chl=((((i<<1)+ j)<<1)+i)<<1; //the bar is 3 LED columns wide, with a space in the 4th column
                i=!((mrow+1)<=(7-active[1]));
                if(active[8]==1)
                {
                    j=(((mrow)<=(7-active[0])) | i);
                }
                else
                {
                    j=i;
                }
                chr=((((i<<1)+ j)<<1)+i)<<1; //build the 4-LED pattern for the right side of the matrix
                data=(((mrow+1)<<8)+ ((chl<<4)+chr) ); //put the two nibbles together as LSB with command as MSB (16 bits)
                SPIM_SpiUartWriteTxData(data); //Send bits 0-7 of 32-bit row
//                CyDelay(1);
                i=!((mrow+1)<=(7-active[2]));
                if(active[8]==2)
                {
                    j=(((mrow)<=(7-active[0])) | i);
                }
                else
                {
                    j=i;
                }
                chl=((((i<<1)+ j)<<1)+i)<<1; 
                i=!((mrow+1)<=(7-active[3]));
                if(active[8]==3)
                {
                    j=(((mrow)<=(7-active[0])) | i);
                }
                else
                {
                    j=i;
                }
                chr=((((i<<1)+ j)<<1)+i)<<1; 
                data=(((mrow+1)<<8)+ ((chl<<4)+chr) );
                SPIM_SpiUartWriteTxData(data); // bits 8-15 of 32-bit row
//                CyDelay(1);
                i=!((mrow+1)<=(7-active[4]));
                if(active[8]==4)
                {
                    j=(((mrow)<=(7-active[0])) | i);
                }
                else
                {
                    j=i;
                }
                chl=((((i<<1)+ j)<<1)+i)<<1; 
                i=!((mrow+1)<=(7-active[5]));
                if(active[8]==5)
                {
                    j=(((mrow)<=(7-active[0])) | i);
                }
                else
                {
                    j=i;
                }
                chr=((((i<<1)+ j)<<1)+i)<<1; 
                data=(((mrow+1)<<8)+ ((chl<<4)+chr) );
                SPIM_SpiUartWriteTxData(data); //Send bits 16-23 of 32-bit row
//                CyDelay(1);
                i=!((mrow+1)<=(7-active[6]));
                if(active[8]==6)
                {
                    j=(((mrow)<=(7-active[0])) | i);
                }
                else
                {
                    j=i;
                }
                chl=((((i<<1)+ j)<<1)+i)<<1; 
                i=!((mrow+1)<=(7-active[7]));
                if(active[8]==7)
                {
                    j=(((mrow)<=(7-active[0])) | i);
                }
                else
                {
                    j=i;
                }
                chr=((((i<<1)+ j)<<1)+i)<<1; 
                data=(((mrow+1)<<8)+ ((chl<<4)+chr) );
                SPIM_SpiUartWriteTxData(data); //Send bits 24-31 of 32-bit row
                CyDelay(2);
            }

}

/* [] END OF FILE */
