/* ========================================
 *
 * Copyright Dave Bailey, 2017
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * Working CAP1128 (U11), with LED matrix. CAP+LEDS01f is a copy of CAP+LEDS01f to debug
 * problem with CAP1128_B (U5)
 * 
 * ========================================
*/
#include "project.h"
#include "SPIM_SPI_UART.h"

/* ISR Handler */
CY_ISR_PROTO( ResetISR_Handler );

/* Implementation of ISR Handler */
CY_ISR( ResetISR_Handler )
{
    Bootloadable_1_Load();      /* Force Bootloader Restart */
}


/* Function Prototypes */

void setup_CAP1128(void);
void update_CAP1128(void);
void CheckCAP1128_A(void);
void CheckCAP1128_B(void);
void SPIM_Config_CAP1128_A(void);
void SPIM_Config_CAP1128_B(void);
void SPIM_Config_Display(void);


void setup_matrix(void);
void update_matrix(void);
extern void SPIM_SpiInit(const SPIM_SPI_INIT_STRUCT *config);
uint8 active[9];


int main(void)
{
//    char data = 0x20;
//    uint8 i=0;
//    uint8 Register[3];

    /* Start the RESET Timer  - Only runs when SW1 is pressed */
    ResetTimer_Start();
    
    /* Install the ISR handler and make sure none are pending */
    ResetISR_ClearPending();
    ResetISR_StartEx( ResetISR_Handler );
    
    CyGlobalIntEnable; /* Enable global interrupts. */

    /* Place your initialization/startup code here (e.g. MyInst_Start()) */
    UART_Start();
//    setup_matrix();
//    CyDelay(5);
//    SPIM_Config_CAP1128_A();
//    CyDelay(5);
    SPIM_Config_CAP1128_B();
    CyDelay(5);
    for(;;)
    {
//        UART_UartPutString("Read CAP1128 and check for received data:\n\r");
//        update_matrix();
//        CyDelay(5);
//        CheckCAP1128_A();            
//        CyDelay(5);
        CheckCAP1128_B();            
        CyDelay(5);

    }

//    CyDelay(500);

}



/* [] END OF FILE */
