/*******************************************************************************
* File Name: Mic.h  
* Version 2.20
*
* Description:
*  This file contains Pin function prototypes and register defines
*
********************************************************************************
* Copyright 2008-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_Mic_H) /* Pins Mic_H */
#define CY_PINS_Mic_H

#include "cytypes.h"
#include "cyfitter.h"
#include "Mic_aliases.h"


/***************************************
*     Data Struct Definitions
***************************************/

/**
* \addtogroup group_structures
* @{
*/
    
/* Structure for sleep mode support */
typedef struct
{
    uint32 pcState; /**< State of the port control register */
    uint32 sioState; /**< State of the SIO configuration */
    uint32 usbState; /**< State of the USBIO regulator */
} Mic_BACKUP_STRUCT;

/** @} structures */


/***************************************
*        Function Prototypes             
***************************************/
/**
* \addtogroup group_general
* @{
*/
uint8   Mic_Read(void);
void    Mic_Write(uint8 value);
uint8   Mic_ReadDataReg(void);
#if defined(Mic__PC) || (CY_PSOC4_4200L) 
    void    Mic_SetDriveMode(uint8 mode);
#endif
void    Mic_SetInterruptMode(uint16 position, uint16 mode);
uint8   Mic_ClearInterrupt(void);
/** @} general */

/**
* \addtogroup group_power
* @{
*/
void Mic_Sleep(void); 
void Mic_Wakeup(void);
/** @} power */


/***************************************
*           API Constants        
***************************************/
#if defined(Mic__PC) || (CY_PSOC4_4200L) 
    /* Drive Modes */
    #define Mic_DRIVE_MODE_BITS        (3)
    #define Mic_DRIVE_MODE_IND_MASK    (0xFFFFFFFFu >> (32 - Mic_DRIVE_MODE_BITS))

    /**
    * \addtogroup group_constants
    * @{
    */
        /** \addtogroup driveMode Drive mode constants
         * \brief Constants to be passed as "mode" parameter in the Mic_SetDriveMode() function.
         *  @{
         */
        #define Mic_DM_ALG_HIZ         (0x00u) /**< \brief High Impedance Analog   */
        #define Mic_DM_DIG_HIZ         (0x01u) /**< \brief High Impedance Digital  */
        #define Mic_DM_RES_UP          (0x02u) /**< \brief Resistive Pull Up       */
        #define Mic_DM_RES_DWN         (0x03u) /**< \brief Resistive Pull Down     */
        #define Mic_DM_OD_LO           (0x04u) /**< \brief Open Drain, Drives Low  */
        #define Mic_DM_OD_HI           (0x05u) /**< \brief Open Drain, Drives High */
        #define Mic_DM_STRONG          (0x06u) /**< \brief Strong Drive            */
        #define Mic_DM_RES_UPDWN       (0x07u) /**< \brief Resistive Pull Up/Down  */
        /** @} driveMode */
    /** @} group_constants */
#endif

/* Digital Port Constants */
#define Mic_MASK               Mic__MASK
#define Mic_SHIFT              Mic__SHIFT
#define Mic_WIDTH              1u

/**
* \addtogroup group_constants
* @{
*/
    /** \addtogroup intrMode Interrupt constants
     * \brief Constants to be passed as "mode" parameter in Mic_SetInterruptMode() function.
     *  @{
     */
        #define Mic_INTR_NONE      ((uint16)(0x0000u)) /**< \brief Disabled             */
        #define Mic_INTR_RISING    ((uint16)(0x5555u)) /**< \brief Rising edge trigger  */
        #define Mic_INTR_FALLING   ((uint16)(0xaaaau)) /**< \brief Falling edge trigger */
        #define Mic_INTR_BOTH      ((uint16)(0xffffu)) /**< \brief Both edge trigger    */
    /** @} intrMode */
/** @} group_constants */

/* SIO LPM definition */
#if defined(Mic__SIO)
    #define Mic_SIO_LPM_MASK       (0x03u)
#endif

/* USBIO definitions */
#if !defined(Mic__PC) && (CY_PSOC4_4200L)
    #define Mic_USBIO_ENABLE               ((uint32)0x80000000u)
    #define Mic_USBIO_DISABLE              ((uint32)(~Mic_USBIO_ENABLE))
    #define Mic_USBIO_SUSPEND_SHIFT        CYFLD_USBDEVv2_USB_SUSPEND__OFFSET
    #define Mic_USBIO_SUSPEND_DEL_SHIFT    CYFLD_USBDEVv2_USB_SUSPEND_DEL__OFFSET
    #define Mic_USBIO_ENTER_SLEEP          ((uint32)((1u << Mic_USBIO_SUSPEND_SHIFT) \
                                                        | (1u << Mic_USBIO_SUSPEND_DEL_SHIFT)))
    #define Mic_USBIO_EXIT_SLEEP_PH1       ((uint32)~((uint32)(1u << Mic_USBIO_SUSPEND_SHIFT)))
    #define Mic_USBIO_EXIT_SLEEP_PH2       ((uint32)~((uint32)(1u << Mic_USBIO_SUSPEND_DEL_SHIFT)))
    #define Mic_USBIO_CR1_OFF              ((uint32)0xfffffffeu)
#endif


/***************************************
*             Registers        
***************************************/
/* Main Port Registers */
#if defined(Mic__PC)
    /* Port Configuration */
    #define Mic_PC                 (* (reg32 *) Mic__PC)
#endif
/* Pin State */
#define Mic_PS                     (* (reg32 *) Mic__PS)
/* Data Register */
#define Mic_DR                     (* (reg32 *) Mic__DR)
/* Input Buffer Disable Override */
#define Mic_INP_DIS                (* (reg32 *) Mic__PC2)

/* Interrupt configuration Registers */
#define Mic_INTCFG                 (* (reg32 *) Mic__INTCFG)
#define Mic_INTSTAT                (* (reg32 *) Mic__INTSTAT)

/* "Interrupt cause" register for Combined Port Interrupt (AllPortInt) in GSRef component */
#if defined (CYREG_GPIO_INTR_CAUSE)
    #define Mic_INTR_CAUSE         (* (reg32 *) CYREG_GPIO_INTR_CAUSE)
#endif

/* SIO register */
#if defined(Mic__SIO)
    #define Mic_SIO_REG            (* (reg32 *) Mic__SIO)
#endif /* (Mic__SIO_CFG) */

/* USBIO registers */
#if !defined(Mic__PC) && (CY_PSOC4_4200L)
    #define Mic_USB_POWER_REG       (* (reg32 *) CYREG_USBDEVv2_USB_POWER_CTRL)
    #define Mic_CR1_REG             (* (reg32 *) CYREG_USBDEVv2_CR1)
    #define Mic_USBIO_CTRL_REG      (* (reg32 *) CYREG_USBDEVv2_USB_USBIO_CTRL)
#endif    
    
    
/***************************************
* The following code is DEPRECATED and 
* must not be used in new designs.
***************************************/
/**
* \addtogroup group_deprecated
* @{
*/
#define Mic_DRIVE_MODE_SHIFT       (0x00u)
#define Mic_DRIVE_MODE_MASK        (0x07u << Mic_DRIVE_MODE_SHIFT)
/** @} deprecated */

#endif /* End Pins Mic_H */


/* [] END OF FILE */
