/***************************************************************************//**
* \file SCB_2_SPI_UART_PVT.h
* \version 3.20
*
* \brief
*  This private file provides constants and parameter values for the
*  SCB Component in SPI and UART modes.
*  Please do not use this file or its content in your project.
*
* Note:
*
********************************************************************************
* \copyright
* Copyright 2013-2016, Cypress Semiconductor Corporation. All rights reserved.
* You may use this file only in accordance with the license, terms, conditions,
* disclaimers, and limitations in the end user license agreement accompanying
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_SCB_SPI_UART_PVT_SCB_2_H)
#define CY_SCB_SPI_UART_PVT_SCB_2_H

#include "SCB_2_SPI_UART.h"


/***************************************
*     Internal Global Vars
***************************************/

#if (SCB_2_INTERNAL_RX_SW_BUFFER_CONST)
    extern volatile uint32  SCB_2_rxBufferHead;
    extern volatile uint32  SCB_2_rxBufferTail;
    
    /**
    * \addtogroup group_globals
    * @{
    */
    
    /** Sets when internal software receive buffer overflow
     *  was occurred.
    */  
    extern volatile uint8   SCB_2_rxBufferOverflow;
    /** @} globals */
#endif /* (SCB_2_INTERNAL_RX_SW_BUFFER_CONST) */

#if (SCB_2_INTERNAL_TX_SW_BUFFER_CONST)
    extern volatile uint32  SCB_2_txBufferHead;
    extern volatile uint32  SCB_2_txBufferTail;
#endif /* (SCB_2_INTERNAL_TX_SW_BUFFER_CONST) */

#if (SCB_2_INTERNAL_RX_SW_BUFFER)
    extern volatile uint8 SCB_2_rxBufferInternal[SCB_2_INTERNAL_RX_BUFFER_SIZE];
#endif /* (SCB_2_INTERNAL_RX_SW_BUFFER) */

#if (SCB_2_INTERNAL_TX_SW_BUFFER)
    extern volatile uint8 SCB_2_txBufferInternal[SCB_2_TX_BUFFER_SIZE];
#endif /* (SCB_2_INTERNAL_TX_SW_BUFFER) */


/***************************************
*     Private Function Prototypes
***************************************/

void SCB_2_SpiPostEnable(void);
void SCB_2_SpiStop(void);

#if (SCB_2_SCB_MODE_SPI_CONST_CFG)
    void SCB_2_SpiInit(void);
#endif /* (SCB_2_SCB_MODE_SPI_CONST_CFG) */

#if (SCB_2_SPI_WAKE_ENABLE_CONST)
    void SCB_2_SpiSaveConfig(void);
    void SCB_2_SpiRestoreConfig(void);
#endif /* (SCB_2_SPI_WAKE_ENABLE_CONST) */

void SCB_2_UartPostEnable(void);
void SCB_2_UartStop(void);

#if (SCB_2_SCB_MODE_UART_CONST_CFG)
    void SCB_2_UartInit(void);
#endif /* (SCB_2_SCB_MODE_UART_CONST_CFG) */

#if (SCB_2_UART_WAKE_ENABLE_CONST)
    void SCB_2_UartSaveConfig(void);
    void SCB_2_UartRestoreConfig(void);
#endif /* (SCB_2_UART_WAKE_ENABLE_CONST) */


/***************************************
*         UART API Constants
***************************************/

/* UART RX and TX position to be used in SCB_2_SetPins() */
#define SCB_2_UART_RX_PIN_ENABLE    (SCB_2_UART_RX)
#define SCB_2_UART_TX_PIN_ENABLE    (SCB_2_UART_TX)

/* UART RTS and CTS position to be used in  SCB_2_SetPins() */
#define SCB_2_UART_RTS_PIN_ENABLE    (0x10u)
#define SCB_2_UART_CTS_PIN_ENABLE    (0x20u)


/***************************************
* The following code is DEPRECATED and
* must not be used.
***************************************/

/* Interrupt processing */
#define SCB_2_SpiUartEnableIntRx(intSourceMask)  SCB_2_SetRxInterruptMode(intSourceMask)
#define SCB_2_SpiUartEnableIntTx(intSourceMask)  SCB_2_SetTxInterruptMode(intSourceMask)
uint32  SCB_2_SpiUartDisableIntRx(void);
uint32  SCB_2_SpiUartDisableIntTx(void);


#endif /* (CY_SCB_SPI_UART_PVT_SCB_2_H) */


/* [] END OF FILE */
