/*******************************************************************************
* File Name: Samp_Vbatt.c  
* Version 2.20
*
* Description:
*  This file contains APIs to set up the Pins component for low power modes.
*
* Note:
*
********************************************************************************
* Copyright 2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#include "cytypes.h"
#include "Samp_Vbatt.h"

static Samp_Vbatt_BACKUP_STRUCT  Samp_Vbatt_backup = {0u, 0u, 0u};


/*******************************************************************************
* Function Name: Samp_Vbatt_Sleep
****************************************************************************//**
*
* \brief Stores the pin configuration and prepares the pin for entering chip 
*  deep-sleep/hibernate modes. This function applies only to SIO and USBIO pins.
*  It should not be called for GPIO or GPIO_OVT pins.
*
* <b>Note</b> This function is available in PSoC 4 only.
*
* \return 
*  None 
*  
* \sideeffect
*  For SIO pins, this function configures the pin input threshold to CMOS and
*  drive level to Vddio. This is needed for SIO pins when in device 
*  deep-sleep/hibernate modes.
*
* \funcusage
*  \snippet Samp_Vbatt_SUT.c usage_Samp_Vbatt_Sleep_Wakeup
*******************************************************************************/
void Samp_Vbatt_Sleep(void)
{
    #if defined(Samp_Vbatt__PC)
        Samp_Vbatt_backup.pcState = Samp_Vbatt_PC;
    #else
        #if (CY_PSOC4_4200L)
            /* Save the regulator state and put the PHY into suspend mode */
            Samp_Vbatt_backup.usbState = Samp_Vbatt_CR1_REG;
            Samp_Vbatt_USB_POWER_REG |= Samp_Vbatt_USBIO_ENTER_SLEEP;
            Samp_Vbatt_CR1_REG &= Samp_Vbatt_USBIO_CR1_OFF;
        #endif
    #endif
    #if defined(CYIPBLOCK_m0s8ioss_VERSION) && defined(Samp_Vbatt__SIO)
        Samp_Vbatt_backup.sioState = Samp_Vbatt_SIO_REG;
        /* SIO requires unregulated output buffer and single ended input buffer */
        Samp_Vbatt_SIO_REG &= (uint32)(~Samp_Vbatt_SIO_LPM_MASK);
    #endif  
}


/*******************************************************************************
* Function Name: Samp_Vbatt_Wakeup
****************************************************************************//**
*
* \brief Restores the pin configuration that was saved during Pin_Sleep(). This 
* function applies only to SIO and USBIO pins. It should not be called for
* GPIO or GPIO_OVT pins.
*
* For USBIO pins, the wakeup is only triggered for falling edge interrupts.
*
* <b>Note</b> This function is available in PSoC 4 only.
*
* \return 
*  None
*  
* \funcusage
*  Refer to Samp_Vbatt_Sleep() for an example usage.
*******************************************************************************/
void Samp_Vbatt_Wakeup(void)
{
    #if defined(Samp_Vbatt__PC)
        Samp_Vbatt_PC = Samp_Vbatt_backup.pcState;
    #else
        #if (CY_PSOC4_4200L)
            /* Restore the regulator state and come out of suspend mode */
            Samp_Vbatt_USB_POWER_REG &= Samp_Vbatt_USBIO_EXIT_SLEEP_PH1;
            Samp_Vbatt_CR1_REG = Samp_Vbatt_backup.usbState;
            Samp_Vbatt_USB_POWER_REG &= Samp_Vbatt_USBIO_EXIT_SLEEP_PH2;
        #endif
    #endif
    #if defined(CYIPBLOCK_m0s8ioss_VERSION) && defined(Samp_Vbatt__SIO)
        Samp_Vbatt_SIO_REG = Samp_Vbatt_backup.sioState;
    #endif
}


/* [] END OF FILE */
