/*******************************************************************************
* File Name: Accell_CS.h  
* Version 2.20
*
* Description:
*  This file contains Pin function prototypes and register defines
*
********************************************************************************
* Copyright 2008-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_Accell_CS_H) /* Pins Accell_CS_H */
#define CY_PINS_Accell_CS_H

#include "cytypes.h"
#include "cyfitter.h"
#include "Accell_CS_aliases.h"


/***************************************
*     Data Struct Definitions
***************************************/

/**
* \addtogroup group_structures
* @{
*/
    
/* Structure for sleep mode support */
typedef struct
{
    uint32 pcState; /**< State of the port control register */
    uint32 sioState; /**< State of the SIO configuration */
    uint32 usbState; /**< State of the USBIO regulator */
} Accell_CS_BACKUP_STRUCT;

/** @} structures */


/***************************************
*        Function Prototypes             
***************************************/
/**
* \addtogroup group_general
* @{
*/
uint8   Accell_CS_Read(void);
void    Accell_CS_Write(uint8 value);
uint8   Accell_CS_ReadDataReg(void);
#if defined(Accell_CS__PC) || (CY_PSOC4_4200L) 
    void    Accell_CS_SetDriveMode(uint8 mode);
#endif
void    Accell_CS_SetInterruptMode(uint16 position, uint16 mode);
uint8   Accell_CS_ClearInterrupt(void);
/** @} general */

/**
* \addtogroup group_power
* @{
*/
void Accell_CS_Sleep(void); 
void Accell_CS_Wakeup(void);
/** @} power */


/***************************************
*           API Constants        
***************************************/
#if defined(Accell_CS__PC) || (CY_PSOC4_4200L) 
    /* Drive Modes */
    #define Accell_CS_DRIVE_MODE_BITS        (3)
    #define Accell_CS_DRIVE_MODE_IND_MASK    (0xFFFFFFFFu >> (32 - Accell_CS_DRIVE_MODE_BITS))

    /**
    * \addtogroup group_constants
    * @{
    */
        /** \addtogroup driveMode Drive mode constants
         * \brief Constants to be passed as "mode" parameter in the Accell_CS_SetDriveMode() function.
         *  @{
         */
        #define Accell_CS_DM_ALG_HIZ         (0x00u) /**< \brief High Impedance Analog   */
        #define Accell_CS_DM_DIG_HIZ         (0x01u) /**< \brief High Impedance Digital  */
        #define Accell_CS_DM_RES_UP          (0x02u) /**< \brief Resistive Pull Up       */
        #define Accell_CS_DM_RES_DWN         (0x03u) /**< \brief Resistive Pull Down     */
        #define Accell_CS_DM_OD_LO           (0x04u) /**< \brief Open Drain, Drives Low  */
        #define Accell_CS_DM_OD_HI           (0x05u) /**< \brief Open Drain, Drives High */
        #define Accell_CS_DM_STRONG          (0x06u) /**< \brief Strong Drive            */
        #define Accell_CS_DM_RES_UPDWN       (0x07u) /**< \brief Resistive Pull Up/Down  */
        /** @} driveMode */
    /** @} group_constants */
#endif

/* Digital Port Constants */
#define Accell_CS_MASK               Accell_CS__MASK
#define Accell_CS_SHIFT              Accell_CS__SHIFT
#define Accell_CS_WIDTH              1u

/**
* \addtogroup group_constants
* @{
*/
    /** \addtogroup intrMode Interrupt constants
     * \brief Constants to be passed as "mode" parameter in Accell_CS_SetInterruptMode() function.
     *  @{
     */
        #define Accell_CS_INTR_NONE      ((uint16)(0x0000u)) /**< \brief Disabled             */
        #define Accell_CS_INTR_RISING    ((uint16)(0x5555u)) /**< \brief Rising edge trigger  */
        #define Accell_CS_INTR_FALLING   ((uint16)(0xaaaau)) /**< \brief Falling edge trigger */
        #define Accell_CS_INTR_BOTH      ((uint16)(0xffffu)) /**< \brief Both edge trigger    */
    /** @} intrMode */
/** @} group_constants */

/* SIO LPM definition */
#if defined(Accell_CS__SIO)
    #define Accell_CS_SIO_LPM_MASK       (0x03u)
#endif

/* USBIO definitions */
#if !defined(Accell_CS__PC) && (CY_PSOC4_4200L)
    #define Accell_CS_USBIO_ENABLE               ((uint32)0x80000000u)
    #define Accell_CS_USBIO_DISABLE              ((uint32)(~Accell_CS_USBIO_ENABLE))
    #define Accell_CS_USBIO_SUSPEND_SHIFT        CYFLD_USBDEVv2_USB_SUSPEND__OFFSET
    #define Accell_CS_USBIO_SUSPEND_DEL_SHIFT    CYFLD_USBDEVv2_USB_SUSPEND_DEL__OFFSET
    #define Accell_CS_USBIO_ENTER_SLEEP          ((uint32)((1u << Accell_CS_USBIO_SUSPEND_SHIFT) \
                                                        | (1u << Accell_CS_USBIO_SUSPEND_DEL_SHIFT)))
    #define Accell_CS_USBIO_EXIT_SLEEP_PH1       ((uint32)~((uint32)(1u << Accell_CS_USBIO_SUSPEND_SHIFT)))
    #define Accell_CS_USBIO_EXIT_SLEEP_PH2       ((uint32)~((uint32)(1u << Accell_CS_USBIO_SUSPEND_DEL_SHIFT)))
    #define Accell_CS_USBIO_CR1_OFF              ((uint32)0xfffffffeu)
#endif


/***************************************
*             Registers        
***************************************/
/* Main Port Registers */
#if defined(Accell_CS__PC)
    /* Port Configuration */
    #define Accell_CS_PC                 (* (reg32 *) Accell_CS__PC)
#endif
/* Pin State */
#define Accell_CS_PS                     (* (reg32 *) Accell_CS__PS)
/* Data Register */
#define Accell_CS_DR                     (* (reg32 *) Accell_CS__DR)
/* Input Buffer Disable Override */
#define Accell_CS_INP_DIS                (* (reg32 *) Accell_CS__PC2)

/* Interrupt configuration Registers */
#define Accell_CS_INTCFG                 (* (reg32 *) Accell_CS__INTCFG)
#define Accell_CS_INTSTAT                (* (reg32 *) Accell_CS__INTSTAT)

/* "Interrupt cause" register for Combined Port Interrupt (AllPortInt) in GSRef component */
#if defined (CYREG_GPIO_INTR_CAUSE)
    #define Accell_CS_INTR_CAUSE         (* (reg32 *) CYREG_GPIO_INTR_CAUSE)
#endif

/* SIO register */
#if defined(Accell_CS__SIO)
    #define Accell_CS_SIO_REG            (* (reg32 *) Accell_CS__SIO)
#endif /* (Accell_CS__SIO_CFG) */

/* USBIO registers */
#if !defined(Accell_CS__PC) && (CY_PSOC4_4200L)
    #define Accell_CS_USB_POWER_REG       (* (reg32 *) CYREG_USBDEVv2_USB_POWER_CTRL)
    #define Accell_CS_CR1_REG             (* (reg32 *) CYREG_USBDEVv2_CR1)
    #define Accell_CS_USBIO_CTRL_REG      (* (reg32 *) CYREG_USBDEVv2_USB_USBIO_CTRL)
#endif    
    
    
/***************************************
* The following code is DEPRECATED and 
* must not be used in new designs.
***************************************/
/**
* \addtogroup group_deprecated
* @{
*/
#define Accell_CS_DRIVE_MODE_SHIFT       (0x00u)
#define Accell_CS_DRIVE_MODE_MASK        (0x07u << Accell_CS_DRIVE_MODE_SHIFT)
/** @} deprecated */

#endif /* End Pins Accell_CS_H */


/* [] END OF FILE */
