/*******************************************************************************
* File Name: Accell_Int.h  
* Version 2.20
*
* Description:
*  This file contains Pin function prototypes and register defines
*
********************************************************************************
* Copyright 2008-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_Accell_Int_H) /* Pins Accell_Int_H */
#define CY_PINS_Accell_Int_H

#include "cytypes.h"
#include "cyfitter.h"
#include "Accell_Int_aliases.h"


/***************************************
*     Data Struct Definitions
***************************************/

/**
* \addtogroup group_structures
* @{
*/
    
/* Structure for sleep mode support */
typedef struct
{
    uint32 pcState; /**< State of the port control register */
    uint32 sioState; /**< State of the SIO configuration */
    uint32 usbState; /**< State of the USBIO regulator */
} Accell_Int_BACKUP_STRUCT;

/** @} structures */


/***************************************
*        Function Prototypes             
***************************************/
/**
* \addtogroup group_general
* @{
*/
uint8   Accell_Int_Read(void);
void    Accell_Int_Write(uint8 value);
uint8   Accell_Int_ReadDataReg(void);
#if defined(Accell_Int__PC) || (CY_PSOC4_4200L) 
    void    Accell_Int_SetDriveMode(uint8 mode);
#endif
void    Accell_Int_SetInterruptMode(uint16 position, uint16 mode);
uint8   Accell_Int_ClearInterrupt(void);
/** @} general */

/**
* \addtogroup group_power
* @{
*/
void Accell_Int_Sleep(void); 
void Accell_Int_Wakeup(void);
/** @} power */


/***************************************
*           API Constants        
***************************************/
#if defined(Accell_Int__PC) || (CY_PSOC4_4200L) 
    /* Drive Modes */
    #define Accell_Int_DRIVE_MODE_BITS        (3)
    #define Accell_Int_DRIVE_MODE_IND_MASK    (0xFFFFFFFFu >> (32 - Accell_Int_DRIVE_MODE_BITS))

    /**
    * \addtogroup group_constants
    * @{
    */
        /** \addtogroup driveMode Drive mode constants
         * \brief Constants to be passed as "mode" parameter in the Accell_Int_SetDriveMode() function.
         *  @{
         */
        #define Accell_Int_DM_ALG_HIZ         (0x00u) /**< \brief High Impedance Analog   */
        #define Accell_Int_DM_DIG_HIZ         (0x01u) /**< \brief High Impedance Digital  */
        #define Accell_Int_DM_RES_UP          (0x02u) /**< \brief Resistive Pull Up       */
        #define Accell_Int_DM_RES_DWN         (0x03u) /**< \brief Resistive Pull Down     */
        #define Accell_Int_DM_OD_LO           (0x04u) /**< \brief Open Drain, Drives Low  */
        #define Accell_Int_DM_OD_HI           (0x05u) /**< \brief Open Drain, Drives High */
        #define Accell_Int_DM_STRONG          (0x06u) /**< \brief Strong Drive            */
        #define Accell_Int_DM_RES_UPDWN       (0x07u) /**< \brief Resistive Pull Up/Down  */
        /** @} driveMode */
    /** @} group_constants */
#endif

/* Digital Port Constants */
#define Accell_Int_MASK               Accell_Int__MASK
#define Accell_Int_SHIFT              Accell_Int__SHIFT
#define Accell_Int_WIDTH              1u

/**
* \addtogroup group_constants
* @{
*/
    /** \addtogroup intrMode Interrupt constants
     * \brief Constants to be passed as "mode" parameter in Accell_Int_SetInterruptMode() function.
     *  @{
     */
        #define Accell_Int_INTR_NONE      ((uint16)(0x0000u)) /**< \brief Disabled             */
        #define Accell_Int_INTR_RISING    ((uint16)(0x5555u)) /**< \brief Rising edge trigger  */
        #define Accell_Int_INTR_FALLING   ((uint16)(0xaaaau)) /**< \brief Falling edge trigger */
        #define Accell_Int_INTR_BOTH      ((uint16)(0xffffu)) /**< \brief Both edge trigger    */
    /** @} intrMode */
/** @} group_constants */

/* SIO LPM definition */
#if defined(Accell_Int__SIO)
    #define Accell_Int_SIO_LPM_MASK       (0x03u)
#endif

/* USBIO definitions */
#if !defined(Accell_Int__PC) && (CY_PSOC4_4200L)
    #define Accell_Int_USBIO_ENABLE               ((uint32)0x80000000u)
    #define Accell_Int_USBIO_DISABLE              ((uint32)(~Accell_Int_USBIO_ENABLE))
    #define Accell_Int_USBIO_SUSPEND_SHIFT        CYFLD_USBDEVv2_USB_SUSPEND__OFFSET
    #define Accell_Int_USBIO_SUSPEND_DEL_SHIFT    CYFLD_USBDEVv2_USB_SUSPEND_DEL__OFFSET
    #define Accell_Int_USBIO_ENTER_SLEEP          ((uint32)((1u << Accell_Int_USBIO_SUSPEND_SHIFT) \
                                                        | (1u << Accell_Int_USBIO_SUSPEND_DEL_SHIFT)))
    #define Accell_Int_USBIO_EXIT_SLEEP_PH1       ((uint32)~((uint32)(1u << Accell_Int_USBIO_SUSPEND_SHIFT)))
    #define Accell_Int_USBIO_EXIT_SLEEP_PH2       ((uint32)~((uint32)(1u << Accell_Int_USBIO_SUSPEND_DEL_SHIFT)))
    #define Accell_Int_USBIO_CR1_OFF              ((uint32)0xfffffffeu)
#endif


/***************************************
*             Registers        
***************************************/
/* Main Port Registers */
#if defined(Accell_Int__PC)
    /* Port Configuration */
    #define Accell_Int_PC                 (* (reg32 *) Accell_Int__PC)
#endif
/* Pin State */
#define Accell_Int_PS                     (* (reg32 *) Accell_Int__PS)
/* Data Register */
#define Accell_Int_DR                     (* (reg32 *) Accell_Int__DR)
/* Input Buffer Disable Override */
#define Accell_Int_INP_DIS                (* (reg32 *) Accell_Int__PC2)

/* Interrupt configuration Registers */
#define Accell_Int_INTCFG                 (* (reg32 *) Accell_Int__INTCFG)
#define Accell_Int_INTSTAT                (* (reg32 *) Accell_Int__INTSTAT)

/* "Interrupt cause" register for Combined Port Interrupt (AllPortInt) in GSRef component */
#if defined (CYREG_GPIO_INTR_CAUSE)
    #define Accell_Int_INTR_CAUSE         (* (reg32 *) CYREG_GPIO_INTR_CAUSE)
#endif

/* SIO register */
#if defined(Accell_Int__SIO)
    #define Accell_Int_SIO_REG            (* (reg32 *) Accell_Int__SIO)
#endif /* (Accell_Int__SIO_CFG) */

/* USBIO registers */
#if !defined(Accell_Int__PC) && (CY_PSOC4_4200L)
    #define Accell_Int_USB_POWER_REG       (* (reg32 *) CYREG_USBDEVv2_USB_POWER_CTRL)
    #define Accell_Int_CR1_REG             (* (reg32 *) CYREG_USBDEVv2_CR1)
    #define Accell_Int_USBIO_CTRL_REG      (* (reg32 *) CYREG_USBDEVv2_USB_USBIO_CTRL)
#endif    
    
    
/***************************************
* The following code is DEPRECATED and 
* must not be used in new designs.
***************************************/
/**
* \addtogroup group_deprecated
* @{
*/
#define Accell_Int_DRIVE_MODE_SHIFT       (0x00u)
#define Accell_Int_DRIVE_MODE_MASK        (0x07u << Accell_Int_DRIVE_MODE_SHIFT)
/** @} deprecated */

#endif /* End Pins Accell_Int_H */


/* [] END OF FILE */
