/*******************************************************************************
* File Name: Kill_Pwr.h  
* Version 2.20
*
* Description:
*  This file contains Pin function prototypes and register defines
*
********************************************************************************
* Copyright 2008-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_Kill_Pwr_H) /* Pins Kill_Pwr_H */
#define CY_PINS_Kill_Pwr_H

#include "cytypes.h"
#include "cyfitter.h"
#include "Kill_Pwr_aliases.h"


/***************************************
*     Data Struct Definitions
***************************************/

/**
* \addtogroup group_structures
* @{
*/
    
/* Structure for sleep mode support */
typedef struct
{
    uint32 pcState; /**< State of the port control register */
    uint32 sioState; /**< State of the SIO configuration */
    uint32 usbState; /**< State of the USBIO regulator */
} Kill_Pwr_BACKUP_STRUCT;

/** @} structures */


/***************************************
*        Function Prototypes             
***************************************/
/**
* \addtogroup group_general
* @{
*/
uint8   Kill_Pwr_Read(void);
void    Kill_Pwr_Write(uint8 value);
uint8   Kill_Pwr_ReadDataReg(void);
#if defined(Kill_Pwr__PC) || (CY_PSOC4_4200L) 
    void    Kill_Pwr_SetDriveMode(uint8 mode);
#endif
void    Kill_Pwr_SetInterruptMode(uint16 position, uint16 mode);
uint8   Kill_Pwr_ClearInterrupt(void);
/** @} general */

/**
* \addtogroup group_power
* @{
*/
void Kill_Pwr_Sleep(void); 
void Kill_Pwr_Wakeup(void);
/** @} power */


/***************************************
*           API Constants        
***************************************/
#if defined(Kill_Pwr__PC) || (CY_PSOC4_4200L) 
    /* Drive Modes */
    #define Kill_Pwr_DRIVE_MODE_BITS        (3)
    #define Kill_Pwr_DRIVE_MODE_IND_MASK    (0xFFFFFFFFu >> (32 - Kill_Pwr_DRIVE_MODE_BITS))

    /**
    * \addtogroup group_constants
    * @{
    */
        /** \addtogroup driveMode Drive mode constants
         * \brief Constants to be passed as "mode" parameter in the Kill_Pwr_SetDriveMode() function.
         *  @{
         */
        #define Kill_Pwr_DM_ALG_HIZ         (0x00u) /**< \brief High Impedance Analog   */
        #define Kill_Pwr_DM_DIG_HIZ         (0x01u) /**< \brief High Impedance Digital  */
        #define Kill_Pwr_DM_RES_UP          (0x02u) /**< \brief Resistive Pull Up       */
        #define Kill_Pwr_DM_RES_DWN         (0x03u) /**< \brief Resistive Pull Down     */
        #define Kill_Pwr_DM_OD_LO           (0x04u) /**< \brief Open Drain, Drives Low  */
        #define Kill_Pwr_DM_OD_HI           (0x05u) /**< \brief Open Drain, Drives High */
        #define Kill_Pwr_DM_STRONG          (0x06u) /**< \brief Strong Drive            */
        #define Kill_Pwr_DM_RES_UPDWN       (0x07u) /**< \brief Resistive Pull Up/Down  */
        /** @} driveMode */
    /** @} group_constants */
#endif

/* Digital Port Constants */
#define Kill_Pwr_MASK               Kill_Pwr__MASK
#define Kill_Pwr_SHIFT              Kill_Pwr__SHIFT
#define Kill_Pwr_WIDTH              1u

/**
* \addtogroup group_constants
* @{
*/
    /** \addtogroup intrMode Interrupt constants
     * \brief Constants to be passed as "mode" parameter in Kill_Pwr_SetInterruptMode() function.
     *  @{
     */
        #define Kill_Pwr_INTR_NONE      ((uint16)(0x0000u)) /**< \brief Disabled             */
        #define Kill_Pwr_INTR_RISING    ((uint16)(0x5555u)) /**< \brief Rising edge trigger  */
        #define Kill_Pwr_INTR_FALLING   ((uint16)(0xaaaau)) /**< \brief Falling edge trigger */
        #define Kill_Pwr_INTR_BOTH      ((uint16)(0xffffu)) /**< \brief Both edge trigger    */
    /** @} intrMode */
/** @} group_constants */

/* SIO LPM definition */
#if defined(Kill_Pwr__SIO)
    #define Kill_Pwr_SIO_LPM_MASK       (0x03u)
#endif

/* USBIO definitions */
#if !defined(Kill_Pwr__PC) && (CY_PSOC4_4200L)
    #define Kill_Pwr_USBIO_ENABLE               ((uint32)0x80000000u)
    #define Kill_Pwr_USBIO_DISABLE              ((uint32)(~Kill_Pwr_USBIO_ENABLE))
    #define Kill_Pwr_USBIO_SUSPEND_SHIFT        CYFLD_USBDEVv2_USB_SUSPEND__OFFSET
    #define Kill_Pwr_USBIO_SUSPEND_DEL_SHIFT    CYFLD_USBDEVv2_USB_SUSPEND_DEL__OFFSET
    #define Kill_Pwr_USBIO_ENTER_SLEEP          ((uint32)((1u << Kill_Pwr_USBIO_SUSPEND_SHIFT) \
                                                        | (1u << Kill_Pwr_USBIO_SUSPEND_DEL_SHIFT)))
    #define Kill_Pwr_USBIO_EXIT_SLEEP_PH1       ((uint32)~((uint32)(1u << Kill_Pwr_USBIO_SUSPEND_SHIFT)))
    #define Kill_Pwr_USBIO_EXIT_SLEEP_PH2       ((uint32)~((uint32)(1u << Kill_Pwr_USBIO_SUSPEND_DEL_SHIFT)))
    #define Kill_Pwr_USBIO_CR1_OFF              ((uint32)0xfffffffeu)
#endif


/***************************************
*             Registers        
***************************************/
/* Main Port Registers */
#if defined(Kill_Pwr__PC)
    /* Port Configuration */
    #define Kill_Pwr_PC                 (* (reg32 *) Kill_Pwr__PC)
#endif
/* Pin State */
#define Kill_Pwr_PS                     (* (reg32 *) Kill_Pwr__PS)
/* Data Register */
#define Kill_Pwr_DR                     (* (reg32 *) Kill_Pwr__DR)
/* Input Buffer Disable Override */
#define Kill_Pwr_INP_DIS                (* (reg32 *) Kill_Pwr__PC2)

/* Interrupt configuration Registers */
#define Kill_Pwr_INTCFG                 (* (reg32 *) Kill_Pwr__INTCFG)
#define Kill_Pwr_INTSTAT                (* (reg32 *) Kill_Pwr__INTSTAT)

/* "Interrupt cause" register for Combined Port Interrupt (AllPortInt) in GSRef component */
#if defined (CYREG_GPIO_INTR_CAUSE)
    #define Kill_Pwr_INTR_CAUSE         (* (reg32 *) CYREG_GPIO_INTR_CAUSE)
#endif

/* SIO register */
#if defined(Kill_Pwr__SIO)
    #define Kill_Pwr_SIO_REG            (* (reg32 *) Kill_Pwr__SIO)
#endif /* (Kill_Pwr__SIO_CFG) */

/* USBIO registers */
#if !defined(Kill_Pwr__PC) && (CY_PSOC4_4200L)
    #define Kill_Pwr_USB_POWER_REG       (* (reg32 *) CYREG_USBDEVv2_USB_POWER_CTRL)
    #define Kill_Pwr_CR1_REG             (* (reg32 *) CYREG_USBDEVv2_CR1)
    #define Kill_Pwr_USBIO_CTRL_REG      (* (reg32 *) CYREG_USBDEVv2_USB_USBIO_CTRL)
#endif    
    
    
/***************************************
* The following code is DEPRECATED and 
* must not be used in new designs.
***************************************/
/**
* \addtogroup group_deprecated
* @{
*/
#define Kill_Pwr_DRIVE_MODE_SHIFT       (0x00u)
#define Kill_Pwr_DRIVE_MODE_MASK        (0x07u << Kill_Pwr_DRIVE_MODE_SHIFT)
/** @} deprecated */

#endif /* End Pins Kill_Pwr_H */


/* [] END OF FILE */
