/*******************************************************************************
* File Name: Vbatt_Samp.h  
* Version 2.20
*
* Description:
*  This file contains Pin function prototypes and register defines
*
********************************************************************************
* Copyright 2008-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_Vbatt_Samp_H) /* Pins Vbatt_Samp_H */
#define CY_PINS_Vbatt_Samp_H

#include "cytypes.h"
#include "cyfitter.h"
#include "Vbatt_Samp_aliases.h"


/***************************************
*     Data Struct Definitions
***************************************/

/**
* \addtogroup group_structures
* @{
*/
    
/* Structure for sleep mode support */
typedef struct
{
    uint32 pcState; /**< State of the port control register */
    uint32 sioState; /**< State of the SIO configuration */
    uint32 usbState; /**< State of the USBIO regulator */
} Vbatt_Samp_BACKUP_STRUCT;

/** @} structures */


/***************************************
*        Function Prototypes             
***************************************/
/**
* \addtogroup group_general
* @{
*/
uint8   Vbatt_Samp_Read(void);
void    Vbatt_Samp_Write(uint8 value);
uint8   Vbatt_Samp_ReadDataReg(void);
#if defined(Vbatt_Samp__PC) || (CY_PSOC4_4200L) 
    void    Vbatt_Samp_SetDriveMode(uint8 mode);
#endif
void    Vbatt_Samp_SetInterruptMode(uint16 position, uint16 mode);
uint8   Vbatt_Samp_ClearInterrupt(void);
/** @} general */

/**
* \addtogroup group_power
* @{
*/
void Vbatt_Samp_Sleep(void); 
void Vbatt_Samp_Wakeup(void);
/** @} power */


/***************************************
*           API Constants        
***************************************/
#if defined(Vbatt_Samp__PC) || (CY_PSOC4_4200L) 
    /* Drive Modes */
    #define Vbatt_Samp_DRIVE_MODE_BITS        (3)
    #define Vbatt_Samp_DRIVE_MODE_IND_MASK    (0xFFFFFFFFu >> (32 - Vbatt_Samp_DRIVE_MODE_BITS))

    /**
    * \addtogroup group_constants
    * @{
    */
        /** \addtogroup driveMode Drive mode constants
         * \brief Constants to be passed as "mode" parameter in the Vbatt_Samp_SetDriveMode() function.
         *  @{
         */
        #define Vbatt_Samp_DM_ALG_HIZ         (0x00u) /**< \brief High Impedance Analog   */
        #define Vbatt_Samp_DM_DIG_HIZ         (0x01u) /**< \brief High Impedance Digital  */
        #define Vbatt_Samp_DM_RES_UP          (0x02u) /**< \brief Resistive Pull Up       */
        #define Vbatt_Samp_DM_RES_DWN         (0x03u) /**< \brief Resistive Pull Down     */
        #define Vbatt_Samp_DM_OD_LO           (0x04u) /**< \brief Open Drain, Drives Low  */
        #define Vbatt_Samp_DM_OD_HI           (0x05u) /**< \brief Open Drain, Drives High */
        #define Vbatt_Samp_DM_STRONG          (0x06u) /**< \brief Strong Drive            */
        #define Vbatt_Samp_DM_RES_UPDWN       (0x07u) /**< \brief Resistive Pull Up/Down  */
        /** @} driveMode */
    /** @} group_constants */
#endif

/* Digital Port Constants */
#define Vbatt_Samp_MASK               Vbatt_Samp__MASK
#define Vbatt_Samp_SHIFT              Vbatt_Samp__SHIFT
#define Vbatt_Samp_WIDTH              1u

/**
* \addtogroup group_constants
* @{
*/
    /** \addtogroup intrMode Interrupt constants
     * \brief Constants to be passed as "mode" parameter in Vbatt_Samp_SetInterruptMode() function.
     *  @{
     */
        #define Vbatt_Samp_INTR_NONE      ((uint16)(0x0000u)) /**< \brief Disabled             */
        #define Vbatt_Samp_INTR_RISING    ((uint16)(0x5555u)) /**< \brief Rising edge trigger  */
        #define Vbatt_Samp_INTR_FALLING   ((uint16)(0xaaaau)) /**< \brief Falling edge trigger */
        #define Vbatt_Samp_INTR_BOTH      ((uint16)(0xffffu)) /**< \brief Both edge trigger    */
    /** @} intrMode */
/** @} group_constants */

/* SIO LPM definition */
#if defined(Vbatt_Samp__SIO)
    #define Vbatt_Samp_SIO_LPM_MASK       (0x03u)
#endif

/* USBIO definitions */
#if !defined(Vbatt_Samp__PC) && (CY_PSOC4_4200L)
    #define Vbatt_Samp_USBIO_ENABLE               ((uint32)0x80000000u)
    #define Vbatt_Samp_USBIO_DISABLE              ((uint32)(~Vbatt_Samp_USBIO_ENABLE))
    #define Vbatt_Samp_USBIO_SUSPEND_SHIFT        CYFLD_USBDEVv2_USB_SUSPEND__OFFSET
    #define Vbatt_Samp_USBIO_SUSPEND_DEL_SHIFT    CYFLD_USBDEVv2_USB_SUSPEND_DEL__OFFSET
    #define Vbatt_Samp_USBIO_ENTER_SLEEP          ((uint32)((1u << Vbatt_Samp_USBIO_SUSPEND_SHIFT) \
                                                        | (1u << Vbatt_Samp_USBIO_SUSPEND_DEL_SHIFT)))
    #define Vbatt_Samp_USBIO_EXIT_SLEEP_PH1       ((uint32)~((uint32)(1u << Vbatt_Samp_USBIO_SUSPEND_SHIFT)))
    #define Vbatt_Samp_USBIO_EXIT_SLEEP_PH2       ((uint32)~((uint32)(1u << Vbatt_Samp_USBIO_SUSPEND_DEL_SHIFT)))
    #define Vbatt_Samp_USBIO_CR1_OFF              ((uint32)0xfffffffeu)
#endif


/***************************************
*             Registers        
***************************************/
/* Main Port Registers */
#if defined(Vbatt_Samp__PC)
    /* Port Configuration */
    #define Vbatt_Samp_PC                 (* (reg32 *) Vbatt_Samp__PC)
#endif
/* Pin State */
#define Vbatt_Samp_PS                     (* (reg32 *) Vbatt_Samp__PS)
/* Data Register */
#define Vbatt_Samp_DR                     (* (reg32 *) Vbatt_Samp__DR)
/* Input Buffer Disable Override */
#define Vbatt_Samp_INP_DIS                (* (reg32 *) Vbatt_Samp__PC2)

/* Interrupt configuration Registers */
#define Vbatt_Samp_INTCFG                 (* (reg32 *) Vbatt_Samp__INTCFG)
#define Vbatt_Samp_INTSTAT                (* (reg32 *) Vbatt_Samp__INTSTAT)

/* "Interrupt cause" register for Combined Port Interrupt (AllPortInt) in GSRef component */
#if defined (CYREG_GPIO_INTR_CAUSE)
    #define Vbatt_Samp_INTR_CAUSE         (* (reg32 *) CYREG_GPIO_INTR_CAUSE)
#endif

/* SIO register */
#if defined(Vbatt_Samp__SIO)
    #define Vbatt_Samp_SIO_REG            (* (reg32 *) Vbatt_Samp__SIO)
#endif /* (Vbatt_Samp__SIO_CFG) */

/* USBIO registers */
#if !defined(Vbatt_Samp__PC) && (CY_PSOC4_4200L)
    #define Vbatt_Samp_USB_POWER_REG       (* (reg32 *) CYREG_USBDEVv2_USB_POWER_CTRL)
    #define Vbatt_Samp_CR1_REG             (* (reg32 *) CYREG_USBDEVv2_CR1)
    #define Vbatt_Samp_USBIO_CTRL_REG      (* (reg32 *) CYREG_USBDEVv2_USB_USBIO_CTRL)
#endif    
    
    
/***************************************
* The following code is DEPRECATED and 
* must not be used in new designs.
***************************************/
/**
* \addtogroup group_deprecated
* @{
*/
#define Vbatt_Samp_DRIVE_MODE_SHIFT       (0x00u)
#define Vbatt_Samp_DRIVE_MODE_MASK        (0x07u << Vbatt_Samp_DRIVE_MODE_SHIFT)
/** @} deprecated */

#endif /* End Pins Vbatt_Samp_H */


/* [] END OF FILE */
