/*******************************************************************************
* File Name: Vbatt_Samp.c  
* Version 2.20
*
* Description:
*  This file contains APIs to set up the Pins component for low power modes.
*
* Note:
*
********************************************************************************
* Copyright 2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#include "cytypes.h"
#include "Vbatt_Samp.h"

static Vbatt_Samp_BACKUP_STRUCT  Vbatt_Samp_backup = {0u, 0u, 0u};


/*******************************************************************************
* Function Name: Vbatt_Samp_Sleep
****************************************************************************//**
*
* \brief Stores the pin configuration and prepares the pin for entering chip 
*  deep-sleep/hibernate modes. This function applies only to SIO and USBIO pins.
*  It should not be called for GPIO or GPIO_OVT pins.
*
* <b>Note</b> This function is available in PSoC 4 only.
*
* \return 
*  None 
*  
* \sideeffect
*  For SIO pins, this function configures the pin input threshold to CMOS and
*  drive level to Vddio. This is needed for SIO pins when in device 
*  deep-sleep/hibernate modes.
*
* \funcusage
*  \snippet Vbatt_Samp_SUT.c usage_Vbatt_Samp_Sleep_Wakeup
*******************************************************************************/
void Vbatt_Samp_Sleep(void)
{
    #if defined(Vbatt_Samp__PC)
        Vbatt_Samp_backup.pcState = Vbatt_Samp_PC;
    #else
        #if (CY_PSOC4_4200L)
            /* Save the regulator state and put the PHY into suspend mode */
            Vbatt_Samp_backup.usbState = Vbatt_Samp_CR1_REG;
            Vbatt_Samp_USB_POWER_REG |= Vbatt_Samp_USBIO_ENTER_SLEEP;
            Vbatt_Samp_CR1_REG &= Vbatt_Samp_USBIO_CR1_OFF;
        #endif
    #endif
    #if defined(CYIPBLOCK_m0s8ioss_VERSION) && defined(Vbatt_Samp__SIO)
        Vbatt_Samp_backup.sioState = Vbatt_Samp_SIO_REG;
        /* SIO requires unregulated output buffer and single ended input buffer */
        Vbatt_Samp_SIO_REG &= (uint32)(~Vbatt_Samp_SIO_LPM_MASK);
    #endif  
}


/*******************************************************************************
* Function Name: Vbatt_Samp_Wakeup
****************************************************************************//**
*
* \brief Restores the pin configuration that was saved during Pin_Sleep(). This 
* function applies only to SIO and USBIO pins. It should not be called for
* GPIO or GPIO_OVT pins.
*
* For USBIO pins, the wakeup is only triggered for falling edge interrupts.
*
* <b>Note</b> This function is available in PSoC 4 only.
*
* \return 
*  None
*  
* \funcusage
*  Refer to Vbatt_Samp_Sleep() for an example usage.
*******************************************************************************/
void Vbatt_Samp_Wakeup(void)
{
    #if defined(Vbatt_Samp__PC)
        Vbatt_Samp_PC = Vbatt_Samp_backup.pcState;
    #else
        #if (CY_PSOC4_4200L)
            /* Restore the regulator state and come out of suspend mode */
            Vbatt_Samp_USB_POWER_REG &= Vbatt_Samp_USBIO_EXIT_SLEEP_PH1;
            Vbatt_Samp_CR1_REG = Vbatt_Samp_backup.usbState;
            Vbatt_Samp_USB_POWER_REG &= Vbatt_Samp_USBIO_EXIT_SLEEP_PH2;
        #endif
    #endif
    #if defined(CYIPBLOCK_m0s8ioss_VERSION) && defined(Vbatt_Samp__SIO)
        Vbatt_Samp_SIO_REG = Vbatt_Samp_backup.sioState;
    #endif
}


/* [] END OF FILE */
