// ++++++++++++++++++++++++
// Zansors Garfield Project
// Global Variables File
// 7/13/2017 by Ted Mawson
// MB Electronic Design

#include <project.h>
#include <slld.h> // for BYTE definition
#include "lis3dh_driver.h"

#define accelOffset  10 //set value for PWM_R

enum states 
{
    startup, 
    testing, 
    standby, 
    recording, 
    sleeping, 
    faulted
};
enum states sys_state; // defines variable sys_state that contains integers and is preset to "startup" = 0

typedef struct{
    BYTE lightsOn:1;    // allows "lights off" running 
    BYTE AdminMode:1;   // administrator mode - used to protect dangerous functions
    BYTE SaveData:1;    // a bank of data is ready for saving to flash
    BYTE bit3:1;
    BYTE bit4:1;
    BYTE bit5:1;
    BYTE bit6:1;
    BYTE bit7:1;
} BitField;
typedef union{
    BitField asBits;
    BYTE asByte;
} BitByte;

extern BitByte tmFlags;

extern AxesRaw_t data;
extern uint8 response;
extern uint8 SW1_Timer;
extern uint8 ticker_100mS;
extern unsigned short  fast_ticker;
extern char ShutDown;
extern char Hundred_mS_tick;
extern char Test_Vbatt_flag;
extern char SCB_1_IRQtriggered;
extern uint8 datacount;
extern uint8 audioIndx;
extern uint8 accelIndx;
extern uint8 counter25;             // used to get Accel data every 25 audioIndx's
extern uint16 recordCounter;        // counts seconds of recording time
extern uint16 rawAudio[2][250];     // 2-bank array holding 250 x 12-bit audio samples per bank
extern int16 rawAccel[3][10];      // 3-axes array holding 10 x 12 bit accelerometer samples per axis
