/* ========================================
 *
 * Copyright Zansors, 2017
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF XXXXXXX LLC.
 * 
 * Ted Mawson - MBEDS.us 2017
 * 7-19-17  Version reading battery voltage and running basic state machine
 * 7-24-17  Version with NOR SPI code from http://www.cypress.com/forum/nor-flash/requesting-example-code-nor-flashs25fl512s-interfacing-spi-any-mcu
 * 7-25-17  Added UART recieve with interrupt - commands with value parameter e.g R123 can be entered
 *          Code for SLLD device S25FL512S is added but not yet tested - plan to test with command structure
 * 7-28-17  Expanded command parser system to accept 2 letters followed by 18-character number eg RR123
 * 8-8-17   Working SPI for the LIS2DH, needs more work to check that configuration of accelerometer is correct
 * 8-10-17  Working SPI for the S25FL512S but only tested for return of the Flash ID register
 * 8-11-17  Working Flash read, write enable, write, sector erase
 * 8-16-17  Changed parameters and big-endianness for Accelerometer reads, now getting 'sensible' data returned
 * 8-17-17  Added BitFields, rawAudio[2][250], and moved enum sys_state to GlobalVars.h
 *          Implemented 'R'ecording of 250 Hz audio to rawAudio[2][250] array
 *          Implemented BitByte tmFlags system to save memory
 * 8-18-17  Added active bank selection to rawAudio by masking last bit of 1S recordCounter
 * ========================================
*/
#include <project.h>
#include "GlobalVars.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <slld_targetspecific.h>
#include <slld.h>
#include <slld_hal.h>
#include <stdlib.h> //atoi
#include <stdio.h>  //sprintf
#include "myUART.h" //UART communication
#include "lis3dh_driver.h" // TM ST-provided driver for lis2/3dh

// Global Variable Definitions
char strMsg1[64];       //output UART buffer
//buffer to hold application settings
//typedef struct TParamBuffer{
//    uint16 R, G, B; //compare settings for PWM_R, PWM_G, PWM_B
//} ParamBuffer; //settings
//volatile ParamBuffer PB;     

// each control command has a structure defined by TRxBuffer in myUART.h:
// CMD1 (1byte) | CMD2 (1byte)| value_string (up to 18 bytes long) | separator (\r\n)
// example of valid commands (each dollowed by either LF, CR or both):
// 'R255' - set channel A to max value
// 'G0'   - set channel G to zero
// 'X'    - set all channels to max value
// 'Z'    - set all channels to Zero

//=======================================
//         Forward declarations  
//=======================================
void ProcessCommandMsg(void);      // declaration of Process received command (command parser)
void RefreshPWM(void);             // refresh all PWM values
int  isNumeric(const char * s);    // declaration of check if string is a number
// void programdata(BYTE, ADDRESS, uint8); // declaration of programdata function

//define input commands-> 

BYTE Read_SR1Val();
BYTE Read_SR2Val();
void Read_CRVal();
void readandprintdata(BYTE numtoread, ADDRESS sysaddr);
void startRecording(void);
void programdata(BYTE numtoprogram, ADDRESS sysaddr, uint8 strData);
void Erasedata(ADDRESS sysaddr);
void Read_PPBVal(ADDRESS sysaddr);
void Read_DYBVal(ADDRESS sysaddr);
void Read_ASPVal();

uint8 SW1_Timer = 0;
uint8 ticker_100mS = 0;
unsigned short fast_ticker = 25;
char ShutDown = 0;
char Hundred_mS_tick = 0;
char Test_Vbatt_flag = 1;
char SCB_1_IRQtriggered = 0;
char *strrev(char *str);
char *xitoa(int v, char *buff, unsigned int radix_base);

//enum states {startup, testing, recording, sleeping, faulted};
//enum states sys_state; // defines variable sys_state that contains integers and is preset to "startup" = 0

// TM LIS3DH variables
uint8 response;
uint8 valueX;
AxesRaw_t data;

//#define CYP_DEBUG

unsigned long base_addr_g=0;
BYTE wrBuffer[200], buffer[200];
uint8  audioIndx = 0;
uint8 datacount;
uint8 accelIndx;
uint8 counter25;
uint16 rawAudio[2][250];    // 2-bank array holding 250 x 12-bit audio samples per bank
int16 rawAccel[3][10];     // 3-axes array holding 10 x 12 bit accelerometer samples per axis
uint16 recordCounter = 0;   // second counter used in recording
BitByte tmFlags;    // B0 = lightsOn
                    // B1 = AdminMode
                    // B2 = SaveData

void Initialize(void)
{
	CyGlobalIntEnable;

    Kill_Pwr_Write(0x00);  // clear Kill_Pwr to hold system on
    Samp_Vbatt_Write(0);
    tmFlags.asBits.lightsOn = 1;
    NOR_CS_Write(1);        // Set SPI CS# lines high - all SPI access in this code has manual control of the CS# lines
    ACC_CS_Write(1);
    
	Rx_Int_StartEx(MyRxInt);//start Rx interrupt 
    
    SCB_1_Start();      // start up SCB_1 which is set to UART mode
    	
    SCB_1_UartPutString("\r\nPWM + UART example\r\n");
    SCB_1_UartPutString("type a command, e.g. R255 >\r\n");    
    // Code to toggle LED_2 is added to Timer_ISR.c
    
    // Starting Modules for Setup
    sys_state = startup;
    isr_1_Start();   
    TCPWM_1_Start();
    SPI_Start();        // init and enable up SCB_2 which is set to SPI master mode
    ADC_Start();
   
     
//    PWM_R_Start(); PWM_G_Start(); PWM_B_Start();
//    PB.R = PB.G = PB.B = 0; 
//    RefreshPWM();
    
}

BYTE wrBuffer[200], buffer[200];  // buffer for flash write and read
BYTE stval1=0x00, crval = 0x00, stval2=0x00;
BYTE srval,srval2, numtoread, i, numtoprogram;

//   ADDRESS sysaddr1 = 0x0000; 
ADDRESS sysaddr = 0x80400; // Sector2 Page 3; sector size 256KB; page size 512 Bytes
//  ADDRESS sysaddr1 = 0xC0400; // Sector3 Page 3; sector size 256KB; page size 512 Bytes
SLLD_STATUS flasHresult;

int main()
{
    Initialize();


    char buffy[20];
    char tempTed;
    uint_fast16_t Vbatt_mV;  // not sure if we need uint_fast16_t here but it works
    
    
    
    for(;;) // forever loop
    {
        
        if(IsCharReady()) // test if Rx buffer not empty (routine is in myUART.c)
        {
            if (GetRxStr())   // GetRxStr (routine is in myUART.c) will test for terminators and extract any command message (non-blocking)
            {
                ProcessCommandMsg(); // Command will be processed if there is one
            }
        }               
	
        /* main code loop */
        CyDelay(500);
        if (tmFlags.asBits.lightsOn) LED_1_Write( ~ LED_1_Read() );  // toggle LED1 (Red)
        if (SW1_Detect_Read() == (0x00))  // detects if SW1 is pressed
        {
//          SCB_1_UartPutChar('a');
            SCB_1_UartPutString("It is possible to send out really long strings like this one without crashing the UART buffer\n\r");

        }

        if (Test_Vbatt_flag == 1) {
            ADC_EnableInjection();
            ADC_StartConvert();
            Test_Vbatt_flag = 0;
//      Send Vbatt_mV out to UART
            ADC_IsEndConversion(ADC_WAIT_FOR_RESULT);
            // CyDelayUs(250);
            Vbatt_mV = (ADC_GetResult16(1) * 2.439); // note, this multiplier may change for other boards
            // Samp_Vbatt_Write(0);                // switch off sampling for ADC
            sprintf(strMsg1, "Vbatt = %d mV \n\r", Vbatt_mV); SCB_1_UartPutString(strMsg1);
            // xitoa(Vbatt_mV, buffy, 10);
            // SCB_1_UartPutString(buffy);
            // SCB_1_UartPutCRLF(0x20);
            // if (Vbatt_mV <= 2650) ShutDown = 2;    // low battery shutdown voltage = 2.65 volts
        }
        
        response = LIS3DH_GetAccAxesRaw(&data); // TM read and print Raw Accel data
        if(response==1){
            //print data values
            sprintf(strMsg1, "Xx=%6d Yy=%6d Zz=%6d \r\n", (data.AXIS_X >> 6), (data.AXIS_Y >> 6), (data.AXIS_Z >> 6) );
            SCB_1_UartPutString(strMsg1);
        // TM WTF???    old_position = position;
        }
        sprintf(strMsg1, "X=%6d Y=%6d Z=%6d \r\n", (rawAccel[0][0]), (rawAccel[1][0]), (rawAccel[2][0]));
        SCB_1_UartPutString(strMsg1);
        // TM - Code to read and print the SPI RX character buffer size
        datacount = SPI_SpiUartGetRxBufferSize();
        sprintf(strMsg1,"%d ", datacount); SCB_1_UartPutString(strMsg1);
        sprintf(strMsg1,"%d ", rawAudio[0][0]); SCB_1_UartPutString(strMsg1);
        sprintf(strMsg1,"%d ", rawAudio[1][200]); SCB_1_UartPutString(strMsg1);
        sprintf(strMsg1,"%d ", recordCounter); SCB_1_UartPutString(strMsg1);
        
//        xitoa(datacount, buffy, 10);
//        SCB_1_UartPutString(buffy);
//        SCB_1_UartPutChar(' ');
        
        // TM this code is run if a character has been received by the UART - the SCB_1_IRQtriggered flag is set in SCB_1_SCB_IRQ.c ISR
        if (SCB_1_IRQtriggered == 1) {
            tempTed = SCB_1_UartGetByte();
            SCB_1_UartPutChar(tempTed);
            SCB_1_UartPutCRLF(0x20);
            SCB_1_IRQtriggered = 0;
        }
        

        
// +++++++++++++++ SHUTDOWN ++++++++++++++++++++++++++++++
// following section handles shutdown only - if ShutDown code > 0 code will command a shut down) by:
//  a.  SW1 pressed > 2 Sec - handled in ISR = code 1
//  b.  Vbatt_mV going lower than set figure = code 2
        while (ShutDown) {                      // we will be trapped in this loop until... 
            CyGlobalIntDisable;                 // turn off interrupts or we'll clear ShutDown when SW1 is released
            LED_2_Write(0x00);                  // turn off LED 2
            LED_1_Write( ~ LED_1_Read() );
            SCB_1_UartPutString("Auto Shut Down code = ");
            xitoa(ShutDown, buffy, 10);
            SCB_1_UartPutString(buffy);
            SCB_1_UartPutCRLF(0x20);
            CyDelay(100);
            
            // graceful shutdown code goes here - things like finishing save to Flash etc
            if (SW1_Detect_Read() != (0x00)) {  // ...SW1 is released - pressed = low with WPU otherwise
                LED_1_Write(0x00);
                Kill_Pwr_Write(0x01);    // set Kill_Pwr to turn system off
                CyDelay(5000);           // wait here for power to die
                
            }
        }
    }
}
// Number Conversion Functions
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++
// integer to string, handles up to base 16
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++
// SEE... https://stackoverflow.com/questions/9994742/want-to-convert-integer-to-string-without-itoa-function

char *strrev(char *str){
    char c, *front, *back;

    if(!str || !*str)
        return str;
    for(front=str,back=str+strlen(str)-1;front < back;front++,back--){
        c=*front;*front=*back;*back=c;
    }
    return str;
}
// TM revised xitoa converts integer to string 
// call like this.. xitoa(Vbatt_mV, buffy, 10); where the definitions are
//                  char buffy[20]; // must be big enough to hold the conversion
//                  uint_fast16_t Vbatt_mV; // is this needed to be uint16???
//                  and '10' is the number base for conversion
char *xitoa(int v, char *buff, unsigned int radix_base){
    static char table[] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    char *p=buff;
    unsigned int n = (v < 0 && radix_base == 10)? -v : (unsigned int) v;
    while(n >= radix_base){
        *p ++= table[n%radix_base];
        n/=radix_base;
    }
    *p++=table[n];
    if(v < 0 && radix_base == 10) *p++='-';
    *p='\0';
    return strrev(buff);
}
/*
 // Converts a floating point number to string.
void ftoa(float n, char *res, int afterpoint)
{
    // Extract integer part
    int ipart = (int)n;
 
    // Extract floating part
    float fpart = n - (float)ipart;
 
    // convert integer part to string
    int i = intToStr(ipart, res, 0);
 
    // check for display option after point
    if (afterpoint != 0)
    {
        res[i] = '.';  // add dot
 
        // Get the value of fraction part upto given no.
        // of points after dot. The third parameter is needed
        // to handle cases like 233.007
        fpart = fpart * pow(10, afterpoint);
 
        intToStr((int)fpart, res + i + 1, afterpoint);
    } 
} */
//===========================================================================
// Process UART Receive Buffer content: RB.RxStr = RB.cmd1 + RB.cmd2 + RB.valstr
// Processes commands like RR1234 after they are tyoped and [Enter] is pressed
//===========================================================================

void ProcessCommandMsg(void)
{    
    // check received message for any valid command and execute it if necessary or report old value
    // if command not recognized, then report error (!)
    // todo: current version does not check for valid input range

    // ############### R COMMANDS ###################    
    if  (RB.cmd1 == 'R')//command 'R' received..
    {
        if (RB.cmd2 == 'S')     // RS Record Start command
        {
            startRecording();
            SCB_1_UartPutString("Recording Started\n\r");
        }
        if (RB.cmd2 == 'E')     // RE Record End command
        {
            sys_state = standby;
            SCB_1_UartPutString("Recording Ended\n\r");
        }

    }
    // ############### F COMMANDS ###################
    else if (RB.cmd1 == 'F')    // command 'F' received - 'F' commands are for flash
    {
        if (RB.cmd2 == 'A')     // FA command to Allow write to flash
        {
            slld_WRENCmd();     // Flash Write Enable - needed before a write will work
            CyDelay(10);
            SCB_1_UartPutString("Flash Write is Now Enabled\n\r");
        }
        if (RB.cmd2 == 'E')     // FE command to Erase flash sector
        {
            Erasedata(sysaddr); // includes 500 mS delay
        }
        if (RB.cmd2 == 'I')
        {
               numtoread = 6;
               //Read device and manufacturer ID to verify the device
                slld_RDIDCmd(buffer, numtoread);
                sprintf(strMsg1, "Flash ID Register = %02X:%02X:%02X:%02X:%02X \n\r", buffer[0], buffer[1], buffer[2],buffer[4],buffer[5]);
                SCB_1_UartPutString(strMsg1);
        }
        if (RB.cmd2 == 'R') // FR command - read test data from sysaddress specified at top
        {
            numtoread = 15;
            readandprintdata(numtoread, sysaddr); // data will be printed in hex
        }
        if (RB.cmd2 == 'S') // FS command - read Flash Status Registers srval and srval2
        {
            srval = Read_SR1Val();
            sprintf(strMsg1, "Flash Status Register 1 = 0x%02X \n\r)", srval); SCB_1_UartPutString(strMsg1);
            srval2 = Read_SR2Val();
            sprintf(strMsg1, "Flash Status Register 2 = 0x%02X\n\r)", srval2); SCB_1_UartPutString(strMsg1);
        }
        if (RB.cmd2 == 'W') // FW command - write test data to sysaddress specified at top
        {
            numtoprogram = 12;
            programdata(numtoprogram, sysaddr, 15); // put 12 x 0xF into the address
            
        }
    }
    // ############### G COMMANDS ###################
    else if (RB.cmd1 == 'G')//command 'G' received..
    {
        //if (isNumeric(RB.valstr)) PB.G = atoi(RB.valstr);//if valid number set new value, else report old 
        //sprintf(strMsg1,"G=%d\r\n", PB.G); SCB_1_UartPutString(strMsg1);//echo command and value
        SCB_1_UartPutString("G Pressed\n\r");
//        PWM_G_WriteCompare(PB.G);
    }
    // ############### B COMMANDS ###################
    else if (RB.cmd1 == 'B')//command 'B' received..
    {
        SCB_1_UartPutString("B Pressed\n\r");
        //if (strlen(RB.valstr) > 0) PB.B = atoi(RB.valstr);//set new value, else report old 
        // sprintf(strMsg1,"B=%d\r\n", PB.B); SCB_1_UartPutString(strMsg1);//echo command and value
//        PWM_B_WriteCompare(PB.B);
    }
    // ############### X COMMANDS ###################
    else if (RB.cmd1 == 'X')//command 'X' received..
    {
        sprintf(strMsg1,"X%s\r\n", RB.valstr); SCB_1_UartPutString(strMsg1);//echo command and value
//        PB.R = PB.G = PB.B = MaxVal;
        RefreshPWM(); // set all to max value
    }
    // ############### Z COMMANDS ###################
    else if (RB.cmd1 == 'Z')//command 'Z' received..
    {
        sprintf(strMsg1,"Z%s\r\n", RB.valstr); SCB_1_UartPutString(strMsg1);//echo command and value
//        PB.R = PB.G = PB.B = 0;
//        RefreshPWM(); // turn off all 
        
    }
    // ############### T COMMANDS ###################
    else if (RB.cmd1 == 'T') // command 'T' received
    {
        response = LIS3DH_SetODR(LIS3DH_ODR_10Hz);
        // sprintf(strMsg1,"T response = %u\r\n", response); SCB_1_UartPutString(strMsg1);
        if(response==1){
            sprintf(strMsg1,"\n\rSET_ODR_OK    \n\r"); SCB_1_UartPutString(strMsg1);
        }
    }
    else if (RB.cmd1 == 'L') // command 'L' lights
    {
        tmFlags.asBits.lightsOn = ( ~ tmFlags.asBits.lightsOn );
        if (!tmFlags.asBits.lightsOn){
            LED_1_Write(0);
            LED_2_Write(0);
            SCB_1_UartPutString("LEDs OFF\n\r");
        }
        else
        {
            SCB_1_UartPutString("LEDs ON\n\r");
        }
    }
        
    // ############### M COMMANDS ###################
    else if (RB.cmd1 == 'M') // command 'M' received
    {
        // Set Output Data Rate (ODR) - CTRL_REG1
        response = LIS3DH_SetODR(LIS3DH_ODR_10Hz);
        // sprintf(strMsg1,"T response = %u\r\n", response); SCB_1_UartPutString(strMsg1);
        if(response==1){
            sprintf(strMsg1,"\n\rSET_ODR_OK    \n\r"); SCB_1_UartPutString(strMsg1);
        }
        // Set High Pass Filter (HPF) Mode - CTRL_REG2
        response = LIS3DH_SetHPFMode(LIS3DH_HPM_NORMAL_MODE);
        if(response==1){
            sprintf(strMsg1,"\n\rSET_HPF_OK    \n\r"); SCB_1_UartPutString(strMsg1);
        }
        // Set Interrupt Mode
        response = LIS3DH_SetInt1Pin(LIS3DH_CLICK_ON_PIN_INT1_DISABLE | LIS3DH_I1_INT1_ON_PIN_INT1_ENABLE |              
                    LIS3DH_I1_INT2_ON_PIN_INT1_DISABLE | LIS3DH_I1_DRDY1_ON_INT1_ENABLE | LIS3DH_I1_DRDY2_ON_INT1_DISABLE |
                    LIS3DH_WTM_ON_INT1_DISABLE | LIS3DH_INT1_OVERRUN_DISABLE   );
        if(response==1){
            sprintf(strMsg1,"\n\rSET_Interrupts_OK    \n\r"); SCB_1_UartPutString(strMsg1);
        }
        // Set FIFO watermark level
        response = LIS3DH_SetWaterMark(1); // Set watermark to 1
        if(response==1){
            sprintf(strMsg1,"\n\rSET_FIFO_WtrMk_OK    \n\r"); SCB_1_UartPutString(strMsg1);
        }
        // Set FIFO mode - CTRL_REG? also enables FIFO? (TM thinks it does)
        response = LIS3DH_FIFOModeEnable(LIS3DH_FIFO_DISABLE); // (LIS3DH_FIFO_MODE);
        if(response==1){
            sprintf(strMsg1,"\n\rSET_FIFO_Mode_OK    \n\r"); SCB_1_UartPutString(strMsg1);
        }
        // 
        response = LIS3DH_SetBLE(LIS3DH_BLE_LSB); // _LSB or _MSB ??? TM pretty sure it's LSB
        if(response==1){
            sprintf(strMsg1,"\n\rSET_BLE_Mode_OK    \n\r"); SCB_1_UartPutString(strMsg1);
        }
        
        // Set mode
        response = LIS3DH_SetMode(LIS3DH_LOW_POWER);
        sprintf(strMsg1,"M response = %u\r\n", response); SCB_1_UartPutString(strMsg1);
        if(response==1){
            sprintf(strMsg1,"SET_MODE_OK    \n\r"); SCB_1_UartPutString(strMsg1);
        }
        // Set Fullscale to be +- 2g
        response = LIS3DH_SetFullScale(LIS3DH_FULLSCALE_2);
        if(response==1){
            sprintf(strMsg1,"SET_FULLSCALE_OK    \n\r"); SCB_1_UartPutString(strMsg1);
        }
        // Set axis enable
        //set axis Enable
        response = LIS3DH_SetAxis(LIS3DH_X_ENABLE | LIS3DH_Y_ENABLE | LIS3DH_Z_ENABLE);
        if(response==1){
            sprintf(strMsg1,"SET_AXIS_OK    \n\r"); SCB_1_UartPutString(strMsg1);
        }
        // xxxx
    }
    // ############### W COMMANDS ###################
    else if (RB.cmd1 == 'W') // command 'W' received
    {
        response = LIS3DH_GetWHO_AM_I(&valueX);
        if(response==1){
            sprintf(strMsg1,"WhoAmI Value = 0x%02X\n\r", valueX); SCB_1_UartPutString(strMsg1);
        }
    }
    // ############### UNRECOGNIZED COMMANDS ###################
    else //default catch 'else' = command unrecognized - echo unrecognized command
    {
        sprintf(strMsg1,"Command unrecognized %s\r\n", RB.RxStr); SCB_1_UartPutString(strMsg1);
    }
  
}

//===========================================================================
// Update all PWMs values
//===========================================================================

void RefreshPWM()
{
//    PWM_R_WriteCompare(PB.R);
//    PWM_G_WriteCompare(PB.G);
//    PWM_B_WriteCompare(PB.B);
}

//===========================================================================
// Check that string represents a number
// function does not check bounds, and input string must be trimmed
//
// URL: 
// http://rosettacode.org/wiki/Determine_if_a_string_is_numeric#C
//===========================================================================
// todo: check input range
int isNumeric (const char * s)
{
    if (s == NULL || *s == '\0' || isspace(*s))
      return 0;
    char * p;
    strtod (s, &p);
    return *p == '\0';
}
/*
* Read and print SR1 value
*/
BYTE Read_SR1Val()
{
    BYTE srval=0;
    static int count = 0;
    slld_RDSRCmd(&srval);
    count++;
    return srval;
}

/*
* Read and print SR2 value
*/
BYTE Read_SR2Val()
{
    BYTE srval2=0;
    static int count = 0;
    slld_RDSRCmd(&srval2);
    count++;
    return srval2;
}
void startRecording()   // ### TM we could add a success / failure return
{
    if (!(sys_state == recording)) {  // don't allow recording to start if it's already running
        ADC_StartConvert();         // start a new conversion on the ADC input so that's it's ready as the first element
        audioIndx = 0;              // reset index
        recordCounter = 0;          // and 1S counter
        counter25 = accelOffset;    // and seed counter25 (used to get Accel data every 25 audioIndx's) but starting at an offset 10?
        sys_state = recording;      // put this last as we don't want interrupt processing before the basic paramters have been set
    }
}
/*
* Read and print data as hexadecimal with : separator
*/
void readandprintdata(BYTE numtoread, ADDRESS sysaddr)
{
    BYTE i,j;
    static char table[] = "0123456789ABCDEF";
    sprintf(strMsg1,"Reading %d data locations, start address %lu\n\r", numtoread, sysaddr); SCB_1_UartPutString(strMsg1);
    
    slld_Fast_Read_4BCmd(sysaddr,buffer,numtoread);
    sprintf(strMsg1,"Printing data read from address %lu\n\r", sysaddr); SCB_1_UartPutString(strMsg1);
    
/*    for(i=1;i<(numtoread+1);i++)
    {
        sprintf(strMsg1,"%02X:", buffer[i-1]); SCB_1_UartPutString(strMsg1);
        if((i!=0)&&(i%10)==0)
            sprintf(strMsg1,"\n\r"); SCB_1_UartPutString(strMsg1);
    } */
    j = 0;
    for(i=0; i < numtoread; i++)
    {
        strMsg1[j++]=table[(buffer[i] >> 4)];
        strMsg1[j++]=table[(buffer[i] & 0x0F)];
        strMsg1[j++]= ':';
    }
    strMsg1[j-1] = 0x0D; // replace last ':' char with CR
    strMsg1[j]   = 0x0A; // add LF
    strMsg1[j+1] = 0x00; // make last char terminating null
    SCB_1_UartPutString(strMsg1);
    return;
}
/*
* Program data
*/
void programdata(BYTE numtoprogram, ADDRESS sysaddr, uint8 strData)
{
    BYTE i;
    sprintf(strMsg1,"Programming %d data locations, start address %lu\n\r", numtoprogram, sysaddr); SCB_1_UartPutString(strMsg1);
    //Fill Write buffer
    for(i=0; i < numtoprogram; i++)
    {
        wrBuffer[i]=strData;
        strData++;
    }
    flasHresult = slld_PPCmd(sysaddr, wrBuffer, numtoprogram);
    while(1)
    {
        if(!(Read_SR1Val()&0x01)) // TM not sure what this is doing???
            break;
    }
    CyDelay(1); // 1 mS delay to allow page write
    sprintf(strMsg1, "WriteResultStatus = %u \n\r", flasHresult); SCB_1_UartPutString(strMsg1); // was %d ???
    return;
}
void Erasedata(ADDRESS sysaddr)
{
    BYTE i;
    BYTE* devstatus;
    slld_SEOp(sysaddr, &devstatus);
    SCB_1_UartPutString("Please wait - Erasing sector ");
    for(i=0; i < 10 ; i++)
    {
        CyDelay(50);  // 10 x 50 mS delay to allow sector erase
        SCB_1_UartPutChar('.');
    }
    sprintf(strMsg1, "\n\rSectorEraseResult = 0x%02X \n\r", devstatus); SCB_1_UartPutString(strMsg1); // was %d ???
}
/* [] END OF FILE */
