/* ========================================
 *
 * Copyright Zansors LLC, 2017
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF ZANSORS LLC.
 * 
 * Ted Mawson - MBEDS.us 2017
 * 7-28-17  simpe version compiling and performing as expected
 * based on code from http://www.cypress.com/?app=forum&id=2233&rID=63901
 * ==================================================
*/

    
#include <myUART.h>


// defines ==================================================================


uint8	RxBuffer[RxBufferSize];     // Rx circular buffer to hold all incoming command
uint8  *RxReadIndex	 = RxBuffer;    // pointer to position in RxBuffer to write incoming Rx bytes
uint8  *RxWriteIndex = RxBuffer;    // pointer to position in RxBuffer to read and process bytes


char   *RxStrIndex = RB.RxStr;      // pointer to command string buffer (processed messages)
                                    // each Rx command consists of: <byte command><string value><CR>

//===========================================================================

CY_ISR(MyRxInt) //interrupt on Rx byte received
{   
    SCB_1_ClearRxInterruptSource(SCB_1_INTR_RX_NOT_EMPTY ); //clear interrupt
    
    //move all available characters from Rx queue to RxBuffer
    char byte;
    while((byte = SCB_1_UartGetChar()) != 0 )
    {
        *RxWriteIndex++ = byte; 
		if (RxWriteIndex >= RxBuffer + RxBufferSize) RxWriteIndex = RxBuffer;      
	}   

}

//===========================================================================
uint8 IsCharReady(void) 
{
	return !(RxWriteIndex == RxReadIndex);
}

//===========================================================================

uint8 GetRxStr(void)
{
    uint8 RxStr_flag = 0;
    static uint8 Ch;//static?
   
	Ch = *RxReadIndex++;       //read next char in buffer
    if (RxReadIndex >= RxBuffer + RxBufferSize) RxReadIndex = RxBuffer;
            
    //if (Ch == EOM_char)
    if ( (Ch == EOM_CR) || (Ch == EOM_LF) ) //any standard terminator
    {
        *RxStrIndex = 0;                    //terminate string excluding EOM_char
        RxStrIndex = RB.RxStr;              //reset pointer
        if (strlen(RB.RxStr) > 0)           //non-empty message received
        {
            RxStr_flag  = 1;                //set flag to process message
        }   
    }
    else                                    //string body char received
    {
        *RxStrIndex++ = Ch;                 //build command message   
        //todo: problem if first char is empty space
    }   

    return RxStr_flag;        
}

//===========================================================================

//===========================================================================


/* [] END OF FILE */

/*
    //SCB_GetRxInterruptSource(void) & SCB_INTR_RX_NOT_EMPTY
    
    if (0u != (SCB_GetRxInterruptSourceMasked() & SCB_INTR_RX_PARITY_ERROR))
    {
        // Interrupt sources does not clear automatically if it is managed by
        // user. The interrupt sources clearing becomes user responsibility.
        
        SCB_ClearRxInterruptSource(SCB_INTR_RX_PARITY_ERROR);
    
        // Add user interrupt code to manage SCB_INTR_RX_PARITY_ERROR.
    }
*/
