;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: CSD.asm
;;  Version: 1.50, Updated on 2011/3/29 at 14:29:46
;;  Generated by PSoC Designer 5.1.2110.0
;;
;;  DESCRIPTION: CS User Module software implementation file.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2011. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"
include "memory.inc"
include "GlobalParams.inc"
include "CSD.inc"

;-----------------------------------------------
;  Global Labels
;-----------------------------------------------

; Exported functions
export _CSD_Start
export  CSD_Start
export _CSD_Stop
export  CSD_Stop
export _CSD_SetScanMode
export  CSD_SetScanMode
export _CSD_ClearSensors
export  CSD_ClearSensors
export _CSD_wReadSensor
export  CSD_wReadSensor
export _CSD_wGetPortPin
export  CSD_wGetPortPin
export _CSD_EnableSensor
export  CSD_EnableSensor
export _CSD_DisableSensor
export  CSD_DisableSensor
export _CSD_ScanSensor
export  CSD_ScanSensor
export _CSD_ScanAllSensors
export  CSD_ScanAllSensors
export _CSD_SetRefValue
export  CSD_SetRefValue

; Exported variables
export  CSD_bSensorNum
export _CSD_bSensorNum
export  CSD_waSnsResult
export _CSD_waSnsResult
export  CSD_wADC_Result
export _CSD_wADC_Result

export  CSD_bADCStatus
export _CSD_bADCStatus

AREA bss

;@PSoC_UserCode_INIT@ (Do not change this line.)
;---------------------------------------------------
; Insert your custom declarations below this banner
;---------------------------------------------------

;------------------------
; User Includes
;------------------------


;------------------------
; User Constant Definitions
;------------------------


;------------------------
; User Variable Allocation
;------------------------


;---------------------------------------------------
; Insert your custom declarations above this banner
;---------------------------------------------------
;@PSoC_UserCode_END@ (Do not change this line.)


;-----------------------------------------------
; Variable Allocation
;-----------------------------------------------
AREA bss
_CSD_waSnsResult:                               ; Current raw results
 CSD_waSnsResult:                       BLK  (2*CSD_TotalSensorCount)

AREA InterruptRAM (RAM, REL, CON)

 CSD_wADC_Result:
_CSD_wADC_Result:                       BLK 2

 CSD_bADCStatus:
_CSD_bADCStatus:                        BLK 1

 CSD_bScanTime:                         BLK 1

 CSD_bRefValue:                         BLK 1

 CSD_bBitMask:                          BLK  1  ; Temp bitmask byte
_CSD_bSensorNum:                                ; Current sensor to scan
 CSD_bSensorNum:                        BLK  1

AREA UserModules (ROM, REL, CON)

LSB:  equ  1
MSB:  equ  0

;@PSoC_UserCode_BODY1@ (Do not change this line.)

IF (CPU_CLOCK_JUST - OSC_CR0_CPU_24MHz)
  CSD_DELAY:   equ     20
ELSE
  CSD_DELAY:   equ     40
ENDIF

;---------------------------------
; Tables for Scan Speed and Resolution
;---------------------------------
.LITERAL

CSD_VC1_Table:
  DB    0x07, 0x17, 0x37, 0x77

CSD_VC3_Table:
  DB    0x0F, 0x1F, 0x3F, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF

CSD_PWM_Table:                                     ; Dedicated PWM settings
  DB    0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x22, 0x2A, 0x32

IF (CSD_WITH_PWM)
ELSE
CSD_PRS_Poly_Table:
  DW    0x0110, 0x03FC, 0x03FC, 0x07C8, 0x0D34, 0x13C8, 0x3DAE, 0x3DAE, 0x3DAE, 0x3DAE, 0x3DAE  ;  PRS16 polynomials table

CSD_PRS_Seed_Table:
  DW    0x0020, 0x0040, 0x0040, 0x0080, 0x0100, 0x0200, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400  ;  PRS16 seed values table
ENDIF

.ENDLITERAL

CSD_PRS8_Poly:     equ     0xB8;

;@PSoC_UserCode_END@ (Do not change this line.)


.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_Start(void)
;
;  DESCRIPTION:
;  Connects external cap; sets up comparator
;  disables all possible analog mux bus
;  connections; shunts all sensor pins to ground.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;    None
;
;  RETURNS:      None.
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_Start:
_CSD_Start:

   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_PROLOGUE RAM_USE_CLASS_3
   RAM_SETPAGE_CUR 0 ; direct access ram will always be in interrupt ram area

   RAM_SETPAGE_IDX >CSD_baSnsOnMask
   mov     X, (CSD_TotalSensorCount-1)/8
.NullingCycle:
   mov     [X + <CSD_baSnsOnMask], 0
   dec     X
   jnc     .NullingCycle

   RAM_SETPAGE_IDX >CSD_baSnsDebounce
   mov   X, (CSD_TotalSensorCount-1)
   mov   A, CSD_Debounce
.NullDbnc:
   mov   [X + CSD_baSnsDebounce], A
   dec   X
   jnc   .NullDbnc

   RAM_SETPAGE_IDX >CSD_baLowBaselineReset
   mov     A, CSD_LowBaselineReset
   mov     X, CSD_TotalSensorCount-1
.InitCycle:
   mov     [X + <CSD_baLowBaselineReset], A
   dec     X
   jnc     .InitCycle

   RAM_EPILOGUE RAM_USE_CLASS_3

    mov     [CSD_bNoiseThreshold], CSD_NOISE_THRESHOLD
    mov     [CSD_bNegativeNoiseThreshold], CSD_NEGATIVE_NOISE_THRESHOLD
    mov     [CSD_bBaselineUpdateThreshold], CSD_BASELINE_UPDATE_THRESHOLD
    mov     [CSD_bHysteresis], CSD_HYSTERESIS
    mov     [CSD_bDebounce], CSD_Debounce
    mov     [CSD_bLowBaselineReset], CSD_LowBaselineReset

    or      reg[CSD_ACE_CONTROL2_REG], 0x03  ; Start analog comparator

IF (CSD_CAPACITOR_PIN & CSD_CAPACITOR_P0_1)
    or      reg[AMUXCFG], 0x17      ; Capacitor on P0.1  and muxbus clocked from Row0Broadcast
    mov     X, 00h                  ; Wizard bug workaround: connect modulator capacitor manually
    mov     A, 02h
    call    CSD_EnableSensor
ELSE
    or      reg[AMUXCFG], 0x27		; Capacitor on P0.3  and muxbus clocked from Row0Broadcast
    mov     X, 00h                  ; Wizard bug workaround: connect modulator capacitor manually
    mov     A, 08h
    call    CSD_EnableSensor
ENDIF

    M8C_SetBank1
    mov     reg[AMD_CR1], 0x02         ; Analog modulator from GOE0
    or      reg[ACE01CR1], 0x40        ; Enable CompBus for CMP

IF  (CSD_FEEDBACK_PIN & CSD_FEEDBACK_P1_5)
    mov     reg[CMP_GO_EN], 0x80		; CMP_Bus 1 -> GOO5
ELSE
    mov     reg[CMP_GO_EN], 0x40		; CMP_Bus 1 -> GOO1
ENDIF

    M8C_SetBank0


    or      reg[ADC1_CR], 0x20          ; Sample and Hold Enable.

    mov     reg[DEC_CR0], 0x10		; The dedicated PWM gates the Comp0
    or      reg[CMP_CR0], 0x01		; Sets dedicated PWM as the interrupt source

    mov     [CSD_bRefValue], CSD_REF_VALUE

    mov     A, 2
    mov     X, 0x10
    call    CSD_SetScanMode

    M8C_SetBank1

IF (CSD_FEEDBACK_PIN & CSD_FEEDBACK_P3_1)
    or      reg[PRT3DM0], 0x02
    or      reg[PRT3DM1], 0x02
    M8C_SetBank0
    or      reg[PRT3DM2], 0x02
ELSE
  IF (CSD_FEEDBACK_PIN & CSD_FEEDBACK_P1_5)
    or      reg[PRT1DM0], 0x20
    or      reg[PRT1DM1], 0x20
    M8C_SetBank0
    or      reg[PRT1DM2], 0x20
  ELSE                              ; R at P1.1
    or      reg[PRT1DM0], 0x02
    or      reg[PRT1DM1], 0x02
    M8C_SetBank0
    or      reg[PRT1DM2], 0x02
  ENDIF
ENDIF

IF (CSD_WITH_PWM)
    mov     reg[CSD_PWM_PERIOD_REG], CSD_PWM_PERIOD ; Set PWM period
    or      reg[CSD_PWM_CONTROL_REG], 0x01         ; Start PWM
ENDIF

    call    CSD_ClearSensors                          ; Loop through all sensors and deactivates them

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_SetScanMode
;
;  DESCRIPTION:
;  Set clocking (VC1, VC2, VC3 etc)  accordig to required Scan Speed and Resolution
;  INPUT:
;  A - BYTE bSpeed  - scan speed code from 0 to 3
;  X - BYTE bResolution - resolution [9..14]
;
;  RETURNS:      None.
;  SIDE EFFECTS:
;    Uses CSD_wADC_Result variable as temporary registers
;
;-----------------------------------------------------------------------------
_CSD_SetScanMode:
 CSD_SetScanMode:

    RAM_PROLOGUE RAM_USE_CLASS_4
    RAM_SETPAGE_CUR  0
    cmp     A, CSD_SLOW_SPEED + 1          ; if (bSpeed > SLOW_SPEED)  bSpeed = SLOW_SPEED
    jc      .SpeedOk
    mov     A, CSD_SLOW_SPEED
.SpeedOk:
    mov     [CSD_wADC_Result], A           ; _wADC_Result := bSpeed
    swap    A, X                                        ; A := bResolution
    cmp     A, CSD_MAX_RESOLUTION + 1      ; if (bResolution > MAX_RESOLUTION)  bResolution = MAX_RESOLUTION
    jc      .ResolutionOk
    mov     A, CSD_MAX_RESOLUTION
.ResolutionOk:

    mov     [CSD_wADC_Result+1], A         ; _wADC_Result+1 := bResolution

    sub     [CSD_wADC_Result+1], CSD_MIN_RESOLUTION   ; Remove offset - now Resolution code is from 0

    M8C_SetBank0

IF (CSD_WITH_PWM)
    and     reg[CSD_PRS_CONTROL_REG], ~0x01    ; stop the PRS8
    mov     reg[CSD_PRS_SEED_REG], 0x01        ; Seed := 1
    mov     reg[CSD_PRS_POLY_REG], CSD_PRS8_Poly
    or      reg[CSD_PRS_CONTROL_REG], 0x01     ; start the PRS8

ELSE
    and     reg[CSD_PRS_CONTROL_LSB_REG], ~0x01    ;stop the PRS16
    mov     reg[CSD_PRS_SEED_LSB_REG], 0x01        ; Seed := 1
    mov     reg[CSD_PRS_SEED_MSB_REG], 0x00

    mov     A, [CSD_wADC_Result+1]                 ; A := (bResolution-9)
    add     A, [CSD_wADC_Result]
    asl     A                                           ; A := byte offset in PRS Poly table
    mov     [CSD_bScanTime], A
    inc     A
    index   CSD_PRS_Poly_Table             ; A := LSB poly
    mov     reg[CSD_PRS_POLY_LSB_REG], A
    mov     A, [CSD_bScanTime]
    index   CSD_PRS_Poly_Table             ; A := MSB poly
    mov     reg[CSD_PRS_POLY_MSB_REG], A

    or      reg[CSD_PRS_CONTROL_LSB_REG], 0x01    ;start the PRS16
ENDIF

    mov     A, [CSD_wADC_Result+1]         ; A := bResolution
    index   CSD_PWM_Table
    mov     reg[PWM_CR], A

    M8C_SetBank1

    mov     reg[OSC_CR4], 0x02                          ; Set VC2 as clock source for VC3
    mov     A, [CSD_wADC_Result+1]         ; A := bResolution
    index   CSD_VC3_Table
    mov     reg[OSC_CR3], A                             ; Set VC3

    mov     A, [CSD_wADC_Result]           ; A := bSpeed
    index   CSD_VC1_Table
    mov     reg[OSC_CR1], A

    mov     A, [CSD_wADC_Result]           ; A := bSpeed
    jnz     .NotUltraFast

    mov     reg[CLK_CR3], 0x44                          ; column clock by SysCLK direct
    or      reg[CSD_CNT_OUT_REG], 0xC0     ; Use SysCLK direct
    jmp     .Continue

.NotUltraFast:
    mov     reg[CLK_CR3], 0x00                          ; Set VC1 as column clock source
    or      reg[CSD_CNT_OUT_REG], 0x40     ; Sync to SysClk
    and     reg[CSD_CNT_OUT_REG], ~0x80

.Continue:
    M8C_SetBank0

    mov     A, [CSD_bRefValue]
    call    CSD_SetRefValue

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

.ENDSECTION


.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_SetRefValue
;
;  DESCRIPTION:
;  Set reference voltage by adjusting compare value for PRS or PWM
;  INPUT:
;  A - BYTE bRefValue  - Ref voltage code from 0 to 8
;                        0 -> Ref = 1/4 * Vcc
;                        8 -> Ref = 3/4 * Vcc
;
;  RETURNS:      None.
;  SIDE EFFECTS:
;    Uses CSD_wADC_Result and CSD_bADCStatus
;           variables as temporary registers
;
;-----------------------------------------------------------------------------
_CSD_SetRefValue:
 CSD_SetRefValue:

    RAM_PROLOGUE RAM_USE_CLASS_4
    RAM_SETPAGE_CUR 0

    cmp     A, 9
    jc      .ValueOk
    mov     A, 8
.ValueOk:
    mov     [CSD_bRefValue], A
    add     A, 4
    mov     [CSD_bADCStatus], A

IF (CSD_WITH_PWM)
    mov     [CSD_wADC_Result + LSB], CSD_PWM_PERIOD
    mov     [CSD_wADC_Result + MSB], 0
    inc     [CSD_wADC_Result + LSB]
    adc     [CSD_wADC_Result + MSB], 0

    mov     X, [CSD_wADC_Result + LSB]
    mov     A, [CSD_wADC_Result + MSB]

.L0:
    dec     [CSD_bADCStatus]
    jz      .Ready
    swap    A, X
    add     [CSD_wADC_Result + LSB], A
    swap    A, X
    adc     [CSD_wADC_Result + MSB], A
    jmp     .L0
.Ready:

    mov     A, 4
.L1:
    asr     [CSD_wADC_Result + MSB]
    rrc     [CSD_wADC_Result + LSB]
    dec     A
    jnz     .L1

    mov     A, [CSD_wADC_Result + LSB]
    jz      .L2
    dec     A
.L2:
    mov     reg[CSD_PWM_COMPARE_REG], A
ELSE
    mov     A, [CSD_bScanTime]
    inc     A
    index   CSD_PRS_Seed_Table             ; A := LSB seed
    mov     [CSD_wADC_Result + LSB], A
    mov     X, A                                        ; V := LSB seed
    mov     A, [CSD_bScanTime]
    index   CSD_PRS_Seed_Table             ; A := MSB seed
    mov     [CSD_wADC_Result + MSB], A

.L0:
    dec     [CSD_bADCStatus]
    jz      .Ready
    swap    A, X
    add     [CSD_wADC_Result + LSB], A
    swap    A, X
    adc     [CSD_wADC_Result + MSB], A
    jmp     .L0
.Ready:
    and     reg[CSD_PRS_CONTROL_LSB_REG], ~0x01    ;stop the PRS16
    mov     A, [CSD_wADC_Result + LSB]
    mov     reg[CSD_PRS_SEED_LSB_REG], A
    mov     A, [CSD_wADC_Result + MSB]
    mov     reg[CSD_PRS_SEED_MSB_REG], A
    or      reg[CSD_PRS_CONTROL_LSB_REG], 0x01    ;start the PRS16
ENDIF

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_ClearSensors(void)
;
;  DESCRIPTION:
;    Clears all sensor connections to the analog mux bus and shunts all sensor
;    pins to ground.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    None.
;  RETURNS:      None
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_ClearSensors:
_CSD_ClearSensors:
   RAM_PROLOGUE RAM_USE_CLASS_4
   mov   A,CSD_TotalSensorCount
   dec   A
.InitLoop:                                              ; Loop through all sensors and deactivate
   push  A
   call  CSD_wGetPortPin
   call  CSD_DisableSensor
   pop   A
   dec   A
   jnc   .InitLoop
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_Stop(void)
;
;  DESCRIPTION:
;  Disables RO interrupt; disables the relaxation oscillator circuitry;
;  clears scan active flag; disables all sensors and shunts them to ground.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    None.
;  RETURNS:      Nothing.
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_Stop:
_CSD_Stop:
    RAM_PROLOGUE RAM_USE_CLASS_4

    M8C_SetBank1
    mov     reg[AMD_CR1], 0x00          ; Disable Analog modulator

IF  (1 & CSD_FEEDBACK_P1_5)
    and     reg[CMP_GO_EN], ~0x80       ; Disconnect CMP bus from GOO
ELSE
    and     reg[CMP_GO_EN], ~0x40
ENDIF

    M8C_SetBank0
    and      reg[ADC1_CR], ~0x20          ; Sample and Hold Disable.


IF (CSD_WITH_PWM)
    and     reg[CSD_PWM_CONTROL_REG], ~0x01                          ; Stop PWM
    and     reg[CSD_PRS_CONTROL_REG], ~0x01                          ; stop the PRS8
ELSE
    and     reg[CSD_PRS_CONTROL_LSB_REG], ~0x01                      ; Stop the PRS16
ENDIF

    call    CSD_ClearSensors                                         ; Loop through all keys and deactivate
    and     reg[CSD_ACE_CONTROL2_REG], ~0x03                         ; Stop analog comparator
    mov     reg[AMUXCFG], 0                                            ; Disable external cap

    mov     reg[DEC_CR0], 0x00		;
    and     reg[CMP_CR0], ~0x01		;

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret
.ENDSECTION

IF (CSD_TotalSensorCount)
.LITERAL
ENDIF
 CSD_Sensor_Table2:
_CSD_Sensor_Table2:
	dw	0x0140	// Port 1 Bit 6
	dw	0x0108	// Port 1 Bit 3
	dw	0x0308	// Port 3 Bit 3
	dw	0x0202	// Port 2 Bit 1
	dw	0x0208	// Port 2 Bit 3
	dw	0x0001	// Port 0 Bit 0
	dw	0x0110	// Port 1 Bit 4
	dw	0x0040	// Port 0 Bit 6
	dw	0x0010	// Port 0 Bit 4
	dw	0x0004	// Port 0 Bit 2
	dw	0x0240	// Port 2 Bit 6
	dw	0x0210	// Port 2 Bit 4
	dw	0x0204	// Port 2 Bit 2
	dw	0x0201	// Port 2 Bit 0
	dw	0x0304	// Port 3 Bit 2
	dw	0x0301	// Port 3 Bit 0

IF (CSD_TotalSensorCount)
.ENDLITERAL
ENDIF

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_wGetPortPin(BYTE bSensor)
;
;  DESCRIPTION:
;      Returns the port and pin mask from a given key number.  This function
;      uses the table CSD_Sensor_Table to retreive this
;      information.
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;        A => Sensor Number  ( 0 to n )
;  RETURNS:
;        A  <=  Sensor Bitmap
;        X  <=  Port Number
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_wGetPortPin:
_CSD_wGetPortPin:

  RAM_PROLOGUE RAM_USE_CLASS_1
   asl    A                                      ; multiply key by 2 since table is 2 bytes per key
   mov    X,A                                    ; Copy index*2 in x for next value
   index  CSD_Sensor_Table2                      ; A contains the port value
   swap   A,X                                    ; Place port value in X and index*2 in A
   inc    A                                      ; Advance to next value (bitMask)
   index  CSD_Sensor_Table2                      ; A contains bitMask, X has port number

   RAM_EPILOGUE RAM_USE_CLASS_1
   ret

.ENDSECTION


.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_EnableSensor(BYTE bSensorMask, BYTE bPort)
;
;  DESCRIPTION:
;    Configures sensor to be an input to be measure duirng next measurement
;    cycle.  This function does not clear the last sensor.
;    Place key port in Analog Hi-Z mode and enables the correct mux input.
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;          X =>  Port Number for given key
;          A =>  Bit mask for given sensor
;
;  RETURNS:      none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;

 CSD_EnableSensor:
_CSD_EnableSensor:
	RAM_PROLOGUE RAM_USE_CLASS_4
    RAM_SETPAGE_CUR 0
                                                 ; Setup Mux for sensor
    mov  [CSD_bBitMask],A                        ; Store bit mask in temp location
    push X
    mov  A,X                                     ; Multiply port number by four for registor addresses
    asl  A
    asl  A
    mov  X,A                                     ; Restore Port address in X
                                                 ; Set mode do 110  (Hi-Z Analog)
    mov  A,reg[X+DM2_OFFSET]                     ; Set DM2 to 1
    or   A,[CSD_bBitMask]
    mov  reg[X+DM2_OFFSET],A
   	M8C_SetBank1
    mov  A,reg[X+DM1_OFFSET]                     ; Set DM1 to 1
    or   A,[CSD_bBitMask]
    mov  reg[X+DM1_OFFSET],A
    xor  [CSD_bBitMask],FFh                      ; Invert bitmask
    mov  A,reg[X+DM0_OFFSET]                     ; Clear DM0 bit to 0
    and  A,[CSD_bBitMask]
    mov  reg[X+DM0_OFFSET],A

    pop  X
    xor  [CSD_bBitMask],FFh                      ; Invert bitmask
    mov  A,reg[X+MUX_OFFSET]
    or   A,[CSD_bBitMask]
    mov  reg[X+MUX_OFFSET],A
	M8C_SetBank0

	RAM_EPILOGUE RAM_USE_CLASS_4
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_DisableSensor(BYTE bMask, BYTE bPort)
;
;  DESCRIPTION:
;    Disconnects the desired sensor from the analog mux bus and shunts to
;    ground.
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;          X =>  Port Number for given key
;          A =>  Bit mask for given sensor
;
;  RETURNS:      none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_DisableSensor:
_CSD_DisableSensor:
	RAM_PROLOGUE RAM_USE_CLASS_4
    RAM_SETPAGE_CUR 0
                                                 ; Disconnect sensor from mux
    cpl  A                                       ; Invert bitmask
    mov  [CSD_bBitMask],A                        ; Store bit mask in temp location
   	M8C_SetBank1
    mov  A,reg[X+MUX_OFFSET]
    and  A,[CSD_bBitMask]
    mov  reg[X+MUX_OFFSET],A
   	M8C_SetBank0

    mov  A,X                                     ; Multiply port number by for for registor addresses
    asl  A
    asl  A
    mov  X,A                                     ; Restore Port address in X

                                                 ; Set mode do 001  (Digital Strong)
    mov  A,reg[X+DM2_OFFSET]                     ; Set DM2 to 0
    and  A,[CSD_bBitMask]
    mov  reg[X+DM2_OFFSET],A

   	M8C_SetBank1
    mov  A,reg[X+DM1_OFFSET]                     ; Set DM1 to 0
    and  A,[CSD_bBitMask]
    mov  reg[X+DM1_OFFSET],A

    xor  [CSD_bBitMask],FFh                      ; Invert bitmask back to normal
    mov  A,reg[X+DM0_OFFSET]                     ; Set DM0 bit to 1
    or   A,[CSD_bBitMask]
    mov  reg[X+DM0_OFFSET],A
	M8C_SetBank0

	RAM_EPILOGUE RAM_USE_CLASS_4
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_ScanSensor(BYTE bStrtIdx)
;
;  DESCRIPTION:
;  Uses the CapSense switching circuitry to charge to the starting voltage.
;  Then a fixed slope ramp is used to measure the starting voltage with a
;  16 bit timer.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;      A  => Sensor Index
;
;  RETURNS:      None
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_ScanSensor:
_CSD_ScanSensor:
    RAM_PROLOGUE RAM_USE_CLASS_3
    RAM_SETPAGE_CUR 0
    RAM_X_POINTS_TO_INDEXPAGE

    mov     [CSD_bSensorNum], A
    call    CSD_wGetPortPin
    call    CSD_EnableSensor

IF (CSD_WITH_PWM)
ELSE
    mov    X, CSD_DELAY
.Pause:
    dec    X
    jnz    .Pause
ENDIF

    M8C_SetBank0


    mov     reg[INT_CLR0], ~INT_MSK0_ACOLUMN_0;
    M8C_EnableIntMask INT_MSK0, INT_MSK0_ACOLUMN_0 ;   Enable ACol0 interrupt

    mov     reg[INT_CLR1], ~CSD_CNT_INT_MASK
    mov     reg[CSD_CNT_PERIOD_REG], 0xFF
    CSD_Counter_EnableInt_M

    mov     A, 0
    mov     [CSD_bADCStatus], A
    mov     [CSD_wADC_Result+MSB], A
    mov     [CSD_wADC_Result+LSB], A

    CSD_Counter_Start_M                ; Start counter
    or      reg[PWM_CR], 0x01                       ; Start Dedicated PWM

.L1:
    mov     A, [CSD_bADCStatus]
    jz      .L1

    M8C_DisableIntMask INT_MSK0, INT_MSK0_ACOLUMN_0 ; Disable ACol0 interrupt

    CSD_Counter_DisableInt_M
    CSD_Counter_Stop_M                 ; Stop counter

    mov     A, [CSD_bSensorNum]
    asl     A                                        ; Multiply by two since results are INTs
    mov     X, A

    RAM_SETPAGE_IDX >CSD_waSnsResult
    mov     A, [CSD_wADC_Result + LSB]
    mov     [X+(CSD_waSnsResult+LSB)], A
    mov     A, [CSD_wADC_Result + MSB]
    mov     [X+(CSD_waSnsResult+MSB)], A

    mov     A, [CSD_bSensorNum]
    call    CSD_wGetPortPin
    call    CSD_DisableSensor

    RAM_EPILOGUE RAM_USE_CLASS_3
    ret

.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_ScanAllSensors(void)
;
;  DESCRIPTION:
;    Scans all sensors to find their raw count values
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    None.
;  RETURNS:      None
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_ScanAllSensors:
_CSD_ScanAllSensors:
   RAM_PROLOGUE RAM_USE_CLASS_4
   mov   A,CSD_TotalSensorCount                       ; Check if key value in range.
   dec   A
.ScanLoop:                                            ; Loop through all sensors and scan
   push  A
   call  CSD_ScanSensor
   pop   A
   dec   A
   jnc   .ScanLoop
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_wReadSensor(BYTE bSensor)
;
;  DESCRIPTION:
;     Returns the sensor scan value in A (LSB) and X (MSB)
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;    A = Sensor number
;  RETURNS:
;    Scan value of sensor LSB in A and MSB in X
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to preserve their values across calls to fastcall16
;    functions.
;
 CSD_wReadSensor:
_CSD_wReadSensor:
   RAM_PROLOGUE RAM_USE_CLASS_3
   RAM_SETPAGE_IDX >CSD_waSnsResult
   asl   A                                            ; Multiply by two since results are INTs
   mov   X,A
   mov   A,[X+(CSD_waSnsResult+LSB)]
   mov   X,[X+(CSD_waSnsResult+MSB)]
   RAM_EPILOGUE RAM_USE_CLASS_3
   ret
.ENDSECTION

