;;*****************************************************************************
;;  FILENAME: CSDHL.asm
;;  Version: 1.50, Updated on 2011/3/29 at 14:29:46
;;  Generated by PSoC Designer 5.1.2110.0
;;
;;  DESCRIPTION: CSD User Module high level software
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2011. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"
include "memory.inc"
include "CSD.inc"

;-----------------------------------------------
; Global Symbols
;-----------------------------------------------

export _CSD_UpdateSensorBaseline
export  CSD_UpdateSensorBaseline
export _CSD_InitializeSensorBaseline
export  CSD_InitializeSensorBaseline
export _CSD_bIsSensorActive
export  CSD_bIsSensorActive
export _CSD_bIsAnySensorActive
export  CSD_bIsAnySensorActive
export _CSD_SetDefaultFingerThresholds
export  CSD_SetDefaultFingerThresholds
export _CSD_InitializeBaselines
export  CSD_InitializeBaselines
export _CSD_UpdateAllBaselines
export  CSD_UpdateAllBaselines
export  CSD_baSnsDebounce
IF CSD_SLIDERS_EXIST
export _CSD_wGetCentroidPos
export  CSD_wGetCentroidPos
export _CSD_wGetRadialPos
export  CSD_wGetRadialPos
export _CSD_wGetRadialInc
export  CSD_wGetRadialInc
ENDIF


;-----------------------------------------------
; Variable Allocation
;-----------------------------------------------
AREA InterruptRAM (RAM, REL, CON)

_CSD_bNoiseThreshold:
 CSD_bNoiseThreshold:                   BLK  1
_CSD_bNegativeNoiseThreshold:
 CSD_bNegativeNoiseThreshold:           BLK  1
_CSD_bBaselineUpdateThreshold:
 CSD_bBaselineUpdateThreshold:          BLK  1
_CSD_bHysteresis:
 CSD_bHysteresis:                       BLK  1
_CSD_bDebounce:
 CSD_bDebounce:                         BLK  1
_CSD_bLowBaselineReset:
 CSD_bLowBaselineReset:                 BLK  1

export _CSD_bNoiseThreshold
export  CSD_bNoiseThreshold
export _CSD_bNegativeNoiseThreshold
export  CSD_bNegativeNoiseThreshold
export _CSD_bBaselineUpdateThreshold
export  CSD_bBaselineUpdateThreshold
export _CSD_bHysteresis
export  CSD_bHysteresis
export _CSD_bDebounce
export  CSD_bDebounce
export _CSD_bLowBaselineReset
export  CSD_bLowBaselineReset
export  CSD_baLowBaselineReset

; Local variables
_CSD_bEndOfArray:                               ; Temp pointer variable
 CSD_bEndOfArray:                       BLK  1
_CSD_fIsPressed:                                ; Temp variable for if any sensor is pressed
 CSD_fIsPressed:                        BLK  1
_CSD_bCurPos:                                   ; Temp position variable
 CSD_bCurPos:                           BLK  1
_CSD_bSnsMaskPtr:                               ; Temp sensor mask pointer used in centroid calculation
 CSD_bSnsMaskPtr:                       BLK  1
_CSD_bStartIndex:                               ; Temp Start index
 CSD_bStartIndex:			     BLK  1
_CSD_wTmpBtnFThreshold:                         ; Temp Difference
 CSD_wTmpBtnFThreshold:                 BLK  2

IF CSD_SLIDERS_EXIST
; Local slider variables
_CSD_wDenom:                                    ; Denominator is also the Ctrd Pos
 CSD_wDenom:                            BLK  2
_CSD_dNumer:                                    ; Numerator also contains the Ctrd Pos
 CSD_dNumer:                            BLK  2
_CSD_wCtrdPos:                                  ; Ctrd Pos is LMSB and LLSB of the numerator
 CSD_wCtrdPos:                          BLK  2
_CSD_dMultTempX:                                ; Temp multiplication register
 CSD_dMultTempX:                        BLK  4
_CSD_dMultTempY:                                ; Temp multiplication register
 CSD_dMultTempY:                        BLK  4
_CSD_bCurSlider:
 CSD_bCurSlider:                        BLK  1
_CSD_bCurCtrdStartPos:                          ; Temp current centroid start position
 CSD_bCurCtrdStartPos:                  BLK  1
_CSD_bCurCtrdSize:                              ; Temp current centroid size
 CSD_bCurCtrdSize:                      BLK  1
_CSD_bBiggestCtrdStartPos:                      ; Temp biggest centroid start position
 CSD_bBiggestCtrdStartPos:              BLK  1
_CSD_bBiggestCtrdSize:                          ; Temp biggest centroid size
 CSD_bBiggestCtrdSize:                  BLK  1
_CSD_wCurPkValue:                               ; Temp current peak
 CSD_wCurPkValue:                       BLK  2
_CSD_bCurPkPos:                                 ; Temp current slider pointer
 CSD_bCurPkPos:                         BLK  1
_CSD_bDiplexInfo:                               ; Temp flag for diplex of current group
 CSD_bDiplexInfo:                       BLK  1
_CSD_bDiplexMSB:                                ; Temp that contains the address of the rom diplex table
 CSD_bDiplexMSB:                        BLK  1
_CSD_bDiplexLSB:
 CSD_bDiplexLSB:                        BLK  1
_CSD_wDivBtwSns:                                ; Temp divisions between sensors
 CSD_wDivBtwSns:                        BLK  2
_CSD_waCentroid:                                 ;array of Centroid and  two adjacent values (word array)
 CSD_waCentroid:                        BLK  6
ENDIF

AREA ram1 (RAM, REL, CON)
; Global variables
_CSD_waSnsBaseline:                     ; Baseline, one entry for each sensor
 CSD_waSnsBaseline:                     BLK  (2*CSD_TotalSensorCount)
_CSD_waSnsDiff:                         ; ABS Diff of raw and and baseline, one entry for each sensor
 CSD_waSnsDiff:                         BLK  (2*CSD_TotalSensorCount)
AREA ram2 (RAM, REL, CON)
_CSD_baSnsBucket:                       ; Baseline difference accumulator, one entry for each sensor
 CSD_baSnsBucket:                       BLK  CSD_TotalSensorCount
_CSD_baBtnFThreshold:                   ; Containing variable finger threshold for each button
 CSD_baBtnFThreshold:                   BLK  CSD_TotalSensorCount
_CSD_baSnsOnMask:                       ; Sensor mask array containing on/off state of sensors
IF (CSD_TotalSensorCount)
 CSD_baSnsOnMask:                       BLK  ((CSD_TotalSensorCount-1)/8)+1
ELSE
 CSD_baSnsOnMask:                       BLK  1
ENDIF
_CSD_baSnsDebounce:
 CSD_baSnsDebounce:                     BLK  CSD_TotalSensorCount
_CSD_baLowBaselineReset:
 CSD_baLowBaselineReset:                BLK  CSD_TotalSensorCount

AREA bss
IF CSD_SLIDERS_EXIST
_CSD_waCtrdPkValue:                     ; Array containing peak value of centroid
 CSD_waCtrdPkValue:                     BLK  (2*CSD_SliderCount)
_CSD_waSliderPrevPos:                     ;
 CSD_waSliderPrevPos:                   BLK  (2*CSD_SliderCount)
_CSD_waSliderCurrPos:                     ;
 CSD_waSliderCurrPos:                   BLK  (2*CSD_SliderCount)
ENDIF

; Global variables
export _CSD_waSnsBaseline
export  CSD_waSnsBaseline
export _CSD_waSnsDiff
export  CSD_waSnsDiff
export _CSD_baBtnFThreshold
export  CSD_baBtnFThreshold
export _CSD_baSnsOnMask
export  CSD_baSnsOnMask

; Local variables
export _CSD_fIsPressed
export  CSD_fIsPressed
export _CSD_bEndOfArray
export  CSD_bEndOfArray
export _CSD_bCurPos
export  CSD_bCurPos
export _CSD_bSnsMaskPtr
export  CSD_bSnsMaskPtr

IF CSD_SLIDERS_EXIST
; Local slider variables
export _CSD_wDenom
export  CSD_wDenom
export _CSD_wCtrdPos
export  CSD_wCtrdPos
export _CSD_dNumer
export  CSD_dNumer
export _CSD_dMultTempX
export  CSD_dMultTempX
export _CSD_dMultTempY
export  CSD_dMultTempY
export _CSD_bCurCtrdStartPos
export  CSD_bCurCtrdStartPos
export _CSD_bCurCtrdSize
export  CSD_bCurCtrdSize
export _CSD_bBiggestCtrdStartPos
export  CSD_bBiggestCtrdStartPos
export _CSD_bBiggestCtrdSize
export  CSD_bBiggestCtrdSize
export _CSD_wCurPkValue
export  CSD_wCurPkValue
export _CSD_bCurPkPos
export  CSD_bCurPkPos
export _CSD_bDiplexMSB
export  CSD_bDiplexMSB
export _CSD_bDiplexLSB
export  CSD_bDiplexLSB
export _CSD_wDivBtwSns
export  CSD_wDivBtwSns
export _CSD_waSliderPrevPos
export  CSD_waSliderPrevPos
export _CSD_waSliderCurrPos
export  CSD_waSliderCurrPos
ENDIF

;@PSoC_UserCode_INIT@ (Do not change this line.)
;---------------------------------------------------
; Insert your custom declarations below this banner
;---------------------------------------------------

;------------------------
; User Includes
;------------------------


;------------------------
; User Constant Definitions
;------------------------


;------------------------
; User Variable Allocation
;------------------------


;---------------------------------------------------
; Insert your custom declarations above this banner
;---------------------------------------------------
;@PSoC_UserCode_END@ (Do not change this line.)

;------------------------
;  Constant Definitions
;------------------------
AREA UserModules (ROM, REL, CON)

; For using two byte variables
LSB:  equ  1
MSB:  equ  0

; For using four byte variables
MMSB: equ 0
MLSB: equ 1
LMSB: equ 2
LLSB: equ 3


.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_UpdateSensorBaseline(BYTE bSensorNum)
;
;  DESCRIPTION:
;      Update baseline for one sensor. The algorithm is as follows:
;        If difference count is negative baseline become raw count
;        If difference count is above noise threshold do not update
;        Else difference count is positive and within noise threshold so
;        difference is halved and added to the bucket. When the bucket
;        reaches the threshold the baseline increments and the bucket resets
;-----------------------------------------------------------------------------
;  STACK USAGE: 0 BYTES
;
;  ARGUMENTS:
;      A => Sensor Number
;
;  RETURNS:
;      Nothing
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_UpdateSensorBaseline:
_CSD_UpdateSensorBaseline:
   RAM_PROLOGUE RAM_USE_CLASS_3
   RAM_SETPAGE_CUR 0 ; direct access ram will always be in interrupt ram area

   mov [CSD_bSensorNum], A                                                     ; Save sensor index
   asl A
   mov X,A

   ; Get the difference counts
   RAM_SETPAGE_IDX >CSD_waSnsResult
   mov A, [X+CSD_waSnsResult+LSB]
   RAM_SETPAGE_IDX >CSD_waSnsBaseline
   sub A, [X+CSD_waSnsBaseline+LSB]
   RAM_SETPAGE_IDX >CSD_waSnsDiff
   mov [X+CSD_waSnsDiff+LSB], A
   RAM_SETPAGE_IDX >CSD_waSnsResult
   mov A, [X+CSD_waSnsResult+MSB]
   RAM_SETPAGE_IDX >CSD_waSnsBaseline
   sbb A, [X+CSD_waSnsBaseline+MSB]
   RAM_SETPAGE_IDX >CSD_waSnsDiff
   mov [X+CSD_waSnsDiff+MSB], A

   tst [X+CSD_waSnsDiff+MSB], 80h						                                        ; Is difference negative?
   jnz .IsNegative

IF (CSD_AUTORESET)
   cmp [X+CSD_waSnsDiff+MSB], 0
   jz   .AddBucketLSB
   mov  A, 255
   jmp  .AddBucketConst
ELSE
   ; Compare to Noise Threshold
   cmp [X+CSD_waSnsDiff+MSB], 0
   jnz  .InitLowBaselineReset
   mov A, [CSD_bNoiseThreshold]
   cmp A, [X+CSD_waSnsDiff+LSB]
   jc	.InitLowBaselineReset
ENDIF

   ; Add to the Bucket
.AddBucketLSB:
   mov A, [X+CSD_waSnsDiff+LSB]
.AddBucketConst:
   mov X, [CSD_bSensorNum]
   add A, 0
   rrc A															                                                        ; For slower tracking
   RAM_SETPAGE_IDX >CSD_baSnsBucket
   add [X+CSD_baSnsBucket], A
   jc  .DoInc
   mov A, [CSD_bBaselineUpdateThreshold]
   cmp A, [X+CSD_baSnsBucket]
   jnc .EndBucket
   jz  .EndBucket
.DoInc:
   ; Increment Baseline
   mov [X+CSD_baSnsBucket], 0
   mov A, X
   asl A
   mov X, A
   RAM_SETPAGE_IDX >CSD_waSnsBaseline
   add [X+CSD_waSnsBaseline+LSB], 1
   adc [X+CSD_waSnsBaseline+MSB], 0

.EndBucket:
IF (CSD_AUTORESET)
   mov  A, [CSD_bSensorNum]
   asl  A
   mov  X, A
   ; Compare to Noise Threshold
   RAM_SETPAGE_IDX >CSD_waSnsDiff
   cmp [X+CSD_waSnsDiff+MSB], 0
   jnz  .InitLowBaselineReset
   mov A, [CSD_bNoiseThreshold]
   cmp A, [X+CSD_waSnsDiff+LSB]
   jc	.InitLowBaselineReset
ELSE
ENDIF
   jmp .SetDifferenceToZero

.IsNegative:
   ; Compare to Negative Noise Threshold
   cmp [X+CSD_waSnsDiff+MSB], FFh
   jnz  .CheckLowBaseline
   mov A, FFh
   sub A, [CSD_bNegativeNoiseThreshold]
   cmp A, [X+CSD_waSnsDiff+LSB]
   jc	.LowerBaseline
.CheckLowBaseline:
   ; Set difference to zero
   RAM_SETPAGE_IDX >CSD_waSnsDiff
   mov [X+CSD_waSnsDiff+LSB], 0
   mov [X+CSD_waSnsDiff+MSB], 0
   ; Check Low Baseline Reset
   mov A, X
   asr A
   mov X, A
   RAM_SETPAGE_IDX >CSD_baLowBaselineReset
   mov A, [X+CSD_baLowBaselineReset]
   dec A
   jnc .Gt0
   mov  A, 0
.Gt0:
   mov [X+CSD_baLowBaselineReset], A
   push A
   mov A, X
   asl A
   mov X, A
   pop A
   jnz .EndofUpdateSensorBaseline

.LowerBaseline:
   RAM_SETPAGE_IDX >CSD_waSnsResult
   mov A, [X+CSD_waSnsResult+LSB]
   RAM_SETPAGE_IDX >CSD_waSnsBaseline
   mov [X+CSD_waSnsBaseline+LSB], A
   RAM_SETPAGE_IDX >CSD_waSnsResult
   mov A, [X+CSD_waSnsResult+MSB]
   RAM_SETPAGE_IDX >CSD_waSnsBaseline
   mov [X+CSD_waSnsBaseline+MSB], A

.SetDifferenceToZero:
   ; Set difference to zero
   mov A, [CSD_bSensorNum]
   asl A
   mov X,A
   RAM_SETPAGE_IDX >CSD_waSnsDiff
   mov [X+CSD_waSnsDiff+LSB], 0
   mov [X+CSD_waSnsDiff+MSB], 0
.InitLowBaselineReset:
   mov A, X
   asr A
   mov X, A
   RAM_SETPAGE_IDX >CSD_baLowBaselineReset
   mov A, [CSD_bLowBaselineReset]
   mov [X+CSD_baLowBaselineReset], A

.EndofUpdateSensorBaseline:
   RAM_EPILOGUE RAM_USE_CLASS_3
   ret

.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_bIsSensorActive(BYTE bSensorNum)
;
;  DESCRIPTION:
;      Returns state of one sensor.	Updates the baSnsOnMask array.
;      Implements hysteresis based on the Hysteresis parameter.
;-----------------------------------------------------------------------------
;  STACK USAGE: 3 BYTES
;
;  ARGUMENTS:
;      A => sensor index
;
;  RETURNS:
;      A => 1 if sensor is active, 0 otherwise
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_bIsSensorActive:
_CSD_bIsSensorActive:
   RAM_PROLOGUE RAM_USE_CLASS_3
   RAM_SETPAGE_CUR 0 ; direct access ram will always be in interrupt ram area

   push A
   mov X,A
   RAM_SETPAGE_IDX >CSD_baBtnFThreshold
   mov A, [X+CSD_baBtnFThreshold]
   mov [CSD_wTmpBtnFThreshold+LSB], A
   mov [CSD_wTmpBtnFThreshold+MSB], 0

   pop A
   push A
   call CSD_GetOnMask
   RAM_SETPAGE_IDX >CSD_baSnsOnMask
   and A, [X+CSD_baSnsOnMask]
   jnz .WasOn

.WasOff:
   ; Check the difference counts against the threshold
   mov A, [CSD_bHysteresis]
   add [CSD_wTmpBtnFThreshold+LSB], A
   adc [CSD_wTmpBtnFThreshold+MSB], 0
   pop A
   asl A
   mov X, A
   RAM_SETPAGE_IDX >CSD_waSnsDiff
   mov A, [X+CSD_waSnsDiff+LSB]
   sub A, [CSD_wTmpBtnFThreshold+LSB]
   mov A, [X+CSD_waSnsDiff+MSB]
   sbb A, [CSD_wTmpBtnFThreshold+MSB]
   jc .NotActive
   mov A, X
   asr A
   mov X, A
   RAM_SETPAGE_IDX >CSD_baSnsDebounce
   mov A, [X+CSD_baSnsDebounce]
   dec A
   mov [X+CSD_baSnsDebounce], A
   push A
   mov A, X
   asl A
   mov X, A
   pop A
   jnz .NotActiveDebouncing
   jmp .Active

.WasOn:
   ; Check the difference counts against the threshold
   mov A, [CSD_bHysteresis]
   sub [CSD_wTmpBtnFThreshold+LSB], A
   sbb [CSD_wTmpBtnFThreshold+MSB], 0
   pop A
   asl A
   mov X, A
   RAM_SETPAGE_IDX >CSD_waSnsDiff
   mov A, [X+CSD_waSnsDiff+LSB]
   sub A, [CSD_wTmpBtnFThreshold+LSB]
   mov A, [X+CSD_waSnsDiff+MSB]
   sbb A, [CSD_wTmpBtnFThreshold+MSB]
   jc .NotActive

.Active:
   mov A, X
   asr A
   call CSD_GetOnMask
   RAM_SETPAGE_IDX >CSD_baSnsOnMask
   or [X+CSD_baSnsOnMask], A
   mov A, 1
   jmp .EndIsSensorActive
.NotActive:
   mov A, X
   asr A
   push A
   call CSD_GetOnMask
   cpl A
   RAM_SETPAGE_IDX >CSD_baSnsOnMask
   and [X+CSD_baSnsOnMask], A
   RAM_SETPAGE_IDX >CSD_baSnsDebounce
   pop X
   mov A, [CSD_bDebounce]
   mov [X+CSD_baSnsDebounce], A
   mov A, 0
   jmp .EndIsSensorActive
.NotActiveDebouncing:
   mov A, X
   asr A
   call CSD_GetOnMask
   cpl A
   RAM_SETPAGE_IDX >CSD_baSnsOnMask
   and [X+CSD_baSnsOnMask], A
   mov A, 0
.EndIsSensorActive:
   RAM_EPILOGUE RAM_USE_CLASS_3
   ret

.ENDSECTION

 CSD_GetOnMask:
_CSD_GetOnMask:
   push A
   asr A
   asr A
   asr A
   mov X, A
   pop A
   and A, 7h
   index CSD_bitlookup
   ret

.LITERAL
CSD_bitlookup:
	db 01h, 02h, 04h, 08h, 10h, 20h, 40h, 80h
.ENDLITERAL


.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_SetDefaultFingerThresholds(void)
;
;  DESCRIPTION:
;    Sets the FingerThreshold RAM array to the user module parameter value
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    None.
;  RETURNS:      None
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_SetDefaultFingerThresholds:
_CSD_SetDefaultFingerThresholds:
   RAM_PROLOGUE RAM_USE_CLASS_3
   RAM_SETPAGE_IDX >CSD_baBtnFThreshold

   mov   A,CSD_TotalSensorCount                       ; Check if key value in range.
   dec   A
.ThresholdLoop:                                       ; Loop through all sensors and scan
   push  A
   mov   X, A
   mov   [X+CSD_baBtnFThreshold], CSD_FINGER_THRESHOLD
   pop   A
   dec   A
   jnc   .ThresholdLoop
   RAM_EPILOGUE RAM_USE_CLASS_3
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_InitializeBaselines(void)
;
;  DESCRIPTION:
;    Scans all sensors to find their initial raw count values and loads these
;    into the baseline
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    None.
;  RETURNS:      None
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_InitializeBaselines:
_CSD_InitializeBaselines:
   RAM_PROLOGUE RAM_USE_CLASS_3

   mov   A,CSD_TotalSensorCount                       ; Get sensor num
   dec   A
.BaselineLoop:                                        ; Loop through all sensors and scan
   push  A
   call  CSD_ScanSensor
   RAM_X_POINTS_TO_INDEXPAGE
   pop   A
   push  A
   asl   A
   mov   X, A
   RAM_SETPAGE_IDX >CSD_waSnsResult
   mov A, [X+CSD_waSnsResult+LSB]
   RAM_SETPAGE_IDX >CSD_waSnsBaseline
   mov [X+CSD_waSnsBaseline+LSB], A
   RAM_SETPAGE_IDX >CSD_waSnsResult
   mov A, [X+CSD_waSnsResult+MSB]
   RAM_SETPAGE_IDX >CSD_waSnsBaseline
   mov [X+CSD_waSnsBaseline+MSB], A
   pop   A
   dec   A
   jnc   .BaselineLoop
   RAM_EPILOGUE RAM_USE_CLASS_3
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_InitializeSensorBaseline(BYTE bSensorNum)
;
;  DESCRIPTION:
;    Scans all sensors to find their initial raw count values and loads these
;    into the baseline
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    None.
;  RETURNS:      None
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_InitializeSensorBaseline:
_CSD_InitializeSensorBaseline:
   RAM_PROLOGUE RAM_USE_CLASS_3
   push  A
   call  CSD_ScanSensor
   RAM_X_POINTS_TO_INDEXPAGE
   pop A
   asl   A
   mov   X, A
   RAM_SETPAGE_IDX >CSD_waSnsResult
   mov A, [X+CSD_waSnsResult+LSB]
   RAM_SETPAGE_IDX >CSD_waSnsBaseline
   mov [X+CSD_waSnsBaseline+LSB], A
   RAM_SETPAGE_IDX >CSD_waSnsResult
   mov A, [X+CSD_waSnsResult+MSB]
   RAM_SETPAGE_IDX >CSD_waSnsBaseline
   mov [X+CSD_waSnsBaseline+MSB], A
   RAM_EPILOGUE RAM_USE_CLASS_3
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_bIsAnySensorActive(void)
;
;  DESCRIPTION:
;    Checks to see if any sensor is currently active
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    None.
;  RETURNS:      1 if any active, 0 if none active
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_bIsAnySensorActive:
_CSD_bIsAnySensorActive:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR 0 ; direct access ram will always be in interrupt ram area

   mov [CSD_fIsPressed], 0
   mov   A,CSD_TotalSensorCount
   dec   A
.ThresholdLoop:                                       ; Loop through all sensors
   push  A
   call  CSD_bIsSensorActive
   cmp   A, 1
   jnz    .NotActive
   mov [CSD_fIsPressed], 1
.NotActive:
   pop   A
   dec   A
   jnc   .ThresholdLoop
   mov   A, [CSD_fIsPressed]

.NoneActive:
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_UpdateAllBaselines(void)
;
;  DESCRIPTION:
;    Scans all sensors to find their raw count values
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    None.
;  RETURNS:      None
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_UpdateAllBaselines:
_CSD_UpdateAllBaselines:
   RAM_PROLOGUE RAM_USE_CLASS_4

   mov   A,CSD_TotalSensorCount
   dec   A
.ThresholdLoop:                                       ; Loop through all sensors
   push  A
   call  CSD_UpdateSensorBaseline
   pop   A
   dec   A
   jnc   .ThresholdLoop

   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

IF CSD_SLIDERS_EXIST
.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_wGetCentroidPos(BYTE bSnsGroup)
;
;  DESCRIPTION:
;      Checks the difference array for a centroid.  If one exists, the offset
;      (within the whole difference arrary) and length are placed in the
;      bCentroidLength and bCentroidStart variables.
;
;      Then the function finds and returns the position of the centroid in the
;      difference array.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;       A => Sensor Group
;       Sensor Group = 0 for the independent sensors group
;       Sensor Group = 1 for the first slider group
;       Sensor Group = 2 for the second slider group
;
;  RETURNS:
;      iCtrdPos -> position of the centroid
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_wGetCentroidPos:
_CSD_wGetCentroidPos:
; Legacy function name labels below, do not use for new designs
 CSD_bGetCentroidPos:
_CSD_bGetCentroidPos:
 CSD_iGetCentroidPos:
_CSD_iGetCentroidPos:
; End legacy function names
   RAM_PROLOGUE RAM_USE_CLASS_3
   RAM_SETPAGE_CUR 0 ; direct access ram will always be in interrupt ram area

; First get the starting location and size of this sensor group
   asl A ; multiply by two to get diplex
   mov X, A
   index CSD_Diplex_Table ; get the diplex table MSB and LSB
   mov [CSD_bDiplexMSB], A
   mov A, X
   inc A
   index CSD_Diplex_Table
   mov [CSD_bDiplexLSB], A
   mov A, X
   mov [CSD_bStartIndex], A ; Use bStartIndex as a temp storage byte
   asl A
   add [CSD_bStartIndex], A
   mov A, [CSD_bStartIndex] ; A now has slider offset multiplied by six
   mov X, A
   index CSD_Group_Table ; get first sensor index
   mov [CSD_bEndOfArray], A
   mov [CSD_bCurPos], A
   mov [CSD_bStartIndex], A
   mov A, X
   inc A
   index CSD_Group_Table ; get size of group
   add [CSD_bEndOfArray], A ; Store for later
   mov A, X
   add A, 2
   index CSD_Group_Table ; get if diplexed or not and max size of centroid (data = 0 if not diplexed)
   mov [CSD_bDiplexInfo], A ; Store for later
   mov A, X
   add A, 3
   mov [CSD_bSnsMaskPtr], A ; Store starting position in an unused temp CSD_bSnsMaskPtr

; First find the starting location and size of the largest centroid
   mov [CSD_bBiggestCtrdStartPos], 0
   mov [CSD_bBiggestCtrdSize], 0
   mov [CSD_bCurCtrdStartPos], 0
   mov [CSD_bCurCtrdSize], 0

   mov A, [CSD_bStartIndex]
   asl A ; multiply by two because we are using ints
   mov X, A

.LocateCtrd:
   RAM_SETPAGE_IDX >CSD_waSnsDiff
   mov A, [X+CSD_waSnsDiff]
   jnz .DiffIsNotZero
   mov A, [X+CSD_waSnsDiff+1]
   jnz .DiffIsNotZero
; The difference is zero, we either just ended a centroid or are between centroids
; First check the Current Size, if zero, we are in the middle of zeros, else, we just ended
.DifferenceIsZero:
   mov A, [CSD_bCurCtrdSize]
   jz .LocateCtrdNextSensor
; A centroid just ended.  Is it the largest centroid?
   cmp A, [CSD_bBiggestCtrdSize]
   jc .ClearCurCtrdSize
; It is the biggest so far, store as biggest
   mov [CSD_bBiggestCtrdSize], [CSD_bCurCtrdSize]
   mov [CSD_bBiggestCtrdStartPos], [CSD_bCurCtrdStartPos]
.ClearCurCtrdSize:
   mov [CSD_bCurCtrdSize], 0
   jmp .LocateCtrdNextSensor

;The difference is not zero, we either just started, or are in the middle of a centroid
.DiffIsNotZero:
   mov A, [CSD_bCurCtrdSize]
   jnz .IncCtrdSize
; Centroid just began, store the start pos
   mov A, [CSD_bCurPos]
   mov [CSD_bCurCtrdStartPos], A
.IncCtrdSize:
   inc [CSD_bCurCtrdSize]
; Find out the next position
.LocateCtrdNextSensor:
   inc X
   inc X
   inc [CSD_bCurPos]
   mov A, [CSD_bCurPos]
   cmp A, [CSD_bEndOfArray] ; Check for the end of the array
   jc .LocateCtrd
; Either at end of array, or diplexed
   tst [CSD_bDiplexInfo], 0xff ; check if diplexed
   jz .EndOfLocateCtrd
; Diplexed, so now find out if at end
   sub A, [CSD_bEndOfArray] ; subtract the size of the array
   add A, [CSD_bStartIndex] ; for comparison
   cmp A, [CSD_bEndOfArray] ; Check for the end of the array
   jnc .EndOfLocateCtrd
; Not the end of the diplexed array, find out offset of next position
   mov A, [CSD_bCurPos]
   sub A, [CSD_bStartIndex]
   add A, [CSD_bDiplexLSB]
   mov X, A
   mov A, [CSD_bDiplexMSB]
   adc A, 0 ; check if carry
   romx ; get the offset from the start
   add A, [CSD_bStartIndex]
   asl A ; because using ints
   mov X, A
   jmp .LocateCtrd
.EndOfLocateCtrd:
; Need to check if the current centroid is biggest
   mov A, [CSD_bCurCtrdSize]
   jz .CalculateCtrd
; There was a centroid at the end, is it biggest?
   cmp A, [CSD_bBiggestCtrdSize]
   jc .CalculateCtrd ; if two are the same size, last one wins
; It is the biggest so far, store as biggest
   mov [CSD_bBiggestCtrdSize], [CSD_bCurCtrdSize]
   mov [CSD_bBiggestCtrdStartPos], [CSD_bCurCtrdStartPos]

.CalculateCtrd:
   mov A, [CSD_bBiggestCtrdSize]
   jz .COM_Error
   mov A, [CSD_bDiplexInfo] ; check if diplexed
   jz .COM_Init
   cmp [CSD_bBiggestCtrdSize], 2
   jc .COM_Error ; for diplexing, one or less is too small
   cmp A, [CSD_bBiggestCtrdSize]
   jc .COM_Error ; for diplexing, check if centroid is too large

.COM_Init:
   mov A, [CSD_bBiggestCtrdStartPos] ; Use for current position, may be diplexed
   mov [CSD_bCurPos], A
   mov [CSD_wDenom+MSB], 0 ; Clear the numerator and denominator
   mov [CSD_wDenom+LSB], 0
   mov [CSD_dNumer+MMSB], 0
   mov [CSD_dNumer+MLSB], 0
   mov [CSD_dNumer+LMSB], 0
   mov [CSD_dNumer+LLSB], 0

.COM_NextPosition:
   mov A, [CSD_bCurPos]
   cmp A, [CSD_bEndOfArray]
   jnc .COM_CheckDiplex
   asl A
   mov X, A
   jmp .COM_AddElement
; Must be diplexed, check for safe measure
.COM_CheckDiplex:
   tst [CSD_bDiplexInfo], 0xff ; check if diplexed
   jz .COM_Compute
; Find out offset of next position
   mov A, [CSD_bCurPos]
   sub A, [CSD_bStartIndex]
   add A, [CSD_bDiplexLSB]
   mov X, A
   mov A, [CSD_bDiplexMSB]
   adc A, 0 ; check if carry
   romx ; get the offset from the start
   add A, [CSD_bStartIndex]
   asl A ; because using ints
   mov X, A
.COM_AddElement:
; Subtract the noise from the difference, this will yield a more accurate result
   RAM_SETPAGE_IDX >CSD_waSnsDiff
   mov A, [CSD_bNoiseThreshold]
   sub [X+CSD_waSnsDiff+LSB], A
   sbb [X+CSD_waSnsDiff+MSB], 0
; Store a copy of the sensor difference in CSD_dMultTempX
   mov A, [X+CSD_waSnsDiff+LSB]
   mov [CSD_dMultTempX+LLSB], A
; Add LSB to denominator
   add [CSD_wDenom+LSB], A
   mov A, [X+CSD_waSnsDiff]
   mov [CSD_dMultTempX+LMSB], A
   mov [CSD_dMultTempX+MLSB], 0
   mov [CSD_dMultTempX+MMSB], 0
; Add MSB to denominator
   adc [CSD_wDenom], A
   mov A, [CSD_bCurPos]
   sub A, [CSD_bStartIndex] ; we need offset from beginning of group
   mov [CSD_wDivBtwSns+MSB], 0
   mov [CSD_wDivBtwSns+LSB], A

   call .MultiplyNumeratorWhole

   inc [CSD_bCurPos]
   dec [CSD_bBiggestCtrdSize]
   jz .COM_Compute
   jmp .COM_NextPosition

.COM_Compute:
   mov A, [CSD_dNumer+LLSB] ; Move numerator to temp
   mov [CSD_dMultTempX+LLSB], A
   mov [CSD_dMultTempY+LLSB], A
   mov A, [CSD_dNumer+LMSB]
   mov [CSD_dMultTempX+LMSB], A
   mov [CSD_dMultTempY+LMSB], A
   mov A, [CSD_dNumer+MLSB]
   mov [CSD_dMultTempX+MLSB], A
   mov [CSD_dMultTempY+MLSB], A
   mov A, [CSD_dNumer+MMSB]
   mov [CSD_dMultTempX+MMSB], A
   mov [CSD_dMultTempY+MMSB], A

   mov [CSD_dNumer+MMSB], 0 ; Clear numerator
   mov [CSD_dNumer+MLSB], 0
   mov [CSD_dNumer+LMSB], 0
   mov [CSD_dNumer+LLSB], 0

   mov A, [CSD_bSnsMaskPtr] ; Retrieve starting position in index of the DivBtwSns
   push A
   index CSD_Group_Table ; get MSB of whole multiplier
   mov [CSD_wDivBtwSns+MSB], A
   pop A
   inc A
   push A
   index CSD_Group_Table ; get LSB of whole multiplier
   mov [CSD_wDivBtwSns+LSB], A
   call .MultiplyNumeratorWhole ; Multiplies by whole part
   pop A
   inc A
   index CSD_Group_Table ; get byte of fractional multiplier
   mov [CSD_wDivBtwSns+LSB], A
   call .MultiplyNumeratorFraction ; Multiplies by fractional part

; Now do the division of the numerator and denominator

; Round up the temp by half of the denominator (0.5 gets 1)
   mov A, [CSD_wDenom+MSB]
   mov [CSD_dMultTempX+MSB], A
   mov A, [CSD_wDenom+LSB]
   mov [CSD_dMultTempX+LSB], A
   and F, ~0x04 ; Clear carry bit if set
   rrc [CSD_dMultTempX+MSB] ; divide denominator by 2
   rrc [CSD_dMultTempX+LSB]
   mov A, [CSD_dMultTempX+LSB]
   add [CSD_dNumer+LLSB], A ; add 1/2 denominator
   mov A, [CSD_dMultTempX+MSB]
   adc [CSD_dNumer+LMSB], A
   adc [CSD_dNumer+MLSB], 0
   adc [CSD_dNumer+MMSB], 0

; Compute the division of numerator divided by denominator
   asl [CSD_dNumer+LLSB]
   rlc [CSD_dNumer+LMSB]
   rlc [CSD_dNumer+MLSB]
   rlc [CSD_dNumer+MMSB]
   mov X, 16
.DivideLoop:
; Subtract the divisor or denominator from the MMSB MLSB dividend or numerator
   mov A, [CSD_wDenom+LSB]
   sub [CSD_dNumer+MLSB], A
   mov A, [CSD_wDenom+MSB]
   sbb [CSD_dNumer+MMSB], A
; Check if less than zero
   jnc .SetLSbToOneAndShift
.AddBackSetLSbToZeroAndShift:
; Less than zero so add back to dividend and shift a zero into the dividend
   mov A, [CSD_wDenom+LSB]
   add [CSD_dNumer+MLSB], A
   mov A, [CSD_wDenom+MSB]
   adc [CSD_dNumer+MMSB], A
   asl [CSD_dNumer+LLSB]
   rlc [CSD_dNumer+LMSB]
   rlc [CSD_dNumer+MLSB]
   rlc [CSD_dNumer+MMSB]
   dec X
   jnz .DivideLoop
   jmp .EndOfDivide
.SetLSbToOneAndShift:
   asl [CSD_dNumer+LLSB]
   or [CSD_dNumer+LLSB], 0x01
   rlc [CSD_dNumer+LMSB]
   rlc [CSD_dNumer+MLSB]
   rlc [CSD_dNumer+MMSB]
   dec X
   jnz .DivideLoop
.EndOfDivide:
; MMSB and MLSB have carry after shifted right once
   rrc [CSD_dNumer+MMSB]
   rrc [CSD_dNumer+MLSB]
; Load return value
   mov X, [CSD_wCtrdPos+MSB]
   mov A, [CSD_wCtrdPos+LSB]
   jmp .EndGetCtrdPos
.COM_Error:
; Load error return value
   mov A, 0xff
   mov X, 0xff
.EndGetCtrdPos:
; Algorithm is finished, position is in [CSD_wCtrdPos]
   RAM_EPILOGUE RAM_USE_CLASS_3
   ret

; Multiplication algorithm (for whole numbers)
.MultiplyNumeratorWhole:
   mov A, 0x01
.CheckToAddNext2xLSB:
   push A
   and A, [CSD_wDivBtwSns+LSB] ; See if current 2^x needs added
   jz .SkipAddAndShiftLeftLSB
   mov A, [CSD_dMultTempX+LLSB]
   add [CSD_dNumer+LLSB], A
   mov A, [CSD_dMultTempX+LMSB]
   adc [CSD_dNumer+LMSB], A
   mov A, [CSD_dMultTempX+MLSB]
   adc [CSD_dNumer+MLSB], A
   mov A, [CSD_dMultTempX+MMSB]
   adc [CSD_dNumer+MMSB], A
.SkipAddAndShiftLeftLSB:
   asl [CSD_dMultTempX+LLSB]
   rlc [CSD_dMultTempX+LMSB]
   rlc [CSD_dMultTempX+MLSB]
   rlc [CSD_dMultTempX+MMSB]
   pop A
   asl A
   jnc .CheckToAddNext2xLSB
   mov A, [CSD_wDivBtwSns+MSB]
   jz .EndMultiplyNumeratorWhole ; only multiply by MSB if needed
   mov A, 0x01
.CheckToAddNext2xMSB:
   push A
   and A, [CSD_wDivBtwSns+MSB] ; See if current 2^x needs added
   jz .SkipAddAndShiftLeftMSB
   mov A, [CSD_dMultTempX+LLSB]
   add [CSD_dNumer+LLSB], A
   mov A, [CSD_dMultTempX+LMSB]
   adc [CSD_dNumer+LMSB], A
   mov A, [CSD_dMultTempX+MLSB]
   adc [CSD_dNumer+MLSB], A
   mov A, [CSD_dMultTempX+MMSB]
   adc [CSD_dNumer+MMSB], A
.SkipAddAndShiftLeftMSB:
   asl [CSD_dMultTempX+LLSB]
   rlc [CSD_dMultTempX+LMSB]
   rlc [CSD_dMultTempX+MLSB]
   rlc [CSD_dMultTempX+MMSB]
   pop A
   asl A
   jnc .CheckToAddNext2xMSB
.EndMultiplyNumeratorWhole:
   ret

; Multiplication algorithm (for fractional numbers)
.MultiplyNumeratorFraction:
   and F, ~0x04 ; clear carry bit if set
   rrc [CSD_dMultTempY+MMSB]
   rrc [CSD_dMultTempY+MLSB]
   rrc [CSD_dMultTempY+LMSB]
   rrc [CSD_dMultTempY+LLSB]
   mov A, 0x80
.CheckToAddNextHalf:
   push A
   and A, [CSD_wDivBtwSns+LSB]
   jz .SkipAddAndShiftRight
   mov A, [CSD_dMultTempY+LLSB]
   add [CSD_dNumer+LLSB], A
   mov A, [CSD_dMultTempY+LMSB]
   adc [CSD_dNumer+LMSB], A
   mov A, [CSD_dMultTempY+MLSB]
   adc [CSD_dNumer+MLSB], A
   mov A, [CSD_dMultTempY+MMSB]
   adc [CSD_dNumer+MMSB], A
.SkipAddAndShiftRight:
   asr [CSD_dMultTempY+MMSB]
   rrc [CSD_dMultTempY+MLSB]
   rrc [CSD_dMultTempY+LMSB]
   rrc [CSD_dMultTempY+LLSB]
   pop A
   and F, ~0x04 ; clear carry bit if set
   rrc A
   jnc .CheckToAddNextHalf
   ret

.ENDSECTION

.LITERAL
CSD_SLIDER_RESOLUTION_TABLE:
dw 0x64

.ENDLITERAL

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_wGetRadialInc(BYTE bSnsGroup)
;  DESCRIPTION:
;
;-----------------------------------------------------------------------------
;  ARGUMENTS:
;       A => Sensor Group
;       Sensor Group = 0 for the independent sensors group
;       Sensor Group = 1 for the first slider group
;       Sensor Group = 2 for the second slider group
;  RETURNS:
;      result - offset (positive or negative)  through X and A
;-----------------------------------------------------------------------------
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;-----------------------------------------------------------------------------

 CSD_wGetRadialInc:
_CSD_wGetRadialInc:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_PROLOGUE RAM_USE_CLASS_3
   RAM_SETPAGE_CUR 0 ; direct access ram will always be in interrupt ram area

   mov [CSD_bCurCtrdSize], A  ;saves slider number
   dec [CSD_bCurCtrdSize]
   asl [CSD_bCurCtrdSize]

   mov X, [CSD_bCurCtrdSize]
   RAM_SETPAGE_IDX >CSD_waSliderPrevPos
   cmp [X + CSD_waSliderPrevPos + 0], FFh
   jnz .CurrCheck
   cmp [X + CSD_waSliderPrevPos + 1], FFh
   jnz .CurrCheck

   mov X, 00h
   mov A, 00h
   jmp .Done

.CurrCheck:
   RAM_SETPAGE_IDX >CSD_waSliderCurrPos
   cmp [X + CSD_waSliderCurrPos + 0], FFh
   jnz .Calculations
   cmp [X + CSD_waSliderCurrPos + 1], FFh
   jnz .Calculations

   mov X, 00h
   mov A, 00h
   jmp .Done

.Calculations:
   ;getting A*6
   mov A,  [CSD_bCurCtrdSize]
   index CSD_SLIDER_RESOLUTION_TABLE
   mov [CSD_wCurPkValue + 0], A
   mov A,  [CSD_bCurCtrdSize]
   inc A
   index CSD_SLIDER_RESOLUTION_TABLE
   mov [CSD_wCurPkValue + 1], A

   ;wDenom = Resolution/2
   mov A, [CSD_wCurPkValue + 0]
   asr A
   mov [CSD_wDenom + 0], A
   mov A, [CSD_wCurPkValue + 1]
   rrc A
   mov [CSD_wDenom + 1], A

   mov X, [CSD_bCurCtrdSize]

   ;detect direction of the motion
   RAM_SETPAGE_IDX >CSD_waSliderCurrPos
   mov A, [X + CSD_waSliderCurrPos + 1]
   RAM_SETPAGE_IDX >CSD_waSliderPrevPos
   sub A, [X + CSD_waSliderPrevPos + 1]
   mov [CSD_dMultTempY + 1], A

   RAM_SETPAGE_IDX >CSD_waSliderCurrPos
   mov A, [X + CSD_waSliderCurrPos + 0]
   RAM_SETPAGE_IDX >CSD_waSliderPrevPos
   sbb A, [X + CSD_waSliderPrevPos + 0]
   mov [CSD_dMultTempY + 0], A

   tst [CSD_dMultTempY + 0], 80h
   jnz .DiffIsNegative ;negative

   ;positive
   mov A, [CSD_dMultTempY + 0]
   cmp A, [CSD_wDenom + 0]
   jc .LessThenAHalfOfResol1
   jnz .GreaterThenAHalfOfResol1

   mov A, [CSD_dMultTempY + 1]
   cmp A, [CSD_wDenom + 1]
   jc .LessThenAHalfOfResol1
   jmp .GreaterThenAHalfOfResol1

.LessThenAHalfOfResol1:
   ;Less than a half of resolution
   mov X, [CSD_dMultTempY + 0]
   mov A, [CSD_dMultTempY + 1]
   jmp .Done

.GreaterThenAHalfOfResol1:
   mov A, [CSD_dMultTempY + 1]
   sub A, [CSD_wCurPkValue + 1]
   mov X, A
   mov A, [CSD_dMultTempY + 0]
   sbb A, [CSD_wCurPkValue + 0]
   swap A, X
   jmp .Done

.DiffIsNegative:
   mov A, [CSD_dMultTempY + 1]
   cpl A
   inc A
   mov [CSD_dMultTempX + 1], A
   mov A, [CSD_dMultTempY + 0]
   cpl A
   adc A, 0

   cmp A, [CSD_wDenom + 0]
   jc .LessThenAHalfOfResol2
   jnz .GreaterThenAHalfOfResol2

   mov A, [CSD_dMultTempX + 1]
   cmp A, [CSD_wDenom + 1]
   jc .LessThenAHalfOfResol2
   jmp .GreaterThenAHalfOfResol2

.LessThenAHalfOfResol2:  ;!!!!!!need optimization
   ;Less than a half of resolution
   mov X, [CSD_dMultTempY + 0]
   mov A, [CSD_dMultTempY + 1]
   jmp .Done

.GreaterThenAHalfOfResol2:
   mov A, [CSD_dMultTempY + 1]
   add [CSD_wCurPkValue + 1], A
   mov A, [CSD_dMultTempY + 0]
   adc [CSD_wCurPkValue + 0], A
   mov X, [CSD_wCurPkValue + 0]
   mov A, [CSD_wCurPkValue + 1]

.Done:
   RAM_EPILOGUE RAM_USE_CLASS_3
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.LITERAL
CSD_RADIAL_SLIDER_RESOLUTION_MULTIPLIER_TABLE:
IF (ah)
  dw 64h * 256 / ah
ENDIF 
 
IF (1h)
  dw 1h * 256 / 1h
ENDIF  

IF (1h)
  dw 1h * 256 / 1h
ENDIF  

IF (1h)
  dw 1h * 256 / 1h
ENDIF  

IF (1h)
  dw 1h * 256 / 1h
ENDIF  

IF (1h)
  dw 1h * 256 / 1h
ENDIF  

IF (1h)
  dw 1h * 256 / 1h
ENDIF  

IF (1h)
  dw 1h * 256 / 1h
ENDIF  

IF (1h)
  dw 1h * 256 / 1h
ENDIF  

IF (1h)
  dw 1h * 256 / 1h
ENDIF  

IF (1h)
  dw 1h * 256 / 1h
ENDIF  
  
IF (CSD_SliderCount - 12)
ELSE
  IF (1h)
      dw @SliderOutputResolution_11h * 256 / 1h
  ENDIF  
ENDIF
.ENDLITERAL

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_wGetRadialPos(BYTE bSnsGroup)
;  DESCRIPTION:
;      The function finds and returns the position of the centroid in the
;      difference array.
;-----------------------------------------------------------------------------
;  ARGUMENTS:
;       A => Sensor Group
;       Sensor Group = 0 for the independent sensors group
;       Sensor Group = 1 for the first slider group
;       Sensor Group = 2 for the second slider group
;  RETURNS:
;      result - centroid position (through X and A)
;-----------------------------------------------------------------------------
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;-----------------------------------------------------------------------------

 CSD_wGetRadialPos:
_CSD_wGetRadialPos:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_PROLOGUE RAM_USE_CLASS_3
   RAM_SETPAGE_CUR 0 ; direct access ram will always be in interrupt ram area
   mov [CSD_bCurCtrdSize], A  ;saves slider number
   dec [CSD_bCurCtrdSize]
   asl [CSD_bCurCtrdSize]

   ;getting A*6
   asl   A       ; A*2
   mov  [CSD_bCurSlider], A ;temporary saving A*2
   asl   A       ;A*4
   add  [CSD_bCurSlider], A ;A*6
   mov  A, [CSD_bCurSlider] ;now A points on bSnsgroup offset in Group table
   index CSD_Group_Table
   mov [CSD_bStartIndex], A ;getting desired slider offset for waSnsDiff array
   mov [CSD_bEndOfArray], A
   mov  A, [CSD_bCurSlider]
   inc A
   index CSD_Group_Table
   add [CSD_bEndOfArray], A ;getting final index in waSnsDiff for desired slider

   mov A, [CSD_bCurCtrdSize]
   index CSD_RADIAL_SLIDER_RESOLUTION_MULTIPLIER_TABLE
   mov [CSD_wCurPkValue + 0], A
   mov A, [CSD_bCurCtrdSize]
   inc A
   index CSD_RADIAL_SLIDER_RESOLUTION_MULTIPLIER_TABLE
   mov [CSD_wCurPkValue + 1], A

   asl [CSD_bEndOfArray]    ;*2 because we operating with WORDs
   asl [CSD_bStartIndex]    ;*2 because we operating with WORDs
   sub [CSD_bEndOfArray], 2 ;now it points on the last element

   ;These two variables contain required maximum
   mov [CSD_bBiggestCtrdSize], 0        ;MSB
   mov [CSD_bBiggestCtrdStartPos], 0    ;LSB

   mov [CSD_bCurPos], 0                 ;this variable saves maximum position
   mov X, [CSD_bStartIndex]             ;X - current position; access  will be performed through X (base+offset)

.IdentifyCtrd:
   RAM_SETPAGE_IDX >CSD_waSnsDiff
   mov A, [X + CSD_waSnsDiff]
   jnz .CheckIfMaximum
   mov A, [X + CSD_waSnsDiff + 1]
   jnz .DiffIsNotZero

;Difference is zero:
   jmp .CheckNextSensor

.DiffIsNotZero:
   push X
   mov A, X
   asr A
   mov X, A
   RAM_SETPAGE_IDX >CSD_baBtnFThreshold
   mov A, [X + CSD_baBtnFThreshold]
   pop X
   RAM_SETPAGE_IDX >CSD_waSnsDiff
   cmp A, [X + CSD_waSnsDiff + 1] ;Compare With FThreshold
   jnc .CheckNextSensor
   jz .CheckNextSensor

;waSnsDiff is greater than threshold
.CheckIfMaximum:
   ;Compare MSBs
   mov A, [X + CSD_waSnsDiff]
   cmp A, [CSD_bBiggestCtrdSize]
   jc .CheckNextSensor
   jnz .StoreNewMaximum

   ;Compare LSBs
   mov A, [X + CSD_waSnsDiff + 1]
   cmp A, [CSD_bBiggestCtrdStartPos]
   jc .CheckNextSensor
   jz .CheckNextSensor

;waSnsDiff is greater then stored maximum; saving new maximum
.StoreNewMaximum:
   mov A, [X + CSD_waSnsDiff]
   mov [CSD_bBiggestCtrdSize], A
   mov A, [X + CSD_waSnsDiff + 1]
   mov [CSD_bBiggestCtrdStartPos], A
   mov [CSD_bCurPos], X ;this is a new maximum position

; Find out the next position
.CheckNextSensor:
   inc X
   inc X
   mov A, X
   cmp A, [CSD_bEndOfArray] ; Check for the end of the array
   jc .IdentifyCtrd
   jz .IdentifyCtrd

;---------Centroid calculation---------

   ;if there is no finger touch then return FFFFh
   mov A, [CSD_bBiggestCtrdSize]
   jnz .FillCentroidArray

   mov A, [CSD_bBiggestCtrdStartPos]
   jnz .FillCentroidArray

   ;There was no finger present: return FFFFh value through X, A
   ;and save the same in CSD_waSliderCurrPos
   mov X, [CSD_bCurCtrdSize]

   ;Copy CSD_waSliderCurrPos to CSD_waSliderPrevPos
   RAM_SETPAGE_IDX >CSD_waSliderCurrPos
   mov A, [X + CSD_waSliderCurrPos]
   RAM_SETPAGE_IDX >CSD_waSliderPrevPos
   mov [X + CSD_waSliderPrevPos], A
   RAM_SETPAGE_IDX >CSD_waSliderCurrPos
   mov A, [X + CSD_waSliderCurrPos + 1]
   RAM_SETPAGE_IDX >CSD_waSliderPrevPos
   mov [X + CSD_waSliderPrevPos + 1], A

   ;set CSD_waSliderCurrPos to FFFFh
   RAM_SETPAGE_IDX >CSD_waSliderCurrPos
   mov [X + CSD_waSliderCurrPos], FFh
   mov [X + CSD_waSliderCurrPos + 1], FFh

.SetResultToFFFFh:
   mov A, FFh
   mov X, FFh
   jmp .Done

.FillCentroidArray:
   ;There was a finger present
   ;Fill waCentroid array with elements : centroid and its left and right adjacent values
   RAM_SETPAGE_IDX >CSD_waSnsDiff

   ;waCentroid[3] - array of three values: left adjacent, centroid, right adjacent
   ;waCentroid + 0  MSB of left adjacent
   ;waCentroid + 1  LSB of left adjacent
   ;waCentroid + 2  MSB of centroid
   ;waCentroid + 3  LSB of centroid
   ;waCentroid + 4  MSB of right adjacent
   ;waCentroid + 5  LSB of right adjacent

   ;1) left adjacent
   mov A, [CSD_bCurPos]
   cmp A, [CSD_bStartIndex]
   jnz .CentriodIsNotInFirstPos

   ;Centroid is at first position
   mov X, [CSD_bEndOfArray] ;left adjacent(i-1)
   jmp .CopyingLeft

.CentriodIsNotInFirstPos:
   mov X, [CSD_bCurPos] ;left adjacent(i-1)
   dec X
   dec X

.CopyingLeft:
   mov A, [X + CSD_waSnsDiff + LSB]
   mov [CSD_waCentroid + 1], A
   mov A, [X + CSD_waSnsDiff + MSB]
   mov [CSD_waCentroid + 0], A

   ;2) Maximum
   mov X, [CSD_bCurPos] ;maximum(i)

.CopyingMaximum:
   mov A, [X + CSD_waSnsDiff + LSB]
   mov [CSD_waCentroid + 3], A
   mov A, [X + CSD_waSnsDiff + MSB]
   mov [CSD_waCentroid + 2], A

   ;3) right adjacent
   mov A, [CSD_bCurPos]
   cmp A, [CSD_bEndOfArray]
   jnz .CentriodIsNotInLastPos

   ;Centroid is at last position
   mov X, [CSD_bStartIndex] ;right adjacent(i+1)
   jmp .CopyingRight

.CentriodIsNotInLastPos:
   mov X, [CSD_bCurPos] ;right adjacent(i+1)
   inc X
   inc X

.CopyingRight:
   mov A, [X + CSD_waSnsDiff + LSB]
   mov [CSD_waCentroid + 5], A
   mov A, [X + CSD_waSnsDiff + MSB]
   mov [CSD_waCentroid + 4], A

   mov A, [CSD_bNoiseThreshold]
.SubstractNoise0:
   sub [CSD_waCentroid + 1], A
   sbb [CSD_waCentroid + 0], 0
   jnc .SubstractNoise1

   mov [CSD_waCentroid + 1], 0
   mov [CSD_waCentroid + 0], 0

.SubstractNoise1:
   sub [CSD_waCentroid + 3], A
   sbb [CSD_waCentroid + 2], 0
   jnc .SubstractNoise2

   mov [CSD_waCentroid + 3], 0
   mov [CSD_waCentroid + 2], 0

.SubstractNoise2:
   sub [CSD_waCentroid + 5], A
   sbb [CSD_waCentroid + 4], 0
   jnc .RestoreX

   mov [CSD_waCentroid + 5], 0
   mov [CSD_waCentroid + 4], 0

.RestoreX:
   mov X, [CSD_bCurPos]

   call CalcCentroid
   ;result is now in dMultTempY variable

   mov X, [CSD_bCurCtrdSize]

   ;there was finger presence before (during last function call)
   RAM_SETPAGE_IDX >CSD_waSliderCurrPos
   mov A, [X + CSD_waSliderCurrPos]
   RAM_SETPAGE_IDX >CSD_waSliderPrevPos
   mov [X + CSD_waSliderPrevPos], A
   RAM_SETPAGE_IDX >CSD_waSliderCurrPos
   mov A, [X + CSD_waSliderCurrPos + 1]
   RAM_SETPAGE_IDX >CSD_waSliderPrevPos
   mov [X + CSD_waSliderPrevPos + 1], A

   mov A, [CSD_dMultTempY + 0];MSB of result
   RAM_SETPAGE_IDX >CSD_waSliderCurrPos
   mov [X + CSD_waSliderCurrPos], A

   mov A, [CSD_dMultTempY + 1];LSB of result
   RAM_SETPAGE_IDX >CSD_waSliderCurrPos
   mov [X + CSD_waSliderCurrPos + 1], A

   mov X, [CSD_dMultTempY + 0]

.Done:
   RAM_EPILOGUE RAM_USE_CLASS_3
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: void CalcCentroid(WORD result)
;  DESCRIPTION:
;    Calculates touch position using centroid algorithm basing on 3 signals
;    (local maximum and adjacent)
;-----------------------------------------------------------------------------
;  ARGUMENTS:
;    None, signal values are taken from waCentroid global array
;  RETURNS:
;   calculated touch position
;-----------------------------------------------------------------------------
 CalcCentroid:
_CalcCentroid:
   ;Zeroing
   mov   A, 0
   mov   [CSD_dMultTempX + 0], A
   mov   [CSD_dMultTempX + 1], A
   mov   [CSD_dMultTempX + 3], A
   mov   [CSD_wDenom + 0], A

   ;---calculate denominator: (i- 1 ) + i + (i+1)
   mov   A, [CSD_waCentroid + 1]                 ;LSB(i-1)
   add   A, [CSD_waCentroid + 3]                 ;add LSB(i)
   adc   [CSD_wDenom + 0], 0                     ;save carry
   add   A, [CSD_waCentroid + 5]                 ;add LSB(i + 1)
   adc   [CSD_wDenom + 0], 0                     ;save carry
   mov   [CSD_wDenom + 1], A                     ;save result

   mov   A, [CSD_waCentroid + 0]                 ;MSB(i-1)
   add   A, [CSD_waCentroid + 2]                 ;add MSB(i)
   add   A, [CSD_waCentroid + 4]                 ;add MSB(i + 1)
   add   [CSD_wDenom + 0], A                     ;save result

   ;----- calculate numerator (i+1) - (i-1)
   mov   A, [CSD_waCentroid + 5]                 ;LSB(i+1)
   sub   A, [CSD_waCentroid + 1]                 ;sub LSB(i-1)
   sbb   [CSD_dMultTempX + 1], 0                 ;save borrow
   mov   [CSD_dMultTempX + 2], A                 ;save result

   mov   A, [CSD_waCentroid + 4]                 ;MSB(i+1)
   sub   A, [CSD_waCentroid + 0]                 ;sub MSB(i-1)
   add   [CSD_dMultTempX + 1], A                 ;save result

   call  CSD_div_24_16_24                        ; calculate Sum(Si*i)/Sum(Si)
   mov   A, X
   sub   A, [CSD_bStartIndex]
   asr   A
   add   [CSD_dMultTempX + 2], A                 ;

   tst   [CSD_dMultTempX + 2], 80h
   jz .Mult

   mov   A, [CSD_bEndOfArray]
   sub   A, [CSD_bStartIndex]
   asr   A
   inc   A
   add   [CSD_dMultTempX + 2], A                 ;

.Mult:
   call  CSD_mul_16x16_32                       ; dMultTempY contains calculated coordinate (two MSB)

   mov    A, [CSD_dMultTempY]                    ; Returns result through X an d A
   mov    X, A
   mov    A, [CSD_dMultTempY+1]

   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_div_24_16_24
;  DESCRIPTION:
;  Applies 24-bit signed result of 24-bit signed operands division
;-----------------------------------------------------------------------------
;  ARGUMENTS:
;   (MSB)[dMultTempX+1][dMultTempX+2][dMultTempX+3](LSB) - first 24-bit signed operand of division
;                                    (dividend)
;   (MSB)[wDenom][wDenom+1](LSB) - second 16-bit unsigned operand of division
;                                     (divisor)
;  RETURNS:   (MSB)[dMultTempX+1][dMultTempX+2][dMultTempX+3](LSB) - 24-bit signed operand of division
;                                    (dividend)
;-----------------------------------------------------------------------------
 CSD_div_24_16_24:
_CSD_div_24_16_24:
    mov   A,0xFF
    cmp   [CSD_dMultTempX + 1],0x80
    jc    .L1                         ;check sign of operand 1
    xor   [CSD_dMultTempX + 3],A            ;unsigned convertation of operand 1 (inversion + 1)
    inc   [CSD_dMultTempX + 3]
    xor   [CSD_dMultTempX + 2],A
    adc   [CSD_dMultTempX + 2],0x00
    xor   [CSD_dMultTempX + 1],A
    adc   [CSD_dMultTempX + 1],0x00
    mov   [CSD_dMultTempX + 0], A

.L1:
    mov   A,0x00
    mov   [CSD_dMultTempY + 0],A  ;additional temporary memory for calculations
    mov   [CSD_dMultTempY + 1],A
    mov   [CSD_dMultTempY + 2],A
    mov   [CSD_dMultTempY + 3],A

    mov   [CSD_bCurPkPos], 24          ;amount of cycles divider procedure

	;Begin of divider procedure
j4_1:
    asl   [CSD_dMultTempX + 3]
    rlc   [CSD_dMultTempX + 2]
    rlc   [CSD_dMultTempX + 1]

    rlc   [CSD_dMultTempY + 3]
    rlc   [CSD_dMultTempY + 2]
    rlc   [CSD_dMultTempY + 1]

    mov   A,[CSD_dMultTempY + 3]
    sbb   A,[CSD_wDenom + 1]
    mov   A,[CSD_dMultTempY + 2]
    sbb   A,[CSD_wDenom + 0]
    mov   A,[CSD_dMultTempY + 1]
    sbb   A, 0
    jc    j4_2
    mov   [CSD_dMultTempY + 1],A
    mov   A,[CSD_wDenom + 1]
    sub   [CSD_dMultTempY + 3],A
    mov   A,[CSD_wDenom + 0]
    sbb   [CSD_dMultTempY + 2],A
    inc   [CSD_dMultTempX + 3]
j4_2:
    dec   [CSD_bCurPkPos]
    jnz   j4_1

    ;End of divider procedure
    mov    A, 0xFF
    cmp   [CSD_dMultTempX + 0],0x80
    jc    .L2                         ;check sign of result
    xor   [CSD_dMultTempX + 3],A            ;unsigned convertation of operand 1
    inc   [CSD_dMultTempX + 3]
    xor   [CSD_dMultTempX + 2],A
    adc   [CSD_dMultTempX + 2],0x00
    xor   [CSD_dMultTempX + 1],A
    adc   [CSD_dMultTempX + 1],0x00
    xor   [CSD_dMultTempX + 0],A
.L2:

    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FRAGMENT NAME: CSD_mul_16x16_32
;  DESCRIPTION:
;      Ancillary fragment for integer fastcall16 functions. Applies 32-bit
;      unsigned result of two 16-bit unsigned operands multiplication
;-----------------------------------------------------------------------------
;  ARGUMENTS:
;      (MSB)[dMultTempX+2][dMultTempX+3](LSB) - 16-bit unsigned multiplier (first operand)
;     wCurPkValue - 16-bit unsigned multiplicand (second operand)
;  RETURNS:
;      (MSB)[dMultTempY][dMultTempY+1][wCurPkValue + 0][wCurPkValue + 1](LSB) - 32-bit unsigned multiplication result
;-----------------------------------------------------------------------------
 CSD_mul_16x16_32:
_CSD_mul_16x16_32:
    mov   A,0x00
    mov   [CSD_dMultTempY + 0],A                 ; clear LSB of result
    mov   [CSD_dMultTempY + 1],A               ; clear MSB of result

    add   A,0x10                   ;clear CARRY-bit and
    mov   [CSD_bCurPkPos],A                 ;init loop counter

.jLab2:
    tst   [CSD_wCurPkValue + 1],0x01
    jz    .jLab1
    mov   A,[CSD_dMultTempX+3]               ;if [wTmp2+LSB].0=1 then result+=first operand
    add   [CSD_dMultTempY+1],A
    mov   A,[CSD_dMultTempX+2]
    adc   [CSD_dMultTempY],A
.jLab1:
    rrc   [CSD_dMultTempY]                 ; 1-bit right shift of second operand
    rrc   [CSD_dMultTempY+1]
    rrc   [CSD_wCurPkValue + 0]               ; 1-bit left shift of first operand
    rrc   [CSD_wCurPkValue + 1]
    dec   [CSD_bCurPkPos]               ; decrement loop counter
    jnz   .jLab2

    ret
.ENDSECTION

ENDIF
