//----------------------------------------------------------------------------
// C main line
//----------------------------------------------------------------------------

#include <m8c.h>        // part specific constants and macros
#include "PSoCAPI.h"    // PSoC API definitions for all User Modules

#define ButtonCount 5
void Load_Capsense(void);
char flag;
char initialize;
char initialize1;

char key_pressed;
char i;
	
void main(void)
{
	flag = 0;
	initialize = 0;
	initialize1 = 0;
	LED_Off();
	LED_1_Off();
	M8C_EnableGInt;
	CSD_Start();
	CSD_SetDefaultFingerThresholds();

	CSD_SetScanMode(2,12);
	for(i=0;i < 5; i++)
	CSD_InitializeSensorBaseline(i);

	CSD_EnableSensor(0x10, 1); //1[4]
	CSD_EnableSensor(0x40, 0); //0[6]
	CSD_EnableSensor(0x10, 0); //0[4]
	CSD_EnableSensor(0x04, 0); //0[2]
	CSD_EnableSensor(0x40, 2); //2[6]
	CSD_EnableSensor(0x10, 2); //2[4]
	CSD_EnableSensor(0x04, 2); //2[2]
	CSD_EnableSensor(0x01, 2); //2[0]
	CSD_EnableSensor(0x04, 3); //3[2]
	CSD_EnableSensor(0x01, 3); //3[0]
	
	// Initialize baseline for sensor number "4"
	CSD_InitializeSensorBaseline(9);
	TX8SW_Start();
		
	while (1) {
	
		if(flag == 0)
		{
			CSD_EnableSensor(0x10, 1); //1[4]
			CSD_EnableSensor(0x40, 0); //0[6]
			CSD_EnableSensor(0x10, 0); //0[4]
			CSD_EnableSensor(0x04, 0); //0[2]
			CSD_EnableSensor(0x40, 2); //2[6]
			CSD_EnableSensor(0x10, 2); //2[4]
			CSD_EnableSensor(0x04, 2); //2[2]
			CSD_EnableSensor(0x01, 2); //2[0]
			CSD_EnableSensor(0x04, 3); //3[2]
			CSD_EnableSensor(0x01, 3); //3[0]
			CSD_SetScanMode(2,16);
			CSD_ScanSensor(9);
			//update all the baselines to track the RawCounts
			CSD_UpdateSensorBaseline(9);
				if(CSD_bIsSensorActive(9))
				{
					LED_On();
					flag = 1;
				}
				else
				LED_Off();	
		}	
		else
		{
			Load_Capsense();
		}
		//Send the RawCounts, Baselines and difference counts of
		//all the sensors through TX8SW
		
		//Send the Header
		TX8SW_PutCRLF();
		//Send the data
		TX8SW_Write((char *) (CSD_waSnsResult), (CSD_TotalSensorCount)*2);
		TX8SW_Write((char *) (CSD_waSnsBaseline), (CSD_TotalSensorCount)*2);
		TX8SW_Write((char *) (CSD_waSnsDiff), (CSD_TotalSensorCount)*2);
		
		//Send the Tail
		TX8SW_PutChar(0);
		TX8SW_PutChar((CHAR)0xFF);
		TX8SW_PutChar((CHAR)0xFF);
	} 
	
}

void Load_Capsense(void)
{

		CSD_DisableSensor(0x10, 1); //1[4]
		CSD_DisableSensor(0x40, 0); //0[6]
		CSD_DisableSensor(0x10, 0); //0[4]
		CSD_DisableSensor(0x04, 0); //0[2]
		CSD_DisableSensor(0x40, 2); //2[6]
		CSD_DisableSensor(0x10, 2); //2[4]
		CSD_DisableSensor(0x04, 2); //2[2]
		CSD_DisableSensor(0x01, 2); //2[0]
		CSD_DisableSensor(0x04, 3); //3[2]
		CSD_DisableSensor(0x01, 3); //3[0]

		CSD_SetScanMode(2,12);
		for(i=0;i < 5; i++)
		{
			CSD_ScanSensor(i);
			CSD_UpdateSensorBaseline(i);
		}
		for(i=0;i < 5; i++)
		{
			if(CSD_bIsSensorActive(i))
			key_pressed++;
		}	
		if(key_pressed == 0)
		{
			flag = 0;
			LED_1_Off();
			
		}
		else
		{
			LED_1_On();
			key_pressed = 0;
		}
}
