/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/
#include <project.h>

#define BUFFER_SIZE                 (4u)

/* Receive buffer */
static uint8 rxBuff[BUFFER_SIZE];

/* Data to be transmitted by Tx */
uint8 txBuff[BUFFER_SIZE] = {0xCAu, 0xFEu, 0xFAu, 0xCEu};

void DmaRxConfiguration(void);
void DmaTxConfiguration(void);
void DisplayUpdate(void);

int main()
{
    I2S_1_Start();
    
    /* Configure DMAs for each direction */ 
    DmaRxConfiguration();
    DmaTxConfiguration();
    
    
    I2S_1_EnableRx();
    
    int readRegister = (I2S_1_ReadTxStatus() & I2S_1_TX_FIFO_0_NOT_FULL);

    while(0u != (I2S_1_ReadTxStatus() & I2S_1_TX_FIFO_0_NOT_FULL))
    {
        /* Wait for TxDMA to fill Tx FIFO */
        int readRegister = I2S_1_ReadTxStatus();
    }
    
    CyDelayUs(1);
    I2S_1_EnableTx();   /* Enable Tx direction */
    for(;;)
    {
        /* Print out Tx and Rx data onto LCD */
        DisplayUpdate();
        
        /* Execute following tasks once every second */
        CyDelay(1000u);
        
        txBuff[0u]++;
    }
}

/*******************************************************************************
*  Function Name: DisplayUpdate
********************************************************************************
*
* Summary:
*  This function prints out the Tx and Rx data.  
*
* Parameters:
*  None.
*
* Return:
*  None.
*
*******************************************************************************/
void DisplayUpdate(void)
{
    uint8 data;
    uint8 idx;
	for(idx = 0u; idx < BUFFER_SIZE; idx++)
    {
        data = txBuff[idx];
        data = rxBuff[idx];
    }
}

/*******************************************************************************
* Function Name: DmaRxConfiguration
********************************************************************************
*
* Summary:
*  Configures the DMA transfer for the Rx direction.
*   
* Parameters:
*  None.
*
* Return:
*  None.
*
*******************************************************************************/
void DmaRxConfiguration(void)
{
    /* 
    *   I2S_DMA Setup
    *   Source address= I2S result register: I2S_1_RX_CH0_F0_PTR
    *   Destination Address= Memory buffer in RAM : OutBuffer
    */
    RxDMA_Start((void *)I2S_1_RX_CH0_F0_PTR, (void *)rxBuff);
    RxDMA_SetNumDataElements(0, BUFFER_SIZE);
}

/*******************************************************************************
* Function Name: DmaTxConfiguration
********************************************************************************
*
* Summary:
*  Configures the DMA transfer for the Tx direction.
*   
* Parameters:
*  None.
*
* Return:
*  None.
*
*******************************************************************************/
void DmaTxConfiguration(void)
{
    TxDMA_Start((void *)txBuff, (void *)I2S_1_TX_CH0_F0_PTR);
    TxDMA_SetNumDataElements(0, BUFFER_SIZE);
}


/* [] END OF FILE */
