;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME:   DirectionPin.asm
;;  Version: 1.40, Updated on 2012/3/2 at 9:14:50
;;  Generated by PSoC Designer 5.2.2551
;;
;;  DESCRIPTION: LED user module.
;;
;;
;;  NOTE: User Module APIs conform to the fastcall16 convention for marshalling
;;        arguments and observe the associated "Registers are volatile" policy.
;;        This means it is the caller's responsibility to preserve any values
;;        in the X and A registers that are still needed after the API functions
;;        returns. For Large Memory Model devices it is also the caller's 
;;        responsibility to perserve any value in the CUR_PP, IDX_PP, MVR_PP and 
;;        MVW_PP registers. Even though some of these registers may not be modified
;;        now, there is no guarantee that will remain the case in future releases.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2012. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "DirectionPin.inc"
include "memory.inc"

export _DirectionPin_Start
export  DirectionPin_Start

export _DirectionPin_Stop
export  DirectionPin_Stop

export _DirectionPin_On
export  DirectionPin_On

export _DirectionPin_Off
export  DirectionPin_Off

export _DirectionPin_Switch
export  DirectionPin_Switch

export _DirectionPin_Invert
export  DirectionPin_Invert

export _DirectionPin_GetState
export  DirectionPin_GetState


AREA UserModules (ROM, REL)


.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DirectionPin_Start(void)
;  FUNCTION NAME: DirectionPin_Stop(void)
;
;  FUNCTION NAME: DirectionPin_Switch(void)
;
;  DESCRIPTION: ( Switch )
;     Turn LED on or off     
;
;  DESCRIPTION: ( Start, Stop )
;     Turn LED off                       
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:  ( Switch )
;     A => If 0, turn off LED, if > 0 turn on LED
;
;  ARGUMENTS:  ( Start, Stop )
;      None
;
;  RETURNS:  none
;
;  SIDE EFFECTS:
;    REGISTERS ARE VOLATILE: THE A AND X REGISTERS MAY BE MODIFIED!
;
;-----------------------------------------------------------------------------
_DirectionPin_On:
 DirectionPin_On:
   mov  A,0x01
   jmp  DirectionPin_Switch 

_DirectionPin_Start:
 DirectionPin_Start:
_DirectionPin_Stop:
 DirectionPin_Stop:
_DirectionPin_Off:
 DirectionPin_Off:
   mov  A,0x00

_DirectionPin_Switch:
 DirectionPin_Switch:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_PROLOGUE RAM_USE_CLASS_2
   RAM_SETPAGE_CUR >Port_0_Data_SHADE

   or   A,0x00                                   ; Check mode
   jz   .Turn_Off_LED

.Turn_On_LED:
IF(1)                                            ; Active High Digit Drive
   or   [Port_0_Data_SHADE],DirectionPin_PinMask
ELSE                                             ; Active Low Digit Drive
   and  [Port_0_Data_SHADE],~DirectionPin_PinMask
ENDIF
   jmp  .Switch_LED

.Turn_Off_LED:
IF(1)                      ; Active High Digit Drive
   and  [Port_0_Data_SHADE],~DirectionPin_PinMask
ELSE                              ; Active Low Digit Drive
   or   [Port_0_Data_SHADE],DirectionPin_PinMask
ENDIF

.Switch_LED:
   mov  A,[Port_0_Data_SHADE]
   mov  reg[DirectionPin_PortDR],A

   RAM_EPILOGUE RAM_USE_CLASS_2
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION



.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DirectionPin_Invert(void)
;
;  DESCRIPTION:
;     Invert state of LED                               
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS:  none
;
;  SIDE EFFECTS:
;    REGISTERS ARE VOLATILE: THE A AND X REGISTERS MAY BE MODIFIED!
;
;-----------------------------------------------------------------------------
_DirectionPin_Invert:
 DirectionPin_Invert:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_PROLOGUE RAM_USE_CLASS_2
   RAM_SETPAGE_CUR >Port_0_Data_SHADE

   xor  [Port_0_Data_SHADE],DirectionPin_PinMask
   mov  A,[Port_0_Data_SHADE]
   mov  reg[DirectionPin_PortDR],A

   RAM_EPILOGUE RAM_USE_CLASS_2
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DirectionPin_GetState(void)
;
;  DESCRIPTION:
;     Get state of LED
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS:  
;    State of LED   1 = ON,  0 = OFF
;
;  SIDE EFFECTS:
;    REGISTERS ARE VOLATILE: THE A AND X REGISTERS MAY BE MODIFIED!
;
;-----------------------------------------------------------------------------
_DirectionPin_GetState:
 DirectionPin_GetState:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_PROLOGUE RAM_USE_CLASS_2
   RAM_SETPAGE_CUR >Port_0_Data_SHADE

   mov   A,[Port_0_Data_SHADE]         ; Get shade value
IF(1)                                  ; Active High Digit Drive
   // Nothing for now
ELSE                                   ; Active Low Digit Drive
   cpl   A                             ; Invert bit if Active low
ENDIF
   and   A,DirectionPin_PinMask        ; Mask off the trash
   jz    .End_LED_GS                   ; If zero, we're done
   mov   A,0x01                        ; Return a 1 no mater what the mask is.

.End_LED_GS:
   RAM_EPILOGUE RAM_USE_CLASS_2
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION
